/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum MaxApduLengthAccepted {
  MINIMUM_MESSAGE_SIZE((byte) 0x0, (int) 50),
  NUM_OCTETS_128((byte) 0x1, (int) 128),
  NUM_OCTETS_206((byte) 0x2, (int) 206),
  NUM_OCTETS_480((byte) 0x3, (int) 480),
  NUM_OCTETS_1024((byte) 0x4, (int) 1024),
  NUM_OCTETS_1476((byte) 0x5, (int) 1476),
  RESERVED_BY_ASHRAE_01((byte) 0x6, (int) 0),
  RESERVED_BY_ASHRAE_02((byte) 0x7, (int) 0),
  RESERVED_BY_ASHRAE_03((byte) 0x8, (int) 0),
  RESERVED_BY_ASHRAE_04((byte) 0x9, (int) 0),
  RESERVED_BY_ASHRAE_05((byte) 0xA, (int) 0),
  RESERVED_BY_ASHRAE_06((byte) 0xB, (int) 0),
  RESERVED_BY_ASHRAE_07((byte) 0xC, (int) 0),
  RESERVED_BY_ASHRAE_08((byte) 0xD, (int) 0),
  RESERVED_BY_ASHRAE_09((byte) 0xE, (int) 0),
  RESERVED_BY_ASHRAE_10((byte) 0xF, (int) 0);
  private static final Map<Byte, MaxApduLengthAccepted> map;

  static {
    map = new HashMap<>();
    for (MaxApduLengthAccepted value : MaxApduLengthAccepted.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private final byte value;
  private final int numberOfOctets;

  MaxApduLengthAccepted(byte value, int numberOfOctets) {
    this.value = value;
    this.numberOfOctets = numberOfOctets;
  }

  public byte getValue() {
    return value;
  }

  public int getNumberOfOctets() {
    return numberOfOctets;
  }

  public static MaxApduLengthAccepted firstEnumForFieldNumberOfOctets(int fieldValue) {
    for (MaxApduLengthAccepted _val : MaxApduLengthAccepted.values()) {
      if (_val.getNumberOfOctets() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<MaxApduLengthAccepted> enumsForFieldNumberOfOctets(int fieldValue) {
    List<MaxApduLengthAccepted> _values = new ArrayList<>();
    for (MaxApduLengthAccepted _val : MaxApduLengthAccepted.values()) {
      if (_val.getNumberOfOctets() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static MaxApduLengthAccepted enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
