/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ReceiveQosDataType is the corresponding interface of ReceiveQosDataType
type ReceiveQosDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// IsReceiveQosDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReceiveQosDataType()
	// CreateBuilder creates a ReceiveQosDataTypeBuilder
	CreateReceiveQosDataTypeBuilder() ReceiveQosDataTypeBuilder
}

// _ReceiveQosDataType is the data-structure of this message
type _ReceiveQosDataType struct {
	ExtensionObjectDefinitionContract
}

var _ ReceiveQosDataType = (*_ReceiveQosDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ReceiveQosDataType)(nil)

// NewReceiveQosDataType factory function for _ReceiveQosDataType
func NewReceiveQosDataType() *_ReceiveQosDataType {
	_result := &_ReceiveQosDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ReceiveQosDataTypeBuilder is a builder for ReceiveQosDataType
type ReceiveQosDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ReceiveQosDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ReceiveQosDataType or returns an error if something is wrong
	Build() (ReceiveQosDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ReceiveQosDataType
}

// NewReceiveQosDataTypeBuilder() creates a ReceiveQosDataTypeBuilder
func NewReceiveQosDataTypeBuilder() ReceiveQosDataTypeBuilder {
	return &_ReceiveQosDataTypeBuilder{_ReceiveQosDataType: new(_ReceiveQosDataType)}
}

type _ReceiveQosDataTypeBuilder struct {
	*_ReceiveQosDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (ReceiveQosDataTypeBuilder) = (*_ReceiveQosDataTypeBuilder)(nil)

func (b *_ReceiveQosDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ReceiveQosDataType
}

func (b *_ReceiveQosDataTypeBuilder) WithMandatoryFields() ReceiveQosDataTypeBuilder {
	return b
}

func (b *_ReceiveQosDataTypeBuilder) Build() (ReceiveQosDataType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ReceiveQosDataType.deepCopy(), nil
}

func (b *_ReceiveQosDataTypeBuilder) MustBuild() ReceiveQosDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReceiveQosDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ReceiveQosDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ReceiveQosDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateReceiveQosDataTypeBuilder().(*_ReceiveQosDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateReceiveQosDataTypeBuilder creates a ReceiveQosDataTypeBuilder
func (b *_ReceiveQosDataType) CreateReceiveQosDataTypeBuilder() ReceiveQosDataTypeBuilder {
	if b == nil {
		return NewReceiveQosDataTypeBuilder()
	}
	return &_ReceiveQosDataTypeBuilder{_ReceiveQosDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ReceiveQosDataType) GetExtensionId() int32 {
	return int32(23610)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ReceiveQosDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

// Deprecated: use the interface for direct cast
func CastReceiveQosDataType(structType any) ReceiveQosDataType {
	if casted, ok := structType.(ReceiveQosDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ReceiveQosDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ReceiveQosDataType) GetTypeName() string {
	return "ReceiveQosDataType"
}

func (m *_ReceiveQosDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ReceiveQosDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ReceiveQosDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__receiveQosDataType ReceiveQosDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ReceiveQosDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReceiveQosDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ReceiveQosDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReceiveQosDataType")
	}

	return m, nil
}

func (m *_ReceiveQosDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReceiveQosDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ReceiveQosDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ReceiveQosDataType")
		}

		if popErr := writeBuffer.PopContext("ReceiveQosDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ReceiveQosDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ReceiveQosDataType) IsReceiveQosDataType() {}

func (m *_ReceiveQosDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ReceiveQosDataType) deepCopy() *_ReceiveQosDataType {
	if m == nil {
		return nil
	}
	_ReceiveQosDataTypeCopy := &_ReceiveQosDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
	}
	_ReceiveQosDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ReceiveQosDataTypeCopy
}

func (m *_ReceiveQosDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
