/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// GenericAttributeValue is the corresponding interface of GenericAttributeValue
type GenericAttributeValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetAttributeId returns AttributeId (property field)
	GetAttributeId() uint32
	// GetValue returns Value (property field)
	GetValue() Variant
	// IsGenericAttributeValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsGenericAttributeValue()
	// CreateBuilder creates a GenericAttributeValueBuilder
	CreateGenericAttributeValueBuilder() GenericAttributeValueBuilder
}

// _GenericAttributeValue is the data-structure of this message
type _GenericAttributeValue struct {
	ExtensionObjectDefinitionContract
	AttributeId uint32
	Value       Variant
}

var _ GenericAttributeValue = (*_GenericAttributeValue)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_GenericAttributeValue)(nil)

// NewGenericAttributeValue factory function for _GenericAttributeValue
func NewGenericAttributeValue(attributeId uint32, value Variant) *_GenericAttributeValue {
	if value == nil {
		panic("value of type Variant for GenericAttributeValue must not be nil")
	}
	_result := &_GenericAttributeValue{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		AttributeId:                       attributeId,
		Value:                             value,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// GenericAttributeValueBuilder is a builder for GenericAttributeValue
type GenericAttributeValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(attributeId uint32, value Variant) GenericAttributeValueBuilder
	// WithAttributeId adds AttributeId (property field)
	WithAttributeId(uint32) GenericAttributeValueBuilder
	// WithValue adds Value (property field)
	WithValue(Variant) GenericAttributeValueBuilder
	// WithValueBuilder adds Value (property field) which is build by the builder
	WithValueBuilder(func(VariantBuilder) VariantBuilder) GenericAttributeValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the GenericAttributeValue or returns an error if something is wrong
	Build() (GenericAttributeValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() GenericAttributeValue
}

// NewGenericAttributeValueBuilder() creates a GenericAttributeValueBuilder
func NewGenericAttributeValueBuilder() GenericAttributeValueBuilder {
	return &_GenericAttributeValueBuilder{_GenericAttributeValue: new(_GenericAttributeValue)}
}

type _GenericAttributeValueBuilder struct {
	*_GenericAttributeValue

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (GenericAttributeValueBuilder) = (*_GenericAttributeValueBuilder)(nil)

func (b *_GenericAttributeValueBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._GenericAttributeValue
}

func (b *_GenericAttributeValueBuilder) WithMandatoryFields(attributeId uint32, value Variant) GenericAttributeValueBuilder {
	return b.WithAttributeId(attributeId).WithValue(value)
}

func (b *_GenericAttributeValueBuilder) WithAttributeId(attributeId uint32) GenericAttributeValueBuilder {
	b.AttributeId = attributeId
	return b
}

func (b *_GenericAttributeValueBuilder) WithValue(value Variant) GenericAttributeValueBuilder {
	b.Value = value
	return b
}

func (b *_GenericAttributeValueBuilder) WithValueBuilder(builderSupplier func(VariantBuilder) VariantBuilder) GenericAttributeValueBuilder {
	builder := builderSupplier(b.Value.CreateVariantBuilder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_GenericAttributeValueBuilder) Build() (GenericAttributeValue, error) {
	if b.Value == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'value' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._GenericAttributeValue.deepCopy(), nil
}

func (b *_GenericAttributeValueBuilder) MustBuild() GenericAttributeValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_GenericAttributeValueBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_GenericAttributeValueBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_GenericAttributeValueBuilder) DeepCopy() any {
	_copy := b.CreateGenericAttributeValueBuilder().(*_GenericAttributeValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateGenericAttributeValueBuilder creates a GenericAttributeValueBuilder
func (b *_GenericAttributeValue) CreateGenericAttributeValueBuilder() GenericAttributeValueBuilder {
	if b == nil {
		return NewGenericAttributeValueBuilder()
	}
	return &_GenericAttributeValueBuilder{_GenericAttributeValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_GenericAttributeValue) GetExtensionId() int32 {
	return int32(17608)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_GenericAttributeValue) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_GenericAttributeValue) GetAttributeId() uint32 {
	return m.AttributeId
}

func (m *_GenericAttributeValue) GetValue() Variant {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastGenericAttributeValue(structType any) GenericAttributeValue {
	if casted, ok := structType.(GenericAttributeValue); ok {
		return casted
	}
	if casted, ok := structType.(*GenericAttributeValue); ok {
		return *casted
	}
	return nil
}

func (m *_GenericAttributeValue) GetTypeName() string {
	return "GenericAttributeValue"
}

func (m *_GenericAttributeValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (attributeId)
	lengthInBits += 32

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_GenericAttributeValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_GenericAttributeValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__genericAttributeValue GenericAttributeValue, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("GenericAttributeValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for GenericAttributeValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	attributeId, err := ReadSimpleField(ctx, "attributeId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'attributeId' field"))
	}
	m.AttributeId = attributeId

	value, err := ReadSimpleField[Variant](ctx, "value", ReadComplex[Variant](VariantParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("GenericAttributeValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for GenericAttributeValue")
	}

	return m, nil
}

func (m *_GenericAttributeValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_GenericAttributeValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("GenericAttributeValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for GenericAttributeValue")
		}

		if err := WriteSimpleField[uint32](ctx, "attributeId", m.GetAttributeId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'attributeId' field")
		}

		if err := WriteSimpleField[Variant](ctx, "value", m.GetValue(), WriteComplex[Variant](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("GenericAttributeValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for GenericAttributeValue")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_GenericAttributeValue) IsGenericAttributeValue() {}

func (m *_GenericAttributeValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_GenericAttributeValue) deepCopy() *_GenericAttributeValue {
	if m == nil {
		return nil
	}
	_GenericAttributeValueCopy := &_GenericAttributeValue{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.AttributeId,
		utils.DeepCopy[Variant](m.Value),
	}
	_GenericAttributeValueCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _GenericAttributeValueCopy
}

func (m *_GenericAttributeValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
