/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduControlDisconnect is the corresponding interface of ApduControlDisconnect
type ApduControlDisconnect interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduControl
	// IsApduControlDisconnect is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduControlDisconnect()
	// CreateBuilder creates a ApduControlDisconnectBuilder
	CreateApduControlDisconnectBuilder() ApduControlDisconnectBuilder
}

// _ApduControlDisconnect is the data-structure of this message
type _ApduControlDisconnect struct {
	ApduControlContract
}

var _ ApduControlDisconnect = (*_ApduControlDisconnect)(nil)
var _ ApduControlRequirements = (*_ApduControlDisconnect)(nil)

// NewApduControlDisconnect factory function for _ApduControlDisconnect
func NewApduControlDisconnect() *_ApduControlDisconnect {
	_result := &_ApduControlDisconnect{
		ApduControlContract: NewApduControl(),
	}
	_result.ApduControlContract.(*_ApduControl)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduControlDisconnectBuilder is a builder for ApduControlDisconnect
type ApduControlDisconnectBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduControlDisconnectBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduControlBuilder
	// Build builds the ApduControlDisconnect or returns an error if something is wrong
	Build() (ApduControlDisconnect, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduControlDisconnect
}

// NewApduControlDisconnectBuilder() creates a ApduControlDisconnectBuilder
func NewApduControlDisconnectBuilder() ApduControlDisconnectBuilder {
	return &_ApduControlDisconnectBuilder{_ApduControlDisconnect: new(_ApduControlDisconnect)}
}

type _ApduControlDisconnectBuilder struct {
	*_ApduControlDisconnect

	parentBuilder *_ApduControlBuilder

	collectedErr []error
}

var _ (ApduControlDisconnectBuilder) = (*_ApduControlDisconnectBuilder)(nil)

func (b *_ApduControlDisconnectBuilder) setParent(contract ApduControlContract) {
	b.ApduControlContract = contract
	contract.(*_ApduControl)._SubType = b._ApduControlDisconnect
}

func (b *_ApduControlDisconnectBuilder) WithMandatoryFields() ApduControlDisconnectBuilder {
	return b
}

func (b *_ApduControlDisconnectBuilder) Build() (ApduControlDisconnect, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApduControlDisconnect.deepCopy(), nil
}

func (b *_ApduControlDisconnectBuilder) MustBuild() ApduControlDisconnect {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduControlDisconnectBuilder) Done() ApduControlBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduControlBuilder().(*_ApduControlBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduControlDisconnectBuilder) buildForApduControl() (ApduControl, error) {
	return b.Build()
}

func (b *_ApduControlDisconnectBuilder) DeepCopy() any {
	_copy := b.CreateApduControlDisconnectBuilder().(*_ApduControlDisconnectBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApduControlDisconnectBuilder creates a ApduControlDisconnectBuilder
func (b *_ApduControlDisconnect) CreateApduControlDisconnectBuilder() ApduControlDisconnectBuilder {
	if b == nil {
		return NewApduControlDisconnectBuilder()
	}
	return &_ApduControlDisconnectBuilder{_ApduControlDisconnect: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduControlDisconnect) GetControlType() uint8 {
	return 0x1
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduControlDisconnect) GetParent() ApduControlContract {
	return m.ApduControlContract
}

// Deprecated: use the interface for direct cast
func CastApduControlDisconnect(structType any) ApduControlDisconnect {
	if casted, ok := structType.(ApduControlDisconnect); ok {
		return casted
	}
	if casted, ok := structType.(*ApduControlDisconnect); ok {
		return *casted
	}
	return nil
}

func (m *_ApduControlDisconnect) GetTypeName() string {
	return "ApduControlDisconnect"
}

func (m *_ApduControlDisconnect) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduControlContract.(*_ApduControl).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduControlDisconnect) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduControlDisconnect) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduControl) (__apduControlDisconnect ApduControlDisconnect, err error) {
	m.ApduControlContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduControlDisconnect"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduControlDisconnect")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduControlDisconnect"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduControlDisconnect")
	}

	return m, nil
}

func (m *_ApduControlDisconnect) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduControlDisconnect) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduControlDisconnect"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduControlDisconnect")
		}

		if popErr := writeBuffer.PopContext("ApduControlDisconnect"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduControlDisconnect")
		}
		return nil
	}
	return m.ApduControlContract.(*_ApduControl).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduControlDisconnect) IsApduControlDisconnect() {}

func (m *_ApduControlDisconnect) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduControlDisconnect) deepCopy() *_ApduControlDisconnect {
	if m == nil {
		return nil
	}
	_ApduControlDisconnectCopy := &_ApduControlDisconnect{
		m.ApduControlContract.(*_ApduControl).deepCopy(),
	}
	_ApduControlDisconnectCopy.ApduControlContract.(*_ApduControl)._SubType = m
	return _ApduControlDisconnectCopy
}

func (m *_ApduControlDisconnect) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
