/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetCalendarEntryWeekNDay is the corresponding interface of BACnetCalendarEntryWeekNDay
type BACnetCalendarEntryWeekNDay interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetCalendarEntry
	// GetWeekNDay returns WeekNDay (property field)
	GetWeekNDay() BACnetWeekNDayTagged
	// IsBACnetCalendarEntryWeekNDay is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetCalendarEntryWeekNDay()
	// CreateBuilder creates a BACnetCalendarEntryWeekNDayBuilder
	CreateBACnetCalendarEntryWeekNDayBuilder() BACnetCalendarEntryWeekNDayBuilder
}

// _BACnetCalendarEntryWeekNDay is the data-structure of this message
type _BACnetCalendarEntryWeekNDay struct {
	BACnetCalendarEntryContract
	WeekNDay BACnetWeekNDayTagged
}

var _ BACnetCalendarEntryWeekNDay = (*_BACnetCalendarEntryWeekNDay)(nil)
var _ BACnetCalendarEntryRequirements = (*_BACnetCalendarEntryWeekNDay)(nil)

// NewBACnetCalendarEntryWeekNDay factory function for _BACnetCalendarEntryWeekNDay
func NewBACnetCalendarEntryWeekNDay(peekedTagHeader BACnetTagHeader, weekNDay BACnetWeekNDayTagged) *_BACnetCalendarEntryWeekNDay {
	if weekNDay == nil {
		panic("weekNDay of type BACnetWeekNDayTagged for BACnetCalendarEntryWeekNDay must not be nil")
	}
	_result := &_BACnetCalendarEntryWeekNDay{
		BACnetCalendarEntryContract: NewBACnetCalendarEntry(peekedTagHeader),
		WeekNDay:                    weekNDay,
	}
	_result.BACnetCalendarEntryContract.(*_BACnetCalendarEntry)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetCalendarEntryWeekNDayBuilder is a builder for BACnetCalendarEntryWeekNDay
type BACnetCalendarEntryWeekNDayBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(weekNDay BACnetWeekNDayTagged) BACnetCalendarEntryWeekNDayBuilder
	// WithWeekNDay adds WeekNDay (property field)
	WithWeekNDay(BACnetWeekNDayTagged) BACnetCalendarEntryWeekNDayBuilder
	// WithWeekNDayBuilder adds WeekNDay (property field) which is build by the builder
	WithWeekNDayBuilder(func(BACnetWeekNDayTaggedBuilder) BACnetWeekNDayTaggedBuilder) BACnetCalendarEntryWeekNDayBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetCalendarEntryBuilder
	// Build builds the BACnetCalendarEntryWeekNDay or returns an error if something is wrong
	Build() (BACnetCalendarEntryWeekNDay, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetCalendarEntryWeekNDay
}

// NewBACnetCalendarEntryWeekNDayBuilder() creates a BACnetCalendarEntryWeekNDayBuilder
func NewBACnetCalendarEntryWeekNDayBuilder() BACnetCalendarEntryWeekNDayBuilder {
	return &_BACnetCalendarEntryWeekNDayBuilder{_BACnetCalendarEntryWeekNDay: new(_BACnetCalendarEntryWeekNDay)}
}

type _BACnetCalendarEntryWeekNDayBuilder struct {
	*_BACnetCalendarEntryWeekNDay

	parentBuilder *_BACnetCalendarEntryBuilder

	collectedErr []error
}

var _ (BACnetCalendarEntryWeekNDayBuilder) = (*_BACnetCalendarEntryWeekNDayBuilder)(nil)

func (b *_BACnetCalendarEntryWeekNDayBuilder) setParent(contract BACnetCalendarEntryContract) {
	b.BACnetCalendarEntryContract = contract
	contract.(*_BACnetCalendarEntry)._SubType = b._BACnetCalendarEntryWeekNDay
}

func (b *_BACnetCalendarEntryWeekNDayBuilder) WithMandatoryFields(weekNDay BACnetWeekNDayTagged) BACnetCalendarEntryWeekNDayBuilder {
	return b.WithWeekNDay(weekNDay)
}

func (b *_BACnetCalendarEntryWeekNDayBuilder) WithWeekNDay(weekNDay BACnetWeekNDayTagged) BACnetCalendarEntryWeekNDayBuilder {
	b.WeekNDay = weekNDay
	return b
}

func (b *_BACnetCalendarEntryWeekNDayBuilder) WithWeekNDayBuilder(builderSupplier func(BACnetWeekNDayTaggedBuilder) BACnetWeekNDayTaggedBuilder) BACnetCalendarEntryWeekNDayBuilder {
	builder := builderSupplier(b.WeekNDay.CreateBACnetWeekNDayTaggedBuilder())
	var err error
	b.WeekNDay, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetWeekNDayTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetCalendarEntryWeekNDayBuilder) Build() (BACnetCalendarEntryWeekNDay, error) {
	if b.WeekNDay == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'weekNDay' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetCalendarEntryWeekNDay.deepCopy(), nil
}

func (b *_BACnetCalendarEntryWeekNDayBuilder) MustBuild() BACnetCalendarEntryWeekNDay {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetCalendarEntryWeekNDayBuilder) Done() BACnetCalendarEntryBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetCalendarEntryBuilder().(*_BACnetCalendarEntryBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetCalendarEntryWeekNDayBuilder) buildForBACnetCalendarEntry() (BACnetCalendarEntry, error) {
	return b.Build()
}

func (b *_BACnetCalendarEntryWeekNDayBuilder) DeepCopy() any {
	_copy := b.CreateBACnetCalendarEntryWeekNDayBuilder().(*_BACnetCalendarEntryWeekNDayBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetCalendarEntryWeekNDayBuilder creates a BACnetCalendarEntryWeekNDayBuilder
func (b *_BACnetCalendarEntryWeekNDay) CreateBACnetCalendarEntryWeekNDayBuilder() BACnetCalendarEntryWeekNDayBuilder {
	if b == nil {
		return NewBACnetCalendarEntryWeekNDayBuilder()
	}
	return &_BACnetCalendarEntryWeekNDayBuilder{_BACnetCalendarEntryWeekNDay: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetCalendarEntryWeekNDay) GetParent() BACnetCalendarEntryContract {
	return m.BACnetCalendarEntryContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetCalendarEntryWeekNDay) GetWeekNDay() BACnetWeekNDayTagged {
	return m.WeekNDay
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetCalendarEntryWeekNDay(structType any) BACnetCalendarEntryWeekNDay {
	if casted, ok := structType.(BACnetCalendarEntryWeekNDay); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetCalendarEntryWeekNDay); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetCalendarEntryWeekNDay) GetTypeName() string {
	return "BACnetCalendarEntryWeekNDay"
}

func (m *_BACnetCalendarEntryWeekNDay) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetCalendarEntryContract.(*_BACnetCalendarEntry).getLengthInBits(ctx))

	// Simple field (weekNDay)
	lengthInBits += m.WeekNDay.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetCalendarEntryWeekNDay) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetCalendarEntryWeekNDay) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetCalendarEntry) (__bACnetCalendarEntryWeekNDay BACnetCalendarEntryWeekNDay, err error) {
	m.BACnetCalendarEntryContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetCalendarEntryWeekNDay"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetCalendarEntryWeekNDay")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	weekNDay, err := ReadSimpleField[BACnetWeekNDayTagged](ctx, "weekNDay", ReadComplex[BACnetWeekNDayTagged](BACnetWeekNDayTaggedParseWithBufferProducer((uint8)(uint8(2)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'weekNDay' field"))
	}
	m.WeekNDay = weekNDay

	if closeErr := readBuffer.CloseContext("BACnetCalendarEntryWeekNDay"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetCalendarEntryWeekNDay")
	}

	return m, nil
}

func (m *_BACnetCalendarEntryWeekNDay) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetCalendarEntryWeekNDay) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetCalendarEntryWeekNDay"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetCalendarEntryWeekNDay")
		}

		if err := WriteSimpleField[BACnetWeekNDayTagged](ctx, "weekNDay", m.GetWeekNDay(), WriteComplex[BACnetWeekNDayTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'weekNDay' field")
		}

		if popErr := writeBuffer.PopContext("BACnetCalendarEntryWeekNDay"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetCalendarEntryWeekNDay")
		}
		return nil
	}
	return m.BACnetCalendarEntryContract.(*_BACnetCalendarEntry).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetCalendarEntryWeekNDay) IsBACnetCalendarEntryWeekNDay() {}

func (m *_BACnetCalendarEntryWeekNDay) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetCalendarEntryWeekNDay) deepCopy() *_BACnetCalendarEntryWeekNDay {
	if m == nil {
		return nil
	}
	_BACnetCalendarEntryWeekNDayCopy := &_BACnetCalendarEntryWeekNDay{
		m.BACnetCalendarEntryContract.(*_BACnetCalendarEntry).deepCopy(),
		utils.DeepCopy[BACnetWeekNDayTagged](m.WeekNDay),
	}
	_BACnetCalendarEntryWeekNDayCopy.BACnetCalendarEntryContract.(*_BACnetCalendarEntry)._SubType = m
	return _BACnetCalendarEntryWeekNDayCopy
}

func (m *_BACnetCalendarEntryWeekNDay) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
