/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor.servlets.trace;

import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.trace.TraceFormatter;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.monitor.Monitor;
import org.apache.accumulo.server.monitor.servlets.BasicServlet;
import org.apache.accumulo.server.monitor.servlets.trace.NullScanner;
import org.apache.accumulo.start.classloader.AccumuloClassLoader;

abstract class Basic
extends BasicServlet {
    private static final long serialVersionUID = 1L;

    Basic() {
    }

    public static String getStringParameter(HttpServletRequest req, String name, String defaultValue) {
        String result = req.getParameter(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static int getIntParameter(HttpServletRequest req, String name, int defaultMinutes) {
        String valueString = req.getParameter(name);
        if (valueString == null) {
            return defaultMinutes;
        }
        int result = 0;
        try {
            result = Integer.parseInt(valueString);
        }
        catch (NumberFormatException ex) {
            return defaultMinutes;
        }
        return result;
    }

    public static String dateString(long millis) {
        return TraceFormatter.formatDate((Date)new Date(millis));
    }

    protected Scanner getScanner(StringBuilder sb) throws AccumuloException, AccumuloSecurityException {
        PasswordToken at;
        AccumuloConfiguration conf = Monitor.getSystemConfiguration();
        String principal = conf.get(Property.TRACE_USER);
        Map loginMap = conf.getAllPropertiesWithPrefix(Property.TRACE_TOKEN_PROPERTY_PREFIX);
        if (loginMap.isEmpty()) {
            Property p = Property.TRACE_PASSWORD;
            at = new PasswordToken(conf.get(p).getBytes());
        } else {
            AuthenticationToken token;
            AuthenticationToken.Properties props = new AuthenticationToken.Properties();
            int prefixLength = Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey().length() + 1;
            for (Map.Entry entry : loginMap.entrySet()) {
                props.put(((String)entry.getKey()).substring(prefixLength), (CharSequence)entry.getValue());
            }
            try {
                token = AccumuloClassLoader.getClassLoader().loadClass(conf.get(Property.TRACE_TOKEN_TYPE)).asSubclass(AuthenticationToken.class).newInstance();
            }
            catch (Exception e) {
                throw new AccumuloException((Throwable)e);
            }
            token.init(props);
            at = token;
        }
        String table = conf.get(Property.TRACE_TABLE);
        try {
            Connector conn = HdfsZooInstance.getInstance().getConnector(principal, (AuthenticationToken)at);
            if (!conn.tableOperations().exists(table)) {
                return new NullScanner();
            }
            Scanner scanner = conn.createScanner(table, conn.securityOperations().getUserAuthorizations(principal));
            return scanner;
        }
        catch (AccumuloSecurityException ex) {
            sb.append("<h2>Unable to read trace table: check trace username and password configuration.</h2>\n");
            return null;
        }
        catch (TableNotFoundException ex) {
            return new NullScanner();
        }
    }
}

