/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.ExportInfo;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.accumulo.server.master.tableOps.WriteExportFiles;
import org.apache.hadoop.fs.Path;

public class ExportTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private final ExportInfo tableInfo = new ExportInfo();
    public static final int VERSION = 1;
    public static final String DATA_VERSION_PROP = "srcDataVersion";
    public static final String EXPORT_VERSION_PROP = "exportVersion";

    public ExportTable(String tableName, String tableId, String exportDir) {
        this.tableInfo.tableName = tableName;
        this.tableInfo.exportDir = exportDir;
        this.tableInfo.tableID = tableId;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveHdfsDirectory(new Path(this.tableInfo.exportDir).toString(), tid);
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        return new WriteExportFiles(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveHdfsDirectory(new Path(this.tableInfo.exportDir).toString(), tid);
    }
}

