/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputFailedEvent;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.InputIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputAllocator;
import org.apache.tez.runtime.library.common.shuffle.ShuffleEventHandler;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleManager;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleInputEventHandlerImpl
implements ShuffleEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleInputEventHandlerImpl.class);
    private final ShuffleManager shuffleManager;
    private final FetchedInputAllocator inputAllocator;
    private final CompressionCodec codec;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    private final boolean useSharedInputs;

    public ShuffleInputEventHandlerImpl(InputContext inputContext, ShuffleManager shuffleManager, FetchedInputAllocator inputAllocator, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength) {
        this.shuffleManager = shuffleManager;
        this.inputAllocator = inputAllocator;
        this.codec = codec;
        this.ifileReadAhead = ifileReadAhead;
        this.ifileReadAheadLength = ifileReadAheadLength;
        this.useSharedInputs = inputContext.getTaskAttemptNumber() == 0;
    }

    @Override
    public void handleEvents(List<Event> events) throws IOException {
        for (Event event : events) {
            this.handleEvent(event);
        }
    }

    private void handleEvent(Event event) throws IOException {
        if (event instanceof DataMovementEvent) {
            this.processDataMovementEvent((DataMovementEvent)event);
            this.shuffleManager.updateEventReceivedTime();
        } else if (event instanceof InputFailedEvent) {
            this.processInputFailedEvent((InputFailedEvent)event);
        } else {
            throw new TezUncheckedException("Unexpected event type: " + event.getClass().getName());
        }
    }

    private void processDataMovementEvent(DataMovementEvent dme) throws IOException {
        byte[] emptyPartitions;
        BitSet emptyPartionsBitSet;
        ShuffleUserPayloads.DataMovementEventPayloadProto shufflePayload;
        try {
            shufflePayload = ShuffleUserPayloads.DataMovementEventPayloadProto.parseFrom(ByteString.copyFrom((ByteBuffer)dme.getUserPayload()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new TezUncheckedException("Unable to parse DataMovementEvent payload", (Throwable)e);
        }
        int srcIndex = dme.getSourceIndex();
        LOG.info("DME srcIdx: " + srcIndex + ", targetIndex: " + dme.getTargetIndex() + ", attemptNum: " + dme.getVersion() + ", payload: " + ShuffleUtils.stringify(shufflePayload));
        if (shufflePayload.hasEmptyPartitions() && (emptyPartionsBitSet = TezUtilsInternal.fromByteArray((byte[])(emptyPartitions = TezCommonUtils.decompressByteStringToByteArray((ByteString)shufflePayload.getEmptyPartitions())))).get(srcIndex)) {
            InputAttemptIdentifier srcAttemptIdentifier = this.constructInputAttemptIdentifier(dme, shufflePayload, false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Source partition: " + srcIndex + " did not generate any data. SrcAttempt: [" + srcAttemptIdentifier + "]. Not fetching.");
            }
            this.shuffleManager.addCompletedInputWithNoData(srcAttemptIdentifier);
            return;
        }
        InputAttemptIdentifier srcAttemptIdentifier = this.constructInputAttemptIdentifier(dme, shufflePayload, this.useSharedInputs && srcIndex == 0);
        this.shuffleManager.addKnownInput(shufflePayload.getHost(), shufflePayload.getPort(), srcAttemptIdentifier, srcIndex);
    }

    private void processInputFailedEvent(InputFailedEvent ife) {
        InputAttemptIdentifier srcAttemptIdentifier = new InputAttemptIdentifier(ife.getTargetIndex(), ife.getVersion());
        this.shuffleManager.obsoleteKnownInput(srcAttemptIdentifier);
    }

    private InputAttemptIdentifier constructInputAttemptIdentifier(DataMovementEvent dmEvent, ShuffleUserPayloads.DataMovementEventPayloadProto shufflePayload, boolean isShared) {
        String pathComponent = shufflePayload.hasPathComponent() ? shufflePayload.getPathComponent() : null;
        InputAttemptIdentifier srcAttemptIdentifier = null;
        if (shufflePayload.hasSpillId()) {
            int spillEventId = shufflePayload.getSpillId();
            boolean lastEvent = shufflePayload.getLastEvent();
            InputAttemptIdentifier.SPILL_INFO spillInfo = lastEvent ? InputAttemptIdentifier.SPILL_INFO.FINAL_UPDATE : InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE;
            srcAttemptIdentifier = new InputAttemptIdentifier(new InputIdentifier(dmEvent.getTargetIndex()), dmEvent.getVersion(), pathComponent, isShared, spillInfo, spillEventId);
        } else {
            srcAttemptIdentifier = new InputAttemptIdentifier(dmEvent.getTargetIndex(), dmEvent.getVersion(), pathComponent, isShared);
        }
        return srcAttemptIdentifier;
    }
}

