/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.hadoop.io.Text;

public class BinaryFormatter
implements Formatter {
    private Iterator<Map.Entry<Key, Value>> si;
    private boolean doTimestamps;
    private static int showLength;

    @Override
    public void initialize(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps) {
        BinaryFormatter.checkState(this.si, false);
        this.si = scanner.iterator();
        this.doTimestamps = printTimestamps;
    }

    @Override
    public boolean hasNext() {
        BinaryFormatter.checkState(this.si, true);
        return this.si.hasNext();
    }

    @Override
    public String next() {
        BinaryFormatter.checkState(this.si, true);
        return BinaryFormatter.formatEntry(this.si.next(), this.doTimestamps);
    }

    @Override
    public void remove() {
        BinaryFormatter.checkState(this.si, true);
        this.si.remove();
    }

    static void checkState(Iterator<Map.Entry<Key, Value>> si, boolean expectInitialized) {
        if (expectInitialized && si == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (!expectInitialized && si != null) {
            throw new IllegalStateException("Already initialized");
        }
    }

    public static String formatEntry(Map.Entry<Key, Value> entry, boolean showTimestamps) {
        StringBuilder sb = new StringBuilder();
        BinaryFormatter.appendText(sb, entry.getKey().getRow()).append(" ");
        BinaryFormatter.appendText(sb, entry.getKey().getColumnFamily()).append(":");
        BinaryFormatter.appendText(sb, entry.getKey().getColumnQualifier()).append(" ");
        sb.append(new ColumnVisibility(entry.getKey().getColumnVisibility()));
        if (showTimestamps) {
            sb.append(" ").append(entry.getKey().getTimestamp());
        }
        if (entry.getValue() != null && entry.getValue().getSize() > 0) {
            sb.append("\t");
            BinaryFormatter.appendValue(sb, entry.getValue());
        }
        return sb.toString();
    }

    public static StringBuilder appendText(StringBuilder sb, Text t) {
        return BinaryFormatter.appendBytes(sb, t.getBytes(), 0, t.getLength());
    }

    static StringBuilder appendValue(StringBuilder sb, Value value) {
        return BinaryFormatter.appendBytes(sb, value.get(), 0, value.get().length);
    }

    static StringBuilder appendBytes(StringBuilder sb, byte[] ba, int offset, int len) {
        if (len > showLength) {
            for (int i = 0; i < showLength; ++i) {
                int c = 0xFF & ba[offset + i];
                if (c == 92) {
                    sb.append("\\\\");
                    continue;
                }
                if (c >= 32 && c <= 126) {
                    sb.append((char)c);
                    continue;
                }
                sb.append("\\x").append(String.format("%02X", c));
            }
            return sb;
        }
        for (int i = 0; i < len; ++i) {
            int c = 0xFF & ba[offset + i];
            if (c == 92) {
                sb.append("\\\\");
                continue;
            }
            if (c >= 32 && c <= 126) {
                sb.append((char)c);
                continue;
            }
            sb.append("\\x").append(String.format("%02X", c));
        }
        return sb;
    }

    public Iterator<Map.Entry<Key, Value>> getScannerIterator() {
        return this.si;
    }

    public static void getlength(int length) {
        showLength = length;
    }
}

