/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.JumpInstruction;
import serp.bytecode.visitor.BCVisitor;

public class TableSwitchInstruction
extends JumpInstruction {
    private int _low = 0;
    private int _high = 0;
    private List _cases = new LinkedList();

    TableSwitchInstruction(Code owner) {
        super(owner, 170);
    }

    public int[] getOffsets() {
        int bi = this.getByteIndex();
        int[] offsets = new int[this._cases.size()];
        for (int i = 0; i < this._cases.size(); ++i) {
            offsets[i] = ((InstructionPtrStrategy)this._cases.get(i)).getByteIndex() - bi;
        }
        return offsets;
    }

    public void setOffsets(int[] offsets) {
        int bi = this.getByteIndex();
        this._cases.clear();
        for (int i = 0; i < offsets.length; ++i) {
            InstructionPtrStrategy next = new InstructionPtrStrategy(this);
            next.setByteIndex(offsets[i] + bi);
            this._cases.add(next);
        }
        this.invalidateByteIndexes();
    }

    @Override
    int getLength() {
        int length = 1;
        int byteIndex = this.getByteIndex() + 1;
        while (byteIndex % 4 != 0) {
            ++byteIndex;
            ++length;
        }
        length += 12;
        return length += 4 * this._cases.size();
    }

    public Instruction getDefaultTarget() {
        return this.getTarget();
    }

    public TableSwitchInstruction setDefaultTarget(Instruction ins) {
        return (TableSwitchInstruction)this.setTarget(ins);
    }

    public int getDefaultOffset() {
        return this.getOffset();
    }

    public TableSwitchInstruction setDefaultOffset(int offset) {
        this.setOffset(offset);
        return this;
    }

    public int getLow() {
        return this._low;
    }

    public TableSwitchInstruction setLow(int low) {
        this._low = low;
        return this;
    }

    public int getHigh() {
        return this._high;
    }

    public TableSwitchInstruction setHigh(int high) {
        this._high = high;
        return this;
    }

    public Instruction[] getTargets() {
        Instruction[] result = new Instruction[this._cases.size()];
        for (int i = 0; i < this._cases.size(); ++i) {
            result[i] = ((InstructionPtrStrategy)this._cases.get(i)).getTargetInstruction();
        }
        return result;
    }

    public TableSwitchInstruction setTargets(Instruction[] targets) {
        this._cases.clear();
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                this.addTarget(targets[i]);
            }
        }
        return this;
    }

    public TableSwitchInstruction addTarget(Instruction target) {
        this._cases.add(new InstructionPtrStrategy(this, target));
        this.invalidateByteIndexes();
        return this;
    }

    @Override
    public int getStackChange() {
        return -1;
    }

    private Instruction findTarget(int jumpByteIndex, List inss) {
        for (Instruction ins : inss) {
            if (ins.getByteIndex() != jumpByteIndex) continue;
            return ins;
        }
        return null;
    }

    @Override
    public void updateTargets() {
        super.updateTargets();
        Iterator itr = this._cases.iterator();
        while (itr.hasNext()) {
            ((InstructionPtrStrategy)itr.next()).updateTargets();
        }
    }

    @Override
    public void replaceTarget(Instruction oldTarget, Instruction newTarget) {
        super.replaceTarget(oldTarget, newTarget);
        Iterator itr = this._cases.iterator();
        while (itr.hasNext()) {
            ((InstructionPtrStrategy)itr.next()).replaceTarget(oldTarget, newTarget);
        }
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterTableSwitchInstruction(this);
        visit.exitTableSwitchInstruction(this);
    }

    @Override
    void read(Instruction orig) {
        super.read(orig);
        TableSwitchInstruction ins = (TableSwitchInstruction)orig;
        this.setLow(ins.getLow());
        this.setHigh(ins.getHigh());
        for (InstructionPtrStrategy incoming : ins._cases) {
            InstructionPtrStrategy next = new InstructionPtrStrategy(this);
            next.setByteIndex(incoming.getByteIndex());
            this._cases.add(next);
        }
        this.invalidateByteIndexes();
    }

    @Override
    void read(DataInput in) throws IOException {
        int bi = this.getByteIndex();
        int byteIndex = bi + 1;
        while (byteIndex % 4 != 0) {
            in.readByte();
            ++byteIndex;
        }
        this.setOffset(in.readInt());
        this.setLow(in.readInt());
        this.setHigh(in.readInt());
        this._cases.clear();
        for (int i = 0; i < this._high - this._low + 1; ++i) {
            InstructionPtrStrategy next = new InstructionPtrStrategy(this);
            next.setByteIndex(bi + in.readInt());
            this._cases.add(next);
        }
    }

    @Override
    void write(DataOutput out) throws IOException {
        int bi = this.getByteIndex();
        int byteIndex = bi + 1;
        while (byteIndex % 4 != 0) {
            out.writeByte(0);
            ++byteIndex;
        }
        out.writeInt(this.getOffset());
        out.writeInt(this.getLow());
        out.writeInt(this.getHigh());
        Iterator itr = this._cases.iterator();
        while (itr.hasNext()) {
            out.writeInt(((InstructionPtrStrategy)itr.next()).getByteIndex() - bi);
        }
    }
}

