/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.xml;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Payload;
import javax.validation.ValidationException;
import org.apache.bval.jsr303.ConstraintAnnotationAttributes;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.jsr303.xml.AnnotationProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationProxyBuilder<A extends Annotation> {
    private final Class<A> type;
    private final Map<String, Object> elements = new HashMap<String, Object>();

    public AnnotationProxyBuilder(Class<A> annotationType) {
        this.type = annotationType;
    }

    public AnnotationProxyBuilder(Class<A> annotationType, Map<String, Object> elements) {
        this(annotationType);
        for (Map.Entry<String, Object> entry : elements.entrySet()) {
            this.elements.put(entry.getKey(), entry.getValue());
        }
    }

    public AnnotationProxyBuilder(A annot) {
        this(annot.annotationType());
        Method[] methods;
        for (Method m : methods = AnnotationProxyBuilder.doPrivileged(SecureActions.getDeclaredMethods(annot.annotationType()))) {
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            try {
                Object value = m.invoke(annot, new Object[0]);
                this.elements.put(m.getName(), value);
            }
            catch (IllegalArgumentException e) {
                throw new ValidationException("Cannot access annotation " + annot + " element: " + m.getName());
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Cannot access annotation " + annot + " element: " + m.getName());
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Cannot access annotation " + annot + " element: " + m.getName());
            }
        }
    }

    public void putValue(String elementName, Object value) {
        this.elements.put(elementName, value);
    }

    public Object getValue(String elementName) {
        return this.elements.get(elementName);
    }

    public boolean contains(String elementName) {
        return this.elements.containsKey(elementName);
    }

    public int size() {
        return this.elements.size();
    }

    public Class<A> getType() {
        return this.type;
    }

    public void setMessage(String message) {
        ConstraintAnnotationAttributes.MESSAGE.put(this.elements, message);
    }

    public void setGroups(Class<?>[] groups) {
        ConstraintAnnotationAttributes.GROUPS.put(this.elements, groups);
    }

    public void setPayload(Class<? extends Payload>[] payload) {
        ConstraintAnnotationAttributes.PAYLOAD.put(this.elements, payload);
    }

    public A createAnnotation() {
        ClassLoader classLoader = SecureActions.getClassLoader(this.getType());
        final Class<?> proxyClass = Proxy.getProxyClass(classLoader, this.getType());
        final AnnotationProxy handler = new AnnotationProxy(this);
        return (A)((Annotation)AnnotationProxyBuilder.doPrivileged(new PrivilegedAction<A>(){

            @Override
            public A run() {
                try {
                    Constructor constructor = proxyClass.getConstructor(InvocationHandler.class);
                    return (Annotation)constructor.newInstance(handler);
                }
                catch (Exception e) {
                    throw new ValidationException("Unable to create annotation for configured constraint", e);
                }
            }
        }));
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }
}

