/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmOperationImport;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlOperationImport;
import org.apache.olingo.commons.core.edm.AbstractEdmNamed;
import org.apache.olingo.commons.core.edm.Target;

public abstract class AbstractEdmOperationImport
extends AbstractEdmNamed
implements EdmOperationImport {
    protected final EdmEntityContainer container;
    private final Target entitySet;
    private EdmEntitySet returnedEntitySet;

    public AbstractEdmOperationImport(Edm edm, EdmEntityContainer container, CsdlOperationImport operationImport) {
        super(edm, operationImport.getName(), operationImport);
        this.container = container;
        this.entitySet = operationImport.getEntitySet() != null ? new Target(operationImport.getEntitySet(), container) : null;
    }

    @Override
    public FullQualifiedName getFullQualifiedName() {
        return new FullQualifiedName(this.container.getNamespace(), this.getName());
    }

    @Override
    public EdmEntitySet getReturnedEntitySet() {
        if (this.entitySet != null && this.returnedEntitySet == null) {
            EdmEntityContainer entityContainer = this.edm.getEntityContainer(this.entitySet.getEntityContainer());
            if (entityContainer == null) {
                throw new EdmException("Can\u00b4t find entity container with name: " + this.entitySet.getEntityContainer());
            }
            this.returnedEntitySet = entityContainer.getEntitySet(this.entitySet.getTargetName());
            if (this.returnedEntitySet == null) {
                throw new EdmException("Can\u00b4t find entity set with name: " + this.entitySet.getTargetName());
            }
        }
        return this.returnedEntitySet;
    }

    @Override
    public EdmEntityContainer getEntityContainer() {
        return this.container;
    }
}

