/****************************************************************************
 * libs/libnx/nxfonts/nxfonts_serif38x49b.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __LIBS_LIBNX_NXFONTS_NXFONTS_SERIF38X49B_H
#define __LIBS_LIBNX_NXFONTS_NXFONTS_SERIF38X49B_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

/****************************************************************************
 * Pre-Processor Definitions
 ****************************************************************************/

/* Font ID */

#define NXFONT_ID         FONTID_SERIF38X49B

/* Ranges of 7-bit and 8-bit fonts */

#define NXFONT_MIN7BIT    33
#define NXFONT_MAX7BIT    126

#define NXFONT_MIN8BIT    161
#define NXFONT_MAX8BIT    255

/* Maximum height and width of any glyph in the set */

#define NXFONT_MAXHEIGHT  49
#define NXFONT_MAXWIDTH   38

/* The width of a space */

#define NXFONT_SPACEWIDTH 8

/* exclam (33) */
#define NXFONT_METRICS_33 {1, 5, 23, 3, 14, 0}
#define NXFONT_BITMAP_33 {0x70, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0x70, 0x70, 0x70, 0x70, 0x20, 0x20, 0x20, 0x20, 0x0, 0x0, 0x0, 0x70, 0xf8, 0xf8, 0xf8, 0x70}

/* quotedbl (34) */
#define NXFONT_METRICS_34 {2, 11, 11, 2, 14, 0}
#define NXFONT_BITMAP_34 {0x60, 0xc0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0}

/* numbersign (35) */
#define NXFONT_METRICS_35 {2, 16, 23, 0, 14, 0}
#define NXFONT_BITMAP_35 {0x3, 0xc, 0x3, 0xc, 0x7, 0x1c, 0x7, 0x1c, 0x6, 0x18, 0x6, 0x18, 0x7f, 0xff, 0x7f, 0xff, 0xe, 0x38, 0xc, 0x30, 0xc, 0x30, 0xc, 0x30, 0xc, 0x30, 0x1c, 0x70, 0xff, 0xfe, 0xff, 0xfe, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x38, 0xe0, 0x38, 0xe0, 0x30, 0xc0, 0x30, 0xc0}

/* dollar (36) */
#define NXFONT_METRICS_36 {2, 15, 28, 1, 12, 0}
#define NXFONT_BITMAP_36 {0x3, 0x0, 0x3, 0x0, 0xf, 0xe8, 0x3f, 0xf8, 0x73, 0x38, 0x63, 0x18, 0xe3, 0x8, 0xe3, 0x8, 0xf3, 0x0, 0xfb, 0x0, 0x7f, 0x0, 0x7f, 0x80, 0x3f, 0xe0, 0xf, 0xf0, 0x3, 0xf8, 0x3, 0xfc, 0x3, 0x7c, 0x83, 0x3e, 0x83, 0x1e, 0x83, 0x1e, 0xc3, 0x1c, 0xc3, 0x3c, 0xf3, 0x78, 0xff, 0xe0, 0x83, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0}

/* percent (37) */
#define NXFONT_METRICS_37 {3, 24, 23, 4, 14, 0}
#define NXFONT_BITMAP_37 {0x7, 0x80, 0x20, 0xf, 0xc0, 0xe0, 0x1e, 0x7f, 0xc0, 0x3c, 0x20, 0xc0, 0x7c, 0x21, 0x80, 0x78, 0x21, 0x80, 0xf8, 0x63, 0x0, 0xf0, 0x47, 0x0, 0xf0, 0xc6, 0x0, 0xf0, 0xce, 0x0, 0xf1, 0x8c, 0x3c, 0x7f, 0x18, 0x7e, 0x3c, 0x19, 0xf3, 0x0, 0x31, 0xe1, 0x0, 0x33, 0xc1, 0x0, 0x63, 0xc1, 0x0, 0xe7, 0xc3, 0x0, 0xc7, 0x82, 0x1, 0xc7, 0x86, 0x1, 0x87, 0x86, 0x3, 0x3, 0x8c, 0x3, 0x3, 0xf8, 0x6, 0x1, 0xe0}

/* ampersand (38) */
#define NXFONT_METRICS_38 {3, 22, 23, 2, 14, 0}
#define NXFONT_BITMAP_38 {0x1, 0xf0, 0x0, 0x3, 0xbc, 0x0, 0x7, 0x1e, 0x0, 0x7, 0xe, 0x0, 0xf, 0xe, 0x0, 0xf, 0xe, 0x0, 0xf, 0x8c, 0x0, 0x7, 0xd8, 0x0, 0x7, 0xf0, 0x0, 0x3, 0xe0, 0xfc, 0x7, 0xf0, 0x70, 0x1d, 0xf0, 0x30, 0x39, 0xf8, 0x60, 0x70, 0xfc, 0x40, 0xf0, 0xfc, 0xc0, 0xf0, 0x7f, 0x80, 0xf8, 0x3f, 0x0, 0xf8, 0x1f, 0x80, 0xfc, 0x1f, 0xc0, 0xfe, 0x3f, 0xe4, 0x7f, 0xf3, 0xfc, 0x7f, 0xc1, 0xfc, 0x1f, 0x0, 0x78}

/* quotesingle (39) */
#define NXFONT_METRICS_39 {1, 4, 11, 2, 14, 0}
#define NXFONT_BITMAP_39 {0x60, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x60, 0x60, 0x60, 0x60}

/* parenleft (40) */
#define NXFONT_METRICS_40 {1, 8, 29, 2, 14, 0}
#define NXFONT_BITMAP_40 {0x3, 0x6, 0xc, 0x18, 0x18, 0x30, 0x30, 0x70, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x60, 0x70, 0x30, 0x30, 0x18, 0x18, 0xc, 0x6, 0x3}

/* parenright (41) */
#define NXFONT_METRICS_41 {1, 8, 29, 0, 14, 0}
#define NXFONT_BITMAP_41 {0xc0, 0x60, 0x30, 0x18, 0x18, 0xc, 0xc, 0xe, 0x6, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x6, 0xe, 0xc, 0xc, 0x18, 0x18, 0x30, 0x60, 0xc0}

/* asterisk (42) */
#define NXFONT_METRICS_42 {2, 13, 14, 1, 14, 0}
#define NXFONT_BITMAP_42 {0x3, 0x0, 0x7, 0x0, 0x7, 0x0, 0xe7, 0x38, 0xf2, 0x78, 0x7a, 0xf0, 0xf, 0x80, 0xf, 0x80, 0x7a, 0xf0, 0xf2, 0x78, 0xe7, 0x38, 0x7, 0x0, 0x7, 0x0, 0x6, 0x0}

/* plus (43) */
#define NXFONT_METRICS_43 {2, 15, 15, 2, 22, 0}
#define NXFONT_BITMAP_43 {0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80}

/* comma (44) */
#define NXFONT_METRICS_44 {1, 6, 11, 1, 32, 0}
#define NXFONT_BITMAP_44 {0x38, 0x7c, 0x7c, 0x7c, 0x3c, 0xc, 0x8, 0x18, 0x30, 0x60, 0xc0}

/* hyphen (45) */
#define NXFONT_METRICS_45 {1, 8, 4, 1, 27, 0}
#define NXFONT_BITMAP_45 {0xff, 0xff, 0xff, 0xff}

/* period (46) */
#define NXFONT_METRICS_46 {1, 5, 5, 1, 32, 0}
#define NXFONT_BITMAP_46 {0x70, 0xf8, 0xf8, 0xf8, 0x70}

/* slash (47) */
#define NXFONT_METRICS_47 {2, 9, 25, 0, 12, 0}
#define NXFONT_BITMAP_47 {0x1, 0x80, 0x1, 0x80, 0x1, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x4, 0x0, 0xc, 0x0, 0xc, 0x0, 0xc, 0x0, 0x18, 0x0, 0x18, 0x0, 0x18, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0xc0, 0x0, 0xc0, 0x0}

/* zero (48) */
#define NXFONT_METRICS_48 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_48 {0x7, 0x80, 0x1f, 0xe0, 0x1c, 0xe0, 0x38, 0x70, 0x78, 0x70, 0x78, 0x78, 0x78, 0x78, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x38, 0x70, 0x1c, 0xe0, 0xf, 0xc0, 0x7, 0x80}

/* one (49) */
#define NXFONT_METRICS_49 {2, 13, 23, 2, 14, 0}
#define NXFONT_BITMAP_49 {0x1, 0x80, 0x7, 0x80, 0x1f, 0x80, 0xff, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0x1f, 0xc0, 0xff, 0xf8}

/* two (50) */
#define NXFONT_METRICS_50 {2, 16, 23, 0, 14, 0}
#define NXFONT_BITMAP_50 {0x3, 0xc0, 0xf, 0xf0, 0x1f, 0xf8, 0x3f, 0xf8, 0x30, 0xfc, 0x60, 0x7c, 0x40, 0x7c, 0x0, 0x7c, 0x0, 0x78, 0x0, 0x78, 0x0, 0x78, 0x0, 0xf0, 0x0, 0xe0, 0x1, 0xc0, 0x1, 0x80, 0x3, 0x0, 0x7, 0x1, 0xe, 0x3, 0x1c, 0x6, 0x3f, 0xfe, 0x7f, 0xfe, 0xff, 0xfc, 0xff, 0xfc}

/* three (51) */
#define NXFONT_METRICS_51 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_51 {0x7, 0xc0, 0x1f, 0xf0, 0x3f, 0xf0, 0x30, 0xf8, 0x60, 0x78, 0x40, 0x78, 0x0, 0x78, 0x0, 0x70, 0x0, 0xc0, 0x3, 0xe0, 0xf, 0xf0, 0xf, 0xf8, 0x3, 0xf8, 0x0, 0xfc, 0x0, 0x7c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x60, 0x38, 0xf0, 0x38, 0xf8, 0x70, 0x7f, 0xc0, 0x1f, 0x0}

/* four (52) */
#define NXFONT_METRICS_52 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_52 {0x0, 0x70, 0x0, 0xf0, 0x0, 0xf0, 0x1, 0xf0, 0x3, 0xf0, 0x6, 0xf0, 0x6, 0xf0, 0xc, 0xf0, 0x18, 0xf0, 0x18, 0xf0, 0x30, 0xf0, 0x60, 0xf0, 0x60, 0xf0, 0xc0, 0xf0, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0}

/* five (53) */
#define NXFONT_METRICS_53 {2, 13, 23, 1, 14, 0}
#define NXFONT_BITMAP_53 {0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x30, 0x0, 0x30, 0x0, 0x20, 0x0, 0x3e, 0x0, 0x7f, 0x80, 0x7f, 0xe0, 0x7f, 0xf0, 0x7f, 0xf0, 0x3, 0xf8, 0x0, 0xf8, 0x0, 0x78, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x60, 0x30, 0xf0, 0x30, 0xf8, 0x60, 0x7f, 0xc0, 0x1f, 0x0}

/* six (54) */
#define NXFONT_METRICS_54 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_54 {0x0, 0x1c, 0x0, 0xf0, 0x3, 0xc0, 0x7, 0x80, 0xf, 0x0, 0x1e, 0x0, 0x3e, 0x0, 0x3c, 0x0, 0x7c, 0x0, 0x7f, 0xe0, 0xfd, 0xf0, 0xf8, 0xf8, 0xf8, 0x78, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0x78, 0x7c, 0x78, 0x78, 0x78, 0x78, 0x38, 0x70, 0x1c, 0xe0, 0xf, 0xc0}

/* seven (55) */
#define NXFONT_METRICS_55 {2, 13, 23, 2, 14, 0}
#define NXFONT_BITMAP_55 {0x7f, 0xf8, 0x7f, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xc0, 0x30, 0x80, 0x70, 0x80, 0x70, 0x0, 0x60, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xc0, 0x1, 0xc0, 0x1, 0xc0, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1c, 0x0}

/* eight (56) */
#define NXFONT_METRICS_56 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_56 {0xf, 0xe0, 0x3e, 0xf0, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x38, 0x78, 0x38, 0x7c, 0x38, 0x7e, 0x70, 0x3f, 0xe0, 0x3f, 0x80, 0x1f, 0xc0, 0xf, 0xe0, 0x3f, 0xf0, 0x71, 0xf8, 0x70, 0xfc, 0xe0, 0x7c, 0xe0, 0x3c, 0xe0, 0x3c, 0xe0, 0x3c, 0xf0, 0x38, 0x78, 0x78, 0x7f, 0xf0, 0x1f, 0xc0}

/* nine (57) */
#define NXFONT_METRICS_57 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_57 {0xf, 0xc0, 0x1c, 0xe0, 0x38, 0x70, 0x78, 0x78, 0x78, 0x78, 0xf8, 0x78, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0x78, 0x7c, 0x7c, 0x7c, 0x3e, 0xfc, 0x1f, 0xf8, 0x0, 0xf8, 0x0, 0xf0, 0x1, 0xf0, 0x1, 0xe0, 0x3, 0xc0, 0x7, 0x80, 0xf, 0x0, 0x3c, 0x0, 0xe0, 0x0}

/* colon (58) */
#define NXFONT_METRICS_58 {1, 5, 16, 3, 21, 0}
#define NXFONT_BITMAP_58 {0x70, 0xf8, 0xf8, 0xf8, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x70, 0xf8, 0xf8, 0xf8, 0x70}

/* semicolon (59) */
#define NXFONT_METRICS_59 {1, 6, 22, 2, 21, 0}
#define NXFONT_BITMAP_59 {0x38, 0x7c, 0x7c, 0x7c, 0x38, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x38, 0x7c, 0x7c, 0x7c, 0x3c, 0xc, 0x8, 0x18, 0x30, 0x60, 0xc0}

/* less (60) */
#define NXFONT_METRICS_60 {2, 16, 15, 1, 22, 0}
#define NXFONT_BITMAP_60 {0x0, 0x3, 0x0, 0xf, 0x0, 0x7f, 0x1, 0xfc, 0xf, 0xe0, 0x3f, 0x80, 0xfc, 0x0, 0xf0, 0x0, 0xfc, 0x0, 0x3f, 0x80, 0xf, 0xe0, 0x1, 0xfc, 0x0, 0x7f, 0x0, 0xf, 0x0, 0x3}

/* equal (61) */
#define NXFONT_METRICS_61 {2, 15, 10, 2, 24, 0}
#define NXFONT_BITMAP_61 {0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe}

/* greater (62) */
#define NXFONT_METRICS_62 {2, 16, 15, 2, 22, 0}
#define NXFONT_BITMAP_62 {0xc0, 0x0, 0xf0, 0x0, 0xfe, 0x0, 0x3f, 0x80, 0x7, 0xf0, 0x1, 0xfc, 0x0, 0x3f, 0x0, 0xf, 0x0, 0x3f, 0x1, 0xfc, 0x7, 0xf0, 0x3f, 0x80, 0xfe, 0x0, 0xf0, 0x0, 0xc0, 0x0}

/* question (63) */
#define NXFONT_METRICS_63 {2, 12, 23, 2, 14, 0}
#define NXFONT_BITMAP_63 {0x3f, 0x0, 0x73, 0xc0, 0xe1, 0xe0, 0xe1, 0xf0, 0xf1, 0xf0, 0xf1, 0xf0, 0x61, 0xf0, 0x1, 0xe0, 0x1, 0xe0, 0x3, 0xc0, 0x3, 0x80, 0x3, 0x0, 0x6, 0x0, 0x4, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0xe, 0x0}

/* at (64) */
#define NXFONT_METRICS_64 {4, 26, 27, 2, 15, 0}
#define NXFONT_BITMAP_64 {0x0, 0x1f, 0xe0, 0x0, 0x0, 0xfc, 0x3c, 0x0, 0x3, 0xe0, 0xe, 0x0, 0x7, 0x80, 0x3, 0x0, 0xf, 0x0, 0x1, 0x0, 0x1e, 0x0, 0x1, 0x80, 0x3e, 0xf, 0x38, 0x80, 0x3c, 0x1f, 0xf8, 0xc0,\
                          0x7c, 0x7c, 0xf8, 0x40, 0x78, 0x78, 0x78, 0x40, 0xf8, 0xf8, 0xf0, 0x40, 0xf8, 0xf0, 0xf0, 0x40, 0xf1, 0xf0, 0xf0, 0x40, 0xf1, 0xf0, 0xf0, 0x40, 0xf1, 0xe0, 0xf0, 0xc0, 0xf1,\
                          0xe1, 0xe0, 0x80, 0xf1, 0xe1, 0xe1, 0x80, 0xf1, 0xe3, 0xe3, 0x0, 0x71, 0xf3, 0xe3, 0x0, 0x78, 0xfe, 0xfe, 0x0, 0x78, 0x78, 0x78, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x0,\
                          0xe, 0x0, 0x1, 0x80, 0x7, 0x80, 0x7, 0x0, 0x1, 0xe0, 0x3c, 0x0, 0x0, 0x3f, 0xe0, 0x0}

/* A (65) */
#define NXFONT_METRICS_65 {3, 21, 23, 1, 14, 0}
#define NXFONT_BITMAP_65 {0x0, 0x20, 0x0, 0x0, 0x60, 0x0, 0x0, 0x70, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x1, 0x7c, 0x0, 0x1, 0x7c, 0x0, 0x3, 0x3e, 0x0, 0x2, 0x3e, 0x0, 0x6, 0x3e, 0x0, 0x6, 0x1f, 0x0, 0x4, 0x1f, 0x0, 0xc, 0xf, 0x0, 0xf, 0xff, 0x80, 0x18, 0xf, 0x80, 0x18, 0x7, 0xc0, 0x10, 0x7, 0xc0, 0x30, 0x3, 0xe0, 0x30, 0x3, 0xe0, 0x70, 0x7, 0xf0, 0xfc, 0x1f, 0xf8}

/* B (66) */
#define NXFONT_METRICS_66 {3, 19, 23, 1, 14, 0}
#define NXFONT_BITMAP_66 {0xff, 0xfc, 0x0, 0x3f, 0x1f, 0x0, 0x1f, 0xf, 0x80, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0x80, 0x1f, 0xf, 0x80, 0x1f, 0x3e, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0xf, 0x80, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xc0, 0x1f, 0x7, 0xc0, 0x3f, 0xf, 0x0, 0xff, 0xfc, 0x0}

/* C (67) */
#define NXFONT_METRICS_67 {3, 19, 23, 2, 14, 0}
#define NXFONT_BITMAP_67 {0x1, 0xfc, 0x20, 0x7, 0xff, 0x60, 0xf, 0x7, 0xe0, 0x1e, 0x1, 0xe0, 0x3c, 0x0, 0xe0, 0x7c, 0x0, 0x60, 0x7c, 0x0, 0x60, 0xf8, 0x0, 0x20, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3c, 0x0, 0x20, 0x1e, 0x0, 0x60, 0xf, 0x81, 0xc0, 0x3, 0xff, 0x80, 0x0, 0xfe, 0x0}

/* D (68) */
#define NXFONT_METRICS_68 {3, 22, 23, 0, 14, 0}
#define NXFONT_BITMAP_68 {0xff, 0xfc, 0x0, 0x3f, 0xff, 0x80, 0x1f, 0x7, 0xe0, 0x1f, 0x1, 0xf0, 0x1f, 0x1, 0xf0, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xfc, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x1, 0xf0, 0x1f, 0x1, 0xe0, 0x1f, 0x7, 0xc0, 0x3f, 0xff, 0x0, 0xff, 0xfc, 0x0}

/* E (69) */
#define NXFONT_METRICS_69 {3, 21, 23, 0, 14, 0}
#define NXFONT_BITMAP_69 {0xff, 0xff, 0xe0, 0x3f, 0xff, 0xe0, 0x1f, 0x0, 0xe0, 0x1f, 0x0, 0x60, 0x1f, 0x0, 0x60, 0x1f, 0x0, 0x20, 0x1f, 0x0, 0x20, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0x0, 0x8, 0x1f, 0x0, 0x18, 0x1f, 0x0, 0x30, 0x1f, 0x0, 0x70, 0x1f, 0x1, 0xf0, 0x3f, 0xff, 0xe0, 0xff, 0xff, 0xe0}

/* F (70) */
#define NXFONT_METRICS_70 {3, 19, 23, 0, 14, 0}
#define NXFONT_BITMAP_70 {0xff, 0xff, 0xe0, 0x3f, 0xff, 0xe0, 0x1f, 0x0, 0xe0, 0x1f, 0x0, 0x60, 0x1f, 0x0, 0x60, 0x1f, 0x0, 0x20, 0x1f, 0x0, 0x20, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x3f, 0x80, 0x0, 0xff, 0xe0, 0x0}

/* G (71) */
#define NXFONT_METRICS_71 {3, 22, 23, 2, 14, 0}
#define NXFONT_BITMAP_71 {0x1, 0xfc, 0x20, 0x7, 0xff, 0x60, 0xf, 0x7, 0xe0, 0x1e, 0x1, 0xe0, 0x3c, 0x0, 0xe0, 0x7c, 0x0, 0x60, 0x7c, 0x0, 0x60, 0xf8, 0x0, 0x20, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x1f, 0xfc, 0xf8, 0x7, 0xf0, 0xf8, 0x3, 0xe0, 0x7c, 0x3, 0xe0, 0x7c, 0x3, 0xe0, 0x3c, 0x3, 0xe0, 0x3e, 0x3, 0xe0, 0x1e, 0x7, 0xe0, 0xf, 0x8f, 0xe0, 0x3, 0xff, 0x0}

/* H (72) */
#define NXFONT_METRICS_72 {3, 24, 23, 0, 14, 0}
#define NXFONT_BITMAP_72 {0xff, 0xe7, 0xff, 0x3f, 0x81, 0xfc, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0xff, 0xf8, 0x1f, 0xff, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x3f, 0x81, 0xfc, 0xff, 0xe7, 0xff}

/* I (73) */
#define NXFONT_METRICS_73 {2, 11, 23, 1, 14, 0}
#define NXFONT_BITMAP_73 {0xff, 0xe0, 0x3f, 0x80, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x3f, 0x80, 0xff, 0xe0}

/* J (74) */
#define NXFONT_METRICS_74 {2, 15, 26, 0, 14, 0}
#define NXFONT_BITMAP_74 {0xf, 0xfe, 0x3, 0xf8, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x1, 0xf0, 0x61, 0xf0, 0xf1, 0xf0, 0xf1, 0xf0, 0xf3, 0xe0, 0xe3, 0xe0, 0x7f, 0xc0, 0x1f, 0x0}

/* K (75) */
#define NXFONT_METRICS_75 {3, 24, 23, 1, 14, 0}
#define NXFONT_BITMAP_75 {0xff, 0xcf, 0xfc, 0x7f, 0x3, 0xe0, 0x3e, 0x1, 0xc0, 0x3e, 0x3, 0x80, 0x3e, 0x7, 0x0, 0x3e, 0xe, 0x0, 0x3e, 0x1c, 0x0, 0x3e, 0x38, 0x0, 0x3e, 0x70, 0x0, 0x3e, 0xe0, 0x0, 0x3f, 0xf0, 0x0, 0x3f, 0xf8, 0x0, 0x3f, 0xfc, 0x0, 0x3e, 0xfe, 0x0, 0x3e, 0x7f, 0x0, 0x3e, 0x3f, 0x80, 0x3e, 0x1f, 0xc0, 0x3e, 0xf, 0xe0, 0x3e, 0x7, 0xf0, 0x3e, 0x3, 0xf8, 0x3e, 0x1, 0xfc, 0x7f, 0x0, 0xfe, 0xff, 0xc3, 0xff}

/* L (76) */
#define NXFONT_METRICS_76 {3, 20, 23, 1, 14, 0}
#define NXFONT_BITMAP_76 {0xff, 0xe0, 0x0, 0x3f, 0x80, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x30, 0x1f, 0x0, 0x60, 0x1f, 0x0, 0xe0, 0x1f, 0x81, 0xe0, 0x3f, 0xff, 0xc0, 0xff, 0xff, 0xc0}

/* M (77) */
#define NXFONT_METRICS_77 {4, 28, 23, 1, 14, 0}
#define NXFONT_BITMAP_77 {0xff, 0x0, 0xf, 0xf0, 0x3f, 0x0, 0x1f, 0xc0, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x3f, 0x80, 0x17, 0xc0, 0x3f, 0x80, 0x17, 0xc0, 0x2f, 0x80, 0x17, 0xc0, 0x6f, 0x80, 0x13, 0xe0,\
                          0x4f, 0x80, 0x13, 0xe0, 0xcf, 0x80, 0x13, 0xe0, 0xcf, 0x80, 0x11, 0xf0, 0x8f, 0x80, 0x11, 0xf1, 0x8f, 0x80, 0x10, 0xf9, 0xf, 0x80, 0x10, 0xfb, 0xf, 0x80, 0x10, 0xfb, 0xf, 0x80,\
                          0x10, 0x7e, 0xf, 0x80, 0x10, 0x7e, 0xf, 0x80, 0x10, 0x7c, 0xf, 0x80, 0x10, 0x3c, 0xf, 0x80, 0x10, 0x3c, 0xf, 0x80, 0x10, 0x18, 0xf, 0x80, 0x38, 0x18, 0x1f, 0xc0, 0xfe, 0x18, 0x3f, 0xf0}

/* N (78) */
#define NXFONT_METRICS_78 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_78 {0xfe, 0x1, 0xfc, 0x7f, 0x0, 0x70, 0x3f, 0x80, 0x20, 0x1f, 0x80, 0x20, 0x1f, 0xc0, 0x20, 0x1f, 0xe0, 0x20, 0x17, 0xf0, 0x20, 0x13, 0xf8, 0x20, 0x11, 0xf8, 0x20, 0x11, 0xfc, 0x20, 0x10, 0xfe, 0x20, 0x10, 0x7f, 0x20, 0x10, 0x3f, 0x20, 0x10, 0x1f, 0xa0, 0x10, 0x1f, 0xe0, 0x10, 0xf, 0xe0, 0x10, 0x7, 0xe0, 0x10, 0x3, 0xe0, 0x10, 0x3, 0xe0, 0x10, 0x1, 0xe0, 0x10, 0x0, 0xe0, 0x38, 0x0, 0x60, 0xfe, 0x0, 0x20}

/* O (79) */
#define NXFONT_METRICS_79 {3, 21, 23, 2, 14, 0}
#define NXFONT_BITMAP_79 {0x1, 0xfc, 0x0, 0x7, 0xff, 0x0, 0xf, 0x8f, 0x80, 0x1e, 0x3, 0xc0, 0x3c, 0x1, 0xe0, 0x7c, 0x1, 0xf0, 0x78, 0x0, 0xf0, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0x78, 0x0, 0xf0, 0x7c, 0x1, 0xf0, 0x3c, 0x1, 0xe0, 0x1e, 0x3, 0xc0, 0xf, 0x8f, 0x80, 0x7, 0xff, 0x0, 0x1, 0xfc, 0x0}

/* P (80) */
#define NXFONT_METRICS_80 {3, 19, 23, 0, 14, 0}
#define NXFONT_BITMAP_80 {0xff, 0xfc, 0x0, 0x3f, 0x1f, 0x80, 0x1f, 0xf, 0xc0, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0xc0, 0x1f, 0x1f, 0x80, 0x1f, 0xfe, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x3f, 0x80, 0x0, 0xff, 0xe0, 0x0}

/* Q (81) */
#define NXFONT_METRICS_81 {3, 22, 27, 2, 14, 0}
#define NXFONT_BITMAP_81 {0x1, 0xfc, 0x0, 0x7, 0xff, 0x0, 0xf, 0x8f, 0x80, 0x1e, 0x3, 0xc0, 0x3c, 0x1, 0xe0, 0x7c, 0x1, 0xf0, 0x78, 0x0, 0xf0, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0x7c, 0x1, 0xf0, 0x7c, 0x1, 0xf0, 0x3e, 0x3, 0xe0, 0x1f, 0x7, 0xc0, 0x7, 0xff, 0x0, 0x1, 0xfc, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x7f, 0x84, 0x0, 0x1f, 0xf8, 0x0, 0x7, 0xe0}

/* R (82) */
#define NXFONT_METRICS_82 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_82 {0xff, 0xfc, 0x0, 0x3f, 0x1f, 0x80, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x7, 0xe0, 0x1f, 0x7, 0xc0, 0x1f, 0x1f, 0x80, 0x1f, 0xfc, 0x0, 0x1f, 0x7e, 0x0, 0x1f, 0x3e, 0x0, 0x1f, 0x3f, 0x0, 0x1f, 0x1f, 0x80, 0x1f, 0x1f, 0x80, 0x1f, 0xf, 0xc0, 0x1f, 0x7, 0xe0, 0x1f, 0x7, 0xe0, 0x1f, 0x3, 0xf0, 0x3f, 0x81, 0xf8, 0xff, 0xe1, 0xfc}

/* S (83) */
#define NXFONT_METRICS_83 {2, 15, 23, 1, 14, 0}
#define NXFONT_BITMAP_83 {0xf, 0xc4, 0x38, 0x7c, 0x70, 0x3c, 0x70, 0x1c, 0xf0, 0xc, 0xf0, 0xc, 0xf8, 0x4, 0xfc, 0x0, 0xff, 0x0, 0x7f, 0xc0, 0x3f, 0xf0, 0x1f, 0xf8, 0xf, 0xfc, 0x3, 0xfc, 0x1, 0xfe, 0x80, 0x7e, 0x80, 0x3e, 0xc0, 0x1e, 0xc0, 0x1e, 0xe0, 0x1c, 0xf0, 0x1c, 0xf8, 0x38, 0x8f, 0xe0}

/* T (84) */
#define NXFONT_METRICS_84 {3, 19, 23, 1, 14, 0}
#define NXFONT_BITMAP_84 {0xff, 0xff, 0xe0, 0xf9, 0xf3, 0xe0, 0xe1, 0xf0, 0xe0, 0xc1, 0xf0, 0x60, 0x81, 0xf0, 0x20, 0x81, 0xf0, 0x20, 0x81, 0xf0, 0x20, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x3, 0xf8, 0x0, 0xf, 0xfe, 0x0}

/* U (85) */
#define NXFONT_METRICS_85 {3, 23, 23, 0, 14, 0}
#define NXFONT_BITMAP_85 {0xff, 0xe0, 0xfe, 0x3f, 0x80, 0x38, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0xf, 0x80, 0x30, 0xf, 0x80, 0x60, 0x7, 0xc0, 0xc0, 0x3, 0xff, 0x80, 0x0, 0xfe, 0x0}

/* V (86) */
#define NXFONT_METRICS_86 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_86 {0xff, 0xc3, 0xfc, 0x7f, 0x0, 0xf0, 0x3e, 0x0, 0x60, 0x3f, 0x0, 0x40, 0x1f, 0x0, 0xc0, 0x1f, 0x80, 0xc0, 0xf, 0x80, 0x80, 0xf, 0x81, 0x80, 0xf, 0xc1, 0x0, 0x7, 0xc1, 0x0, 0x7, 0xc3, 0x0, 0x3, 0xe2, 0x0, 0x3, 0xe6, 0x0, 0x3, 0xf6, 0x0, 0x1, 0xf4, 0x0, 0x1, 0xfc, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x70, 0x0, 0x0, 0x70, 0x0, 0x0, 0x20, 0x0, 0x0, 0x20, 0x0}

/* W (87) */
#define NXFONT_METRICS_87 {4, 32, 23, 0, 14, 0}
#define NXFONT_BITMAP_87 {0xff, 0xef, 0xff, 0x3f, 0x7f, 0x3, 0xf8, 0xe, 0x3f, 0x1, 0xf8, 0xc, 0x1f, 0x1, 0xf8, 0xc, 0x1f, 0x1, 0xf8, 0x8, 0x1f, 0x81, 0xfc, 0x18, 0xf, 0x81, 0xfc, 0x18, 0xf, 0x81, 0x7c, 0x10,\
                          0xf, 0xc3, 0x7c, 0x30, 0x7, 0xc2, 0x7e, 0x30, 0x7, 0xc6, 0x3e, 0x20, 0x7, 0xe6, 0x3e, 0x60, 0x3, 0xe4, 0x3e, 0x60, 0x3, 0xec, 0x1f, 0x40, 0x3, 0xf8, 0x1f, 0xc0, 0x1, 0xf8, 0x1f, 0xc0,\
                          0x1, 0xf8, 0xf, 0x80, 0x1, 0xf0, 0xf, 0x80, 0x0, 0xf0, 0xf, 0x80, 0x0, 0xe0, 0x7, 0x0, 0x0, 0xe0, 0x7, 0x0, 0x0, 0xe0, 0x7, 0x0, 0x0, 0x40, 0x2, 0x0}

/* X (88) */
#define NXFONT_METRICS_88 {3, 21, 23, 1, 14, 0}
#define NXFONT_BITMAP_88 {0xff, 0xcf, 0xe0, 0x7f, 0x3, 0x0, 0x3f, 0x2, 0x0, 0x1f, 0x86, 0x0, 0x1f, 0x84, 0x0, 0xf, 0xcc, 0x0, 0xf, 0xc8, 0x0, 0x7, 0xf8, 0x0, 0x3, 0xf0, 0x0, 0x3, 0xf0, 0x0, 0x1, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xfc, 0x0, 0x1, 0x7c, 0x0, 0x3, 0x3e, 0x0, 0x2, 0x3f, 0x0, 0x6, 0x1f, 0x0, 0x4, 0x1f, 0x80, 0xc, 0xf, 0xc0, 0x8, 0xf, 0xc0, 0x18, 0x7, 0xe0, 0x38, 0x7, 0xf0, 0xfe, 0x3f, 0xf8}

/* Y (89) */
#define NXFONT_METRICS_89 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_89 {0xff, 0xc3, 0xfc, 0x7f, 0x0, 0xf0, 0x3f, 0x0, 0x60, 0x3f, 0x0, 0x60, 0x1f, 0x80, 0xc0, 0x1f, 0x80, 0x80, 0xf, 0xc1, 0x80, 0xf, 0xc3, 0x0, 0x7, 0xe3, 0x0, 0x3, 0xe6, 0x0, 0x3, 0xf4, 0x0, 0x1, 0xfc, 0x0, 0x1, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xfc, 0x0, 0x7, 0xff, 0x0}

/* Z (90) */
#define NXFONT_METRICS_90 {3, 19, 23, 1, 14, 0}
#define NXFONT_BITMAP_90 {0x3f, 0xff, 0xc0, 0x7e, 0xf, 0x80, 0x78, 0x1f, 0x80, 0x70, 0x1f, 0x0, 0x60, 0x3f, 0x0, 0x40, 0x7e, 0x0, 0x0, 0x7e, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xf8, 0x0, 0x1, 0xf0, 0x0, 0x3, 0xf0, 0x0, 0x3, 0xe0, 0x0, 0x7, 0xe0, 0x0, 0x7, 0xc0, 0x0, 0xf, 0xc0, 0x20, 0x1f, 0x80, 0x20, 0x1f, 0x80, 0x60, 0x3f, 0x0, 0x60, 0x3f, 0x0, 0xe0, 0x7e, 0x1, 0xe0, 0x7e, 0x7, 0xc0, 0xff, 0xff, 0xc0}

/* bracketleft (91) */
#define NXFONT_METRICS_91 {1, 7, 28, 2, 14, 0}
#define NXFONT_BITMAP_91 {0xfe, 0xf0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0xfe}

/* backslash (92) */
#define NXFONT_METRICS_92 {1, 8, 26, 0, 11, 0}
#define NXFONT_BITMAP_92 {0x80, 0xc0, 0xc0, 0xc0, 0x60, 0x60, 0x60, 0x60, 0x30, 0x30, 0x30, 0x18, 0x18, 0x18, 0x18, 0xc, 0xc, 0xc, 0x4, 0x6, 0x6, 0x6, 0x3, 0x3, 0x3, 0x3}

/* bracketright (93) */
#define NXFONT_METRICS_93 {1, 7, 28, 1, 14, 0}
#define NXFONT_BITMAP_93 {0xfe, 0x1e, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0x1e, 0xfe}

/* asciicircum (94) */
#define NXFONT_METRICS_94 {2, 11, 13, 4, 14, 0}
#define NXFONT_BITMAP_94 {0xe, 0x0, 0xe, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1b, 0x0, 0x3b, 0x80, 0x3b, 0x80, 0x71, 0xc0, 0x71, 0xc0, 0x61, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xc0, 0x60}

/* underscore (95) */
#define NXFONT_METRICS_95 {2, 16, 3, 0, 39, 0}
#define NXFONT_BITMAP_95 {0xff, 0xff, 0xff, 0xff, 0xff, 0xff}

/* grave (96) */
#define NXFONT_METRICS_96 {1, 7, 6, 1, 14, 0}
#define NXFONT_BITMAP_96 {0xc0, 0xe0, 0x70, 0x38, 0xc, 0x2}

/* a (97) */
#define NXFONT_METRICS_97 {2, 14, 16, 1, 21, 0}
#define NXFONT_BITMAP_97 {0x1f, 0x80, 0x31, 0xe0, 0x70, 0xf0, 0x78, 0xf0, 0x78, 0xf0, 0x30, 0xf0, 0x1, 0xf0, 0x7, 0xf0, 0x1c, 0xf0, 0x38, 0xf0, 0x78, 0xf0, 0xf0, 0xf0, 0xf9, 0xf0, 0xff, 0xf4, 0x7e, 0xfc, 0x3c, 0x78}

/* b (98) */
#define NXFONT_METRICS_98 {3, 17, 22, 0, 15, 0}
#define NXFONT_BITMAP_98 {0xfc, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x78, 0x0, 0x3d, 0xfe, 0x0, 0x3f, 0xfe, 0x0, 0x3e, 0x1f, 0x0, 0x3c, 0x1f, 0x0, 0x3c, 0xf, 0x80, 0x3c, 0xf, 0x80, 0x3c, 0xf, 0x80, 0x3c, 0xf, 0x80, 0x3c, 0xf, 0x80, 0x3c, 0xf, 0x80, 0x3c, 0xf, 0x0, 0x3c, 0x1f, 0x0, 0x3e, 0x3e, 0x0, 0x37, 0xfc, 0x0, 0x21, 0xf0, 0x0}

/* c (99) */
#define NXFONT_METRICS_99 {2, 14, 16, 1, 21, 0}
#define NXFONT_BITMAP_99 {0x7, 0xf0, 0x1e, 0x78, 0x3c, 0x3c, 0x7c, 0x3c, 0x78, 0x18, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0x7c, 0x0, 0x3e, 0x18, 0x1f, 0xf0, 0xf, 0xe0}

/* d (100) */
#define NXFONT_METRICS_100 {2, 16, 22, 1, 15, 0}
#define NXFONT_BITMAP_100 {0x0, 0xfc, 0x0, 0x7c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0xf, 0xbc, 0x3f, 0xfc, 0x7c, 0x3c, 0x78, 0x3c, 0xf8, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x3c, 0x7c, 0x7e, 0x3f, 0xff, 0xf, 0xb8}

/* e (101) */
#define NXFONT_METRICS_101 {2, 14, 16, 0, 21, 0}
#define NXFONT_BITMAP_101 {0x7, 0xc0, 0x1e, 0xf0, 0x3c, 0x70, 0x78, 0x38, 0x78, 0x3c, 0xf8, 0x3c, 0xf8, 0x3c, 0xff, 0xfc, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0x78, 0x0, 0x7c, 0x0, 0x3e, 0x18, 0x1f, 0xf0, 0x7, 0xe0}

/* f (102) */
#define NXFONT_METRICS_102 {2, 12, 23, 0, 14, 0}
#define NXFONT_BITMAP_102 {0x7, 0xe0, 0x1e, 0x70, 0x1c, 0xf0, 0x3c, 0xf0, 0x3c, 0x60, 0x3c, 0x0, 0x3c, 0x0, 0xff, 0x80, 0xff, 0x80, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x7e, 0x0, 0xff, 0x0}

/* g (103) */
#define NXFONT_METRICS_103 {2, 14, 23, 1, 21, 0}
#define NXFONT_BITMAP_103 {0xf, 0xc0, 0x3d, 0xfc, 0x70, 0xfc, 0xf0, 0xf0, 0xf0, 0x78, 0xf0, 0x78, 0xf0, 0x78, 0xf0, 0x78, 0x78, 0xf8, 0x3f, 0xf0, 0x1f, 0xc0, 0x3c, 0x0, 0x60, 0x0, 0xe0, 0x0, 0xff, 0xe0, 0xff, 0xf8, 0x7f, 0xfc, 0x30, 0x3c, 0x60, 0x1c, 0xc0, 0xc, 0xe0, 0x1c, 0x7f, 0xf8, 0x1f, 0xe0}

/* h (104) */
#define NXFONT_METRICS_104 {3, 17, 22, 0, 15, 0}
#define NXFONT_BITMAP_104 {0xfc, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x78, 0x0, 0x3d, 0xfc, 0x0, 0x3f, 0xfe, 0x0, 0x3e, 0x3e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x7e, 0x3f, 0x0, 0xff, 0x7f, 0x80}

/* i (105) */
#define NXFONT_METRICS_105 {1, 8, 23, 0, 14, 0}
#define NXFONT_BITMAP_105 {0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x0, 0x0, 0xfc, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7e, 0xff}

/* j (106) -- NOTE: Xoffset should be -2, not 0. */
#define NXFONT_METRICS_106 {2, 10, 30, 0, 14, 0}
#define NXFONT_BITMAP_106 {0x1, 0x80, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x1, 0x80, 0x0, 0x0, 0x0, 0x0, 0xf, 0xc0, 0x7, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x63, 0xc0, 0xf3, 0xc0, 0xf3, 0x80, 0x77, 0x80, 0x3e, 0x0}

/* k (107) */
#define NXFONT_METRICS_107 {3, 18, 22, 0, 15, 0}
#define NXFONT_BITMAP_107 {0xfc, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x1f, 0x0, 0x3c, 0xe, 0x0, 0x3c, 0xc, 0x0, 0x3c, 0x18, 0x0, 0x3c, 0x30, 0x0, 0x3c, 0x60, 0x0, 0x3c, 0xc0, 0x0, 0x3d, 0xc0, 0x0, 0x3f, 0xe0, 0x0, 0x3d, 0xf0, 0x0, 0x3c, 0xf8, 0x0, 0x3c, 0x7c, 0x0, 0x3c, 0x3e, 0x0, 0x3c, 0x1f, 0x0, 0x7e, 0xf, 0x80, 0xff, 0x1f, 0xc0}

/* l (108) */
#define NXFONT_METRICS_108 {1, 8, 22, 0, 15, 0}
#define NXFONT_BITMAP_108 {0xfc, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7e, 0xff}

/* m (109) */
#define NXFONT_METRICS_109 {4, 26, 16, 0, 21, 0}
#define NXFONT_BITMAP_109 {0xfc, 0x78, 0x3c, 0x0, 0x7d, 0xfe, 0xfe, 0x0, 0x3f, 0x3f, 0x9f, 0x0, 0x3e, 0x3f, 0x1f, 0x0, 0x3e, 0x1e, 0xf, 0x0, 0x3c, 0x1e, 0xf, 0x0, 0x3c, 0x1e, 0xf, 0x0, 0x3c, 0x1e, 0xf, 0x0, 0x3c, 0x1e, 0xf, 0x0, 0x3c, 0x1e, 0xf, 0x0, 0x3c, 0x1e, 0xf, 0x0, 0x3c, 0x1e, 0xf, 0x0, 0x3c, 0x1e, 0xf, 0x0, 0x3c, 0x1e, 0xf, 0x0, 0x7e, 0x3f, 0x1f, 0x80, 0xff, 0x7f, 0xbf, 0xc0}

/* n (110) */
#define NXFONT_METRICS_110 {3, 17, 16, 0, 21, 0}
#define NXFONT_BITMAP_110 {0xfc, 0x78, 0x0, 0x7d, 0xfc, 0x0, 0x3f, 0x3e, 0x0, 0x3e, 0x1e, 0x0, 0x3e, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x7e, 0x3f, 0x0, 0xff, 0x7f, 0x80}

/* o (111) */
#define NXFONT_METRICS_111 {2, 14, 16, 1, 21, 0}
#define NXFONT_BITMAP_111 {0xf, 0xc0, 0x3c, 0xf0, 0x78, 0x78, 0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x3c, 0xf0, 0xf, 0xc0}

/* p (112) */
#define NXFONT_METRICS_112 {3, 17, 23, 0, 21, 0}
#define NXFONT_BITMAP_112 {0xfc, 0xf8, 0x0, 0x7d, 0xfe, 0x0, 0x3f, 0x1f, 0x0, 0x3e, 0xf, 0x0, 0x3c, 0xf, 0x80, 0x3c, 0x7, 0x80, 0x3c, 0x7, 0x80, 0x3c, 0x7, 0x80, 0x3c, 0x7, 0x80, 0x3c, 0x7, 0x80, 0x3c, 0x7, 0x80, 0x3c, 0x7, 0x80, 0x3e, 0xf, 0x0, 0x3f, 0xf, 0x0, 0x3f, 0xfe, 0x0, 0x3c, 0xf8, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x7e, 0x0, 0x0, 0xff, 0x0, 0x0}

/* q (113) */
#define NXFONT_METRICS_113 {2, 16, 23, 1, 21, 0}
#define NXFONT_BITMAP_113 {0xf, 0xc4, 0x3e, 0xec, 0x7c, 0x3c, 0x78, 0x3c, 0xf8, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x3c, 0x78, 0x7c, 0x3f, 0xfc, 0xf, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x7e, 0x0, 0xff}

/* r (114) */
#define NXFONT_METRICS_114 {2, 13, 16, 1, 21, 0}
#define NXFONT_BITMAP_114 {0xfc, 0x70, 0x7c, 0xf8, 0x3f, 0xf8, 0x3f, 0x78, 0x3e, 0x30, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x7e, 0x0, 0xff, 0x0}

/* s (115) */
#define NXFONT_METRICS_115 {2, 10, 16, 1, 21, 0}
#define NXFONT_BITMAP_115 {0x1f, 0x40, 0x71, 0xc0, 0x60, 0xc0, 0xe0, 0xc0, 0xf0, 0x40, 0xfc, 0x0, 0x7f, 0x0, 0x7f, 0x80, 0x3f, 0x80, 0xf, 0xc0, 0x3, 0xc0, 0x81, 0xc0, 0xc1, 0xc0, 0xc1, 0xc0, 0xe3, 0x80, 0xbf, 0x0}

/* t (116) */
#define NXFONT_METRICS_116 {2, 10, 21, 0, 16, 0}
#define NXFONT_BITMAP_116 {0x4, 0x0, 0xc, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x3c, 0x0, 0x7f, 0x80, 0xff, 0x80, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x40, 0x3e, 0xc0, 0x3f, 0x80, 0x1e, 0x0}

/* u (117) */
#define NXFONT_METRICS_117 {3, 17, 16, 0, 21, 0}
#define NXFONT_BITMAP_117 {0xfc, 0x7e, 0x0, 0x7c, 0x3e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x3e, 0x0, 0x3e, 0x5f, 0x0, 0x1f, 0xdf, 0x80, 0x7, 0x8c, 0x0}

/* v (118) */
#define NXFONT_METRICS_118 {2, 15, 16, 0, 21, 0}
#define NXFONT_BITMAP_118 {0xff, 0x3e, 0x7c, 0xc, 0x3c, 0x8, 0x3e, 0x18, 0x1e, 0x10, 0x1f, 0x10, 0x1f, 0x30, 0xf, 0x20, 0xf, 0x20, 0x7, 0xe0, 0x7, 0xc0, 0x7, 0xc0, 0x3, 0x80, 0x3, 0x80, 0x1, 0x0, 0x1, 0x0}

/* w (119) */
#define NXFONT_METRICS_119 {3, 23, 16, 0, 21, 0}
#define NXFONT_BITMAP_119 {0xff, 0x7f, 0xbe, 0x7e, 0x3e, 0x1c, 0x3c, 0x1e, 0x8, 0x3e, 0x1e, 0x18, 0x1e, 0x1f, 0x10, 0x1f, 0x1f, 0x30, 0x1f, 0x3f, 0x30, 0xf, 0x2f, 0xa0, 0xf, 0xe7, 0xe0, 0x7, 0xe7, 0xc0, 0x7, 0xc7, 0xc0, 0x7, 0xc3, 0xc0, 0x3, 0x83, 0x80, 0x3, 0x83, 0x80, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0}

/* x (120) */
#define NXFONT_METRICS_120 {2, 16, 16, 0, 21, 0}
#define NXFONT_BITMAP_120 {0xff, 0x3e, 0x7e, 0x18, 0x3e, 0x18, 0x1f, 0x30, 0x1f, 0x60, 0xf, 0xc0, 0xf, 0xc0, 0x7, 0xc0, 0x3, 0xe0, 0x3, 0xe0, 0x7, 0xf0, 0xd, 0xf8, 0x18, 0xf8, 0x18, 0x7c, 0x30, 0x7c, 0xfc, 0xff}

/* y (121) */
#define NXFONT_METRICS_121 {2, 15, 23, 0, 21, 0}
#define NXFONT_BITMAP_121 {0xff, 0xbe, 0x7e, 0xc, 0x3e, 0x8, 0x3e, 0x8, 0x1f, 0x18, 0x1f, 0x10, 0xf, 0x10, 0xf, 0xb0, 0xf, 0xa0, 0x7, 0xa0, 0x7, 0xe0, 0x7, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x0, 0x73, 0x0, 0xf3, 0x0, 0xf6, 0x0, 0xfe, 0x0, 0x78, 0x0}

/* z (122) */
#define NXFONT_METRICS_122 {2, 12, 16, 1, 21, 0}
#define NXFONT_BITMAP_122 {0xff, 0xf0, 0xe3, 0xf0, 0xc3, 0xe0, 0x87, 0xe0, 0x87, 0xc0, 0xf, 0x80, 0xf, 0x80, 0x1f, 0x0, 0x1f, 0x0, 0x3e, 0x0, 0x3e, 0x10, 0x7c, 0x10, 0x7c, 0x30, 0xf8, 0x30, 0xf8, 0xf0, 0xff, 0xf0}

/* braceleft (123) */
#define NXFONT_METRICS_123 {2, 10, 27, 1, 14, 0}
#define NXFONT_BITMAP_123 {0x7, 0xc0, 0xe, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x70, 0x0, 0xe0, 0x0, 0x70, 0x0, 0x38, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x7, 0xc0}

/* bar (124) */
#define NXFONT_METRICS_124 {1, 2, 30, 3, 14, 0}
#define NXFONT_BITMAP_124 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* braceright (125) */
#define NXFONT_METRICS_125 {2, 10, 27, 1, 14, 0}
#define NXFONT_BITMAP_125 {0xf8, 0x0, 0x1c, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0x7, 0x0, 0x3, 0x80, 0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1c, 0x0, 0xf8, 0x0}

/* asciitilde (126) */
#define NXFONT_METRICS_126 {2, 15, 8, 1, 21, 0}
#define NXFONT_BITMAP_126 {0x1c, 0x0, 0x3f, 0x0, 0x7f, 0x82, 0xff, 0xc6, 0x8f, 0xfe, 0x83, 0xfc, 0x1, 0xf8, 0x0, 0x70}

/* exclamdown (161) */
#define NXFONT_METRICS_161 {1, 5, 23, 3, 21, 0}
#define NXFONT_BITMAP_161 {0x70, 0xf8, 0xf8, 0xf8, 0x70, 0x0, 0x0, 0x0, 0x20, 0x20, 0x20, 0x20, 0x70, 0x70, 0x70, 0x70, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0x70}

/* cent (162) */
#define NXFONT_METRICS_162 {2, 13, 25, 1, 17, 0}
#define NXFONT_BITMAP_162 {0x0, 0x8, 0x0, 0x8, 0x0, 0x18, 0x0, 0x10, 0x7, 0xf0, 0x1c, 0xe0, 0x38, 0xf0, 0x78, 0xf0, 0xf0, 0xf0, 0xf0, 0xe0, 0xf0, 0x80, 0xf1, 0x80, 0xf1, 0x0, 0xf3, 0x0, 0xf2, 0x0, 0xfa, 0x10, 0x7e, 0x30, 0x7f, 0xe0, 0x3f, 0xc0, 0xf, 0x0, 0x8, 0x0, 0x10, 0x0, 0x10, 0x0, 0x20, 0x0, 0x20, 0x0}

/* sterling (163) */
#define NXFONT_METRICS_163 {2, 16, 23, 1, 14, 0}
#define NXFONT_BITMAP_163 {0x0, 0xf0, 0x3, 0xfc, 0x7, 0x1e, 0xe, 0x1e, 0xe, 0x1e, 0x1e, 0xc, 0x1e, 0x0, 0x1e, 0x0, 0x1f, 0x0, 0xf, 0x0, 0xf, 0x0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x37, 0x80, 0x7f, 0x1, 0xef, 0x3, 0xc7, 0x87, 0xc7, 0xff, 0xee, 0xfe, 0x7c, 0x7c}

/* currency (164) */
#define NXFONT_METRICS_164 {2, 14, 15, 1, 18, 0}
#define NXFONT_BITMAP_164 {0x60, 0x18, 0xf7, 0xbc, 0xff, 0xfc, 0x7f, 0xf8, 0x3c, 0xf0, 0x78, 0x78, 0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x78, 0x78, 0x3c, 0xf0, 0x7f, 0xf8, 0xff, 0xfc, 0xf7, 0xbc, 0x60, 0x18}

/* yen (165) */
#define NXFONT_METRICS_165 {3, 18, 23, 1, 14, 0}
#define NXFONT_BITMAP_165 {0xff, 0x87, 0xc0, 0x3e, 0x3, 0x80, 0x3e, 0x3, 0x0, 0x1f, 0x3, 0x0, 0x1f, 0x6, 0x0, 0x1f, 0x86, 0x0, 0xf, 0x84, 0x0, 0xf, 0x8c, 0x0, 0x7, 0xc8, 0x0, 0x7, 0xd8, 0x0, 0x7, 0xd0, 0x0, 0x3, 0xf0, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0xfc, 0x0, 0x3, 0xe0, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0xfc, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x3, 0xf0, 0x0, 0xf, 0xfc, 0x0}

/* brokenbar (166) */
#define NXFONT_METRICS_166 {1, 2, 30, 3, 14, 0}
#define NXFONT_BITMAP_166 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* section (167) */
#define NXFONT_METRICS_167 {2, 12, 28, 2, 14, 0}
#define NXFONT_BITMAP_167 {0xf, 0x80, 0x18, 0xc0, 0x30, 0xe0, 0x71, 0xe0, 0x71, 0xe0, 0x78, 0xc0, 0x3c, 0x0, 0x3e, 0x0, 0x1f, 0x0, 0xf, 0x80, 0x3f, 0xc0, 0x63, 0xe0, 0xc1, 0xe0, 0xc0, 0xf0, 0xe0, 0x70, 0xf0, 0x30, 0x78, 0x30, 0x7c, 0x60, 0x3f, 0xc0, 0x1f, 0x80, 0x7, 0x80, 0x3, 0xc0, 0x31, 0xe0, 0x78, 0xe0, 0x78, 0xe0, 0x70, 0xc0, 0x31, 0x80, 0x1f, 0x0}

/* dieresis (168) */
#define NXFONT_METRICS_168 {1, 8, 4, 2, 15, 0}
#define NXFONT_BITMAP_168 {0x42, 0xe7, 0xe7, 0x42}

/* copyright (169) */
#define NXFONT_METRICS_169 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_169 {0x1, 0xfe, 0x0, 0x7, 0xff, 0x80, 0xf, 0x3, 0xc0, 0x1c, 0x0, 0xe0, 0x38, 0x0, 0x70, 0x30, 0xfe, 0x30, 0x71, 0xc7, 0x38, 0x63, 0x83, 0x18, 0xe7, 0x83, 0x1c, 0xc7, 0x0, 0xc, 0xc7, 0x0, 0xc, 0xc7, 0x0, 0xc, 0xc7, 0x0, 0xc, 0xc7, 0x80, 0xc, 0xc3, 0xc3, 0xc, 0xe3, 0xe6, 0x1c, 0x60, 0xfc, 0x18, 0x70, 0x0, 0x38, 0x38, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0xf, 0x3, 0xc0, 0x7, 0xff, 0x80, 0x1, 0xfe, 0x0}

/* ordfeminine (170) */
#define NXFONT_METRICS_170 {2, 9, 14, 0, 14, 0}
#define NXFONT_BITMAP_170 {0x3c, 0x0, 0x66, 0x0, 0x67, 0x0, 0x67, 0x0, 0x1f, 0x0, 0x67, 0x0, 0xc7, 0x0, 0xc7, 0x0, 0xef, 0x80, 0x73, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80, 0xff, 0x80}

/* guillemotleft (171) */
#define NXFONT_METRICS_171 {2, 14, 14, 2, 22, 0}
#define NXFONT_BITMAP_171 {0x2, 0x4, 0x6, 0xc, 0xe, 0x1c, 0x1c, 0x38, 0x38, 0x70, 0x70, 0xe0, 0xe1, 0xc0, 0xe1, 0xc0, 0x70, 0xe0, 0x38, 0x70, 0x1c, 0x38, 0xe, 0x1c, 0x6, 0xc, 0x2, 0x4}

/* logicalnot (172) */
#define NXFONT_METRICS_172 {2, 16, 9, 1, 25, 0}
#define NXFONT_BITMAP_172 {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7}

/* hyphen (173) */
#define NXFONT_METRICS_173 {1, 8, 4, 1, 27, 0}
#define NXFONT_BITMAP_173 {0xff, 0xff, 0xff, 0xff}

/* registered (174) */
#define NXFONT_METRICS_174 {3, 22, 23, 2, 14, 0}
#define NXFONT_BITMAP_174 {0x1, 0xfe, 0x0, 0x7, 0xff, 0x80, 0xf, 0x3, 0xc0, 0x1c, 0x0, 0xe0, 0x38, 0x0, 0x70, 0x33, 0xfc, 0x30, 0x71, 0xce, 0x38, 0x60, 0xc7, 0x18, 0xe0, 0xc7, 0x1c, 0xc0, 0xc7, 0xc, 0xc0, 0xce, 0xc, 0xc0, 0xf8, 0xc, 0xc0, 0xdc, 0xc, 0xc0, 0xce, 0xc, 0xc0, 0xc6, 0xc, 0xe0, 0xc7, 0x1c, 0x61, 0xc3, 0x98, 0x73, 0xe3, 0xf8, 0x38, 0x0, 0x70, 0x1c, 0x0, 0xe0, 0xf, 0x3, 0xc0, 0x7, 0xff, 0x80, 0x1, 0xfe, 0x0}

/* macron (175) */
#define NXFONT_METRICS_175 {2, 9, 2, 1, 17, 0}
#define NXFONT_BITMAP_175 {0xff, 0x80, 0xff, 0x80}

/* degree (176) */
#define NXFONT_METRICS_176 {2, 9, 10, 2, 14, 0}
#define NXFONT_BITMAP_176 {0x1c, 0x0, 0x7f, 0x0, 0x63, 0x0, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0x63, 0x0, 0x7f, 0x0, 0x3c, 0x0}

/* plusminus (177) */
#define NXFONT_METRICS_177 {2, 15, 19, 2, 18, 0}
#define NXFONT_BITMAP_177 {0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x0, 0x0, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe}

/* twosuperior (178) */
#define NXFONT_METRICS_178 {2, 10, 14, 1, 14, 0}
#define NXFONT_BITMAP_178 {0x3e, 0x0, 0x7f, 0x0, 0xc7, 0x80, 0x83, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x0, 0x6, 0x0, 0xc, 0x0, 0x18, 0x0, 0x30, 0x40, 0x7f, 0xc0, 0xff, 0x80, 0xff, 0x80}

/* threesuperior (179) */
#define NXFONT_METRICS_179 {2, 9, 14, 1, 14, 0}
#define NXFONT_BITMAP_179 {0x1e, 0x0, 0x3f, 0x0, 0x67, 0x80, 0x43, 0x80, 0x3, 0x0, 0x6, 0x0, 0x1f, 0x0, 0x7, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0xc3, 0x80, 0xe7, 0x0, 0x7e, 0x0}

/* acute (180) */
#define NXFONT_METRICS_180 {1, 7, 6, 3, 14, 0}
#define NXFONT_BITMAP_180 {0x6, 0xe, 0x1c, 0x38, 0x60, 0x80}

/* mu (181) */
#define NXFONT_METRICS_181 {2, 16, 22, 2, 21, 0}
#define NXFONT_BITMAP_181 {0xf8, 0xfc, 0x78, 0x7c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x7c, 0x7c, 0xfc, 0x7f, 0xbf, 0x5f, 0x38, 0x40, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* paragraph (182) */
#define NXFONT_METRICS_182 {2, 16, 29, 1, 14, 0}
#define NXFONT_BITMAP_182 {0xf, 0xff, 0x3f, 0xff, 0x3f, 0x8c, 0x7f, 0x8c, 0xff, 0x8c, 0xff, 0x8c, 0xff, 0x8c, 0xff, 0x8c, 0xff, 0x8c, 0xff, 0x8c, 0xff, 0x8c, 0x7f, 0x8c, 0x3f, 0x8c, 0x3f, 0x8c, 0xf, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c, 0x1, 0x8c}

/* periodcentered (183) */
#define NXFONT_METRICS_183 {1, 4, 4, 2, 24, 0}
#define NXFONT_BITMAP_183 {0x60, 0xf0, 0xf0, 0x60}

/* cedilla (184) */
#define NXFONT_METRICS_184 {1, 7, 7, 1, 37, 0}
#define NXFONT_BITMAP_184 {0x6, 0xc, 0x1c, 0xe, 0xc6, 0xee, 0x7c}

/* onesuperior (185) */
#define NXFONT_METRICS_185 {2, 9, 14, 0, 14, 0}
#define NXFONT_BITMAP_185 {0xc, 0x0, 0x7c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xff, 0x80}

/* ordmasculine (186) */
#define NXFONT_METRICS_186 {2, 9, 14, 1, 14, 0}
#define NXFONT_BITMAP_186 {0x1c, 0x0, 0x77, 0x0, 0x63, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x63, 0x0, 0x77, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x80, 0xff, 0x80}

/* guillemotright (187) */
#define NXFONT_METRICS_187 {2, 14, 14, 1, 22, 0}
#define NXFONT_BITMAP_187 {0x81, 0x0, 0xc1, 0x80, 0xe1, 0xc0, 0x70, 0xe0, 0x38, 0x70, 0x1c, 0x38, 0xe, 0x1c, 0xe, 0x1c, 0x1c, 0x38, 0x38, 0x70, 0x70, 0xe0, 0xe1, 0xc0, 0xc1, 0x80, 0x81, 0x0}

/* onequarter (188) */
#define NXFONT_METRICS_188 {3, 23, 23, 0, 14, 0}
#define NXFONT_BITMAP_188 {0xc, 0x0, 0x8, 0x7c, 0x0, 0x18, 0x1c, 0x0, 0x30, 0x1c, 0x0, 0x30, 0x1c, 0x0, 0x60, 0x1c, 0x0, 0x60, 0x1c, 0x0, 0xc0, 0x1c, 0x1, 0x80, 0x1c, 0x1, 0x80, 0x1c, 0x3, 0xc, 0x1c, 0x6, 0x1c, 0x1c, 0x6, 0x3c, 0x1c, 0xc, 0x7c, 0xff, 0x98, 0xfc, 0x0, 0x18, 0xdc, 0x0, 0x31, 0x9c, 0x0, 0x63, 0x9c, 0x0, 0x63, 0x1c, 0x0, 0xc7, 0xfe, 0x1, 0xc7, 0xfe, 0x1, 0x80, 0x1c, 0x3, 0x0, 0x1c, 0x3, 0x0, 0x1c}

/* onehalf (189) */
#define NXFONT_METRICS_189 {3, 23, 23, 0, 14, 0}
#define NXFONT_BITMAP_189 {0xc, 0x0, 0x30, 0x7c, 0x0, 0x60, 0x1c, 0x0, 0x60, 0x1c, 0x0, 0xc0, 0x1c, 0x0, 0x80, 0x1c, 0x1, 0x80, 0x1c, 0x3, 0x0, 0x1c, 0x2, 0x0, 0x1c, 0x6, 0x0, 0x1c, 0xc, 0xf0, 0x1c, 0x19, 0xf8, 0x1c, 0x1b, 0x3c, 0x1c, 0x32, 0x1c, 0xff, 0xb0, 0x1c, 0x0, 0x60, 0x1c, 0x0, 0x60, 0x18, 0x0, 0xc0, 0x30, 0x1, 0x80, 0x60, 0x1, 0x80, 0xc0, 0x3, 0x1, 0x82, 0x6, 0x3, 0xfe, 0x6, 0x7, 0xfc, 0xc, 0xf, 0xfc}

/* threequarters (190) */
#define NXFONT_METRICS_190 {3, 22, 23, 1, 14, 0}
#define NXFONT_BITMAP_190 {0x1e, 0x0, 0x10, 0x3f, 0x0, 0x30, 0x67, 0x80, 0x60, 0x43, 0x80, 0x60, 0x3, 0x0, 0xc0, 0x6, 0x0, 0xc0, 0x1f, 0x1, 0x80, 0x7, 0x83, 0x0, 0x3, 0x83, 0x0, 0x3, 0x86, 0x18, 0x3, 0x8c, 0x38, 0xc3, 0x8c, 0x78, 0xe7, 0x18, 0xf8, 0x7e, 0x31, 0xf8, 0x0, 0x31, 0xb8, 0x0, 0x63, 0x38, 0x0, 0xc7, 0x38, 0x0, 0xc6, 0x38, 0x1, 0x8f, 0xfc, 0x3, 0x8f, 0xfc, 0x3, 0x0, 0x38, 0x6, 0x0, 0x38, 0x6, 0x0, 0x38}

/* questiondown (191) */
#define NXFONT_METRICS_191 {2, 12, 23, 2, 21, 0}
#define NXFONT_BITMAP_191 {0x7, 0x0, 0xf, 0x80, 0xf, 0x80, 0xf, 0x80, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 0x6, 0x0, 0xc, 0x0, 0x1c, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x78, 0x0, 0xf8, 0x60, 0xf8, 0xf0, 0xf8, 0xf0, 0xf8, 0x70, 0x78, 0x70, 0x3c, 0xe0, 0x1f, 0xc0}

/* Agrave (192) */
#define NXFONT_METRICS_192 {3, 21, 30, 1, 7, 0}
#define NXFONT_BITMAP_192 {0x6, 0x0, 0x0, 0x7, 0x0, 0x0, 0x3, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x20, 0x0, 0x0, 0x60, 0x0, 0x0, 0x70, 0x0, 0x0, 0xf0, 0x0, 0x0,\
                           0xf8, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x1, 0x7c, 0x0, 0x1, 0x7c, 0x0, 0x3, 0x3e, 0x0, 0x2, 0x3e, 0x0, 0x6, 0x3e, 0x0, 0x6, 0x1f, 0x0, 0x4, 0x1f, 0x0, 0xc, 0xf, 0x0, 0xf, 0xff,\
                           0x80, 0x18, 0xf, 0x80, 0x18, 0x7, 0xc0, 0x10, 0x7, 0xc0, 0x30, 0x3, 0xe0, 0x30, 0x3, 0xe0, 0x70, 0x7, 0xf0, 0xfc, 0x1f, 0xf8}

/* Aacute (193) */
#define NXFONT_METRICS_193 {3, 21, 30, 1, 7, 0}
#define NXFONT_BITMAP_193 {0x0, 0x3, 0x0, 0x0, 0x7, 0x0, 0x0, 0xe, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x30, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x60, 0x0, 0x0, 0x70, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x1, 0x7c, 0x0, 0x1, 0x7c, 0x0, 0x3, 0x3e, 0x0, 0x2, 0x3e, 0x0, 0x6, 0x3e, 0x0, 0x6, 0x1f, 0x0, 0x4, 0x1f, 0x0, 0xc, 0xf, 0x0, 0xf, 0xff, 0x80, 0x18, 0xf, 0x80, 0x18, 0x7, 0xc0, 0x10, 0x7, 0xc0, 0x30, 0x3, 0xe0, 0x30, 0x3, 0xe0, 0x70, 0x7, 0xf0, 0xfc, 0x1f, 0xf8}

/* Acircumflex (194) */
#define NXFONT_METRICS_194 {3, 21, 30, 1, 7, 0}
#define NXFONT_BITMAP_194 {0x0, 0x60, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xf8, 0x0, 0x1, 0x98, 0x0, 0x3, 0xc, 0x0, 0x2, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x60, 0x0, 0x0, 0x70, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf8,\
                           0x0, 0x0, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x1, 0x7c, 0x0, 0x1, 0x7c, 0x0, 0x3, 0x3e, 0x0, 0x2, 0x3e, 0x0, 0x6, 0x3e, 0x0, 0x6, 0x1f, 0x0, 0x4, 0x1f, 0x0, 0xc, 0xf, 0x0, 0xf, 0xff, 0x80, 0x18,\
                           0xf, 0x80, 0x18, 0x7, 0xc0, 0x10, 0x7, 0xc0, 0x30, 0x3, 0xe0, 0x30, 0x3, 0xe0, 0x70, 0x7, 0xf0, 0xfc, 0x1f, 0xf8}

/* Atilde (195) */
#define NXFONT_METRICS_195 {3, 21, 29, 1, 8, 0}
#define NXFONT_BITMAP_195 {0x0, 0xc2, 0x0, 0x1, 0xf6, 0x0, 0x3, 0x7c, 0x0, 0x2, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x60, 0x0, 0x0, 0x70, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x1, 0x7c, 0x0, 0x1, 0x7c, 0x0, 0x3, 0x3e, 0x0, 0x2, 0x3e, 0x0, 0x6, 0x3e, 0x0, 0x6, 0x1f, 0x0, 0x4, 0x1f, 0x0, 0xc, 0xf, 0x0, 0xf, 0xff, 0x80, 0x18, 0xf, 0x80, 0x18, 0x7, 0xc0, 0x10, 0x7, 0xc0, 0x30, 0x3, 0xe0, 0x30, 0x3, 0xe0, 0x70, 0x7, 0xf0, 0xfc, 0x1f, 0xf8}

/* Adieresis (196) */
#define NXFONT_METRICS_196 {3, 21, 29, 1, 8, 0}
#define NXFONT_BITMAP_196 {0x1, 0x8, 0x0, 0x3, 0x9c, 0x0, 0x3, 0x9c, 0x0, 0x1, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x60, 0x0, 0x0, 0x70, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x1, 0x7c, 0x0, 0x1, 0x7c, 0x0, 0x3, 0x3e, 0x0, 0x2, 0x3e, 0x0, 0x6, 0x3e, 0x0, 0x6, 0x1f, 0x0, 0x4, 0x1f, 0x0, 0xc, 0xf, 0x0, 0xf, 0xff, 0x80, 0x18, 0xf, 0x80, 0x18, 0x7, 0xc0, 0x10, 0x7, 0xc0, 0x30, 0x3, 0xe0, 0x30, 0x3, 0xe0, 0x70, 0x7, 0xf0, 0xfc, 0x1f, 0xf8}

/* Aring (197) */
#define NXFONT_METRICS_197 {3, 21, 30, 1, 7, 0}
#define NXFONT_BITMAP_197 {0x0, 0xe0, 0x0, 0x1, 0xb0, 0x0, 0x3, 0x18, 0x0, 0x2, 0x8, 0x0, 0x3, 0x18, 0x0, 0x1, 0xb0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x70, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf8, 0x0,\
                           0x0, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x1, 0x7c, 0x0, 0x1, 0x7c, 0x0, 0x3, 0x3e, 0x0, 0x2, 0x3e, 0x0, 0x6, 0x3e, 0x0, 0x6, 0x1f, 0x0, 0x4, 0x1f, 0x0, 0xc, 0xf, 0x0, 0xf, 0xff, 0x80, 0x18, 0xf,\
                           0x80, 0x18, 0x7, 0xc0, 0x10, 0x7, 0xc0, 0x30, 0x3, 0xe0, 0x30, 0x3, 0xe0, 0x70, 0x7, 0xf0, 0xfc, 0x1f, 0xf8}

/* AE (198) */
#define NXFONT_METRICS_198 {4, 32, 23, 0, 14, 0}
#define NXFONT_BITMAP_198 {0x3, 0xff, 0xff, 0xfc, 0x0, 0xff, 0xff, 0xfc, 0x0, 0x63, 0xe0, 0x1c, 0x0, 0x63, 0xe0, 0xc, 0x0, 0xc3, 0xe0, 0xc, 0x0, 0xc3, 0xe0, 0x4, 0x1, 0x83, 0xe0, 0x4, 0x1, 0x83, 0xe0, 0x80, 0x3, 0x3,\
                           0xe0, 0x80, 0x3, 0x3, 0xe1, 0x80, 0x2, 0x3, 0xe3, 0x80, 0x7, 0xff, 0xff, 0x80, 0x7, 0xff, 0xe3, 0x80, 0xc, 0x3, 0xe1, 0x80, 0xc, 0x3, 0xe0, 0x80, 0x18, 0x3, 0xe0, 0x80, 0x18, 0x3, 0xe0, 0x1,\
                           0x38, 0x3, 0xe0, 0x3, 0x30, 0x3, 0xe0, 0x6, 0x70, 0x3, 0xe0, 0xe, 0x70, 0x3, 0xe0, 0x3e, 0xf8, 0x7, 0xff, 0xfc, 0xfe, 0x1f, 0xff, 0xfc}

/* Ccedilla (199) */
#define NXFONT_METRICS_199 {3, 19, 30, 2, 14, 0}
#define NXFONT_BITMAP_199 {0x1, 0xfc, 0x20, 0x7, 0xff, 0x60, 0xf, 0x7, 0xe0, 0x1e, 0x1, 0xe0, 0x3c, 0x0, 0xe0, 0x7c, 0x0, 0x60, 0x7c, 0x0, 0x60, 0xf8, 0x0, 0x20, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8,\
                           0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3c, 0x0, 0x20, 0x1e, 0x0, 0x60, 0xf, 0x81, 0xc0, 0x3, 0xff, 0x80, 0x0, 0xfe, 0x0,\
                           0x0, 0x18, 0x0, 0x0, 0x30, 0x0, 0x0, 0x70, 0x0, 0x0, 0x38, 0x0, 0x3, 0x18, 0x0, 0x3, 0xb8, 0x0, 0x1, 0xf0, 0x0}

/* Egrave (200) */
#define NXFONT_METRICS_200 {3, 21, 30, 0, 7, 0}
#define NXFONT_BITMAP_200 {0x6, 0x0, 0x0, 0x7, 0x0, 0x0, 0x3, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xe0, 0x1f, 0x0, 0xe0, 0x1f, 0x0, 0x60, 0x1f, 0x0,\
                           0x60, 0x1f, 0x0, 0x20, 0x1f, 0x0, 0x20, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0,\
                           0x1f, 0x0, 0x8, 0x1f, 0x0, 0x18, 0x1f, 0x0, 0x30, 0x1f, 0x0, 0x70, 0x1f, 0x1, 0xf0, 0x3f, 0xff, 0xe0, 0xff, 0xff, 0xe0}

/* Eacute (201) */
#define NXFONT_METRICS_201 {3, 21, 30, 0, 7, 0}
#define NXFONT_BITMAP_201 {0x0, 0x1, 0x80, 0x0, 0x3, 0x80, 0x0, 0x7, 0x0, 0x0, 0xe, 0x0, 0x0, 0x18, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xe0, 0x1f, 0x0, 0xe0, 0x1f, 0x0, 0x60, 0x1f, 0x0,\
                           0x60, 0x1f, 0x0, 0x20, 0x1f, 0x0, 0x20, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0,\
                           0x1f, 0x0, 0x8, 0x1f, 0x0, 0x18, 0x1f, 0x0, 0x30, 0x1f, 0x0, 0x70, 0x1f, 0x1, 0xf0, 0x3f, 0xff, 0xe0, 0xff, 0xff, 0xe0}

/* Ecircumflex (202) */
#define NXFONT_METRICS_202 {3, 21, 30, 0, 7, 0}
#define NXFONT_BITMAP_202 {0x0, 0x30, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xcc, 0x0, 0x1, 0x86, 0x0, 0x1, 0x2, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xe0, 0x1f, 0x0, 0xe0, 0x1f, 0x0, 0x60, 0x1f, 0x0,\
                           0x60, 0x1f, 0x0, 0x20, 0x1f, 0x0, 0x20, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0, 0x1f,\
                           0x0, 0x8, 0x1f, 0x0, 0x18, 0x1f, 0x0, 0x30, 0x1f, 0x0, 0x70, 0x1f, 0x1, 0xf0, 0x3f, 0xff, 0xe0, 0xff, 0xff, 0xe0}

/* Edieresis (203) */
#define NXFONT_METRICS_203 {3, 21, 29, 0, 8, 0}
#define NXFONT_BITMAP_203 {0x0, 0x84, 0x0, 0x1, 0xce, 0x0, 0x1, 0xce, 0x0, 0x0, 0x84, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xe0, 0x1f, 0x0, 0xe0, 0x1f, 0x0, 0x60, 0x1f, 0x0, 0x60, 0x1f, 0x0, 0x20, 0x1f, 0x0, 0x20, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0x1c, 0x0, 0x1f, 0xc, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0x4, 0x0, 0x1f, 0x0, 0x8, 0x1f, 0x0, 0x18, 0x1f, 0x0, 0x30, 0x1f, 0x0, 0x70, 0x1f, 0x1, 0xf0, 0x3f, 0xff, 0xe0, 0xff, 0xff, 0xe0}

/* Igrave (204) */
#define NXFONT_METRICS_204 {2, 11, 30, 1, 7, 0}
#define NXFONT_BITMAP_204 {0xc0, 0x0, 0xe0, 0x0, 0x70, 0x0, 0x38, 0x0, 0xc, 0x0, 0x6, 0x0, 0x0, 0x0, 0xff, 0xe0, 0x3f, 0x80, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x3f, 0x80, 0xff, 0xe0}

/* Iacute (205) */
#define NXFONT_METRICS_205 {2, 12, 30, 1, 7, 0}
#define NXFONT_BITMAP_205 {0x0, 0x30, 0x0, 0x70, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x0, 0x6, 0x0, 0x0, 0x0, 0xff, 0xe0, 0x3f, 0x80, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x3f, 0x80, 0xff, 0xe0}

/* Icircumflex (206) */
#define NXFONT_METRICS_206 {2, 11, 30, 1, 7, 0}
#define NXFONT_BITMAP_206 {0x6, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x19, 0x80, 0x30, 0xc0, 0x20, 0x40, 0x0, 0x0, 0xff, 0xe0, 0x3f, 0x80, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x3f, 0x80, 0xff, 0xe0}

/* Idieresis (207) */
#define NXFONT_METRICS_207 {2, 11, 29, 1, 8, 0}
#define NXFONT_BITMAP_207 {0x10, 0x80, 0x39, 0xc0, 0x39, 0xc0, 0x10, 0x80, 0x0, 0x0, 0x0, 0x0, 0xff, 0xe0, 0x3f, 0x80, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x1f, 0x0, 0x3f, 0x80, 0xff, 0xe0}

/* Eth (208) */
#define NXFONT_METRICS_208 {3, 22, 23, 0, 14, 0}
#define NXFONT_BITMAP_208 {0xff, 0xfe, 0x0, 0x3f, 0xf, 0x80, 0x1f, 0x3, 0xe0, 0x1f, 0x1, 0xf0, 0x1f, 0x1, 0xf0, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xfc, 0x1f, 0x0, 0xfc, 0x1f, 0x0, 0xfc, 0xff, 0xf0, 0x7c, 0xff, 0xf0, 0x7c, 0xff, 0xf0, 0x7c, 0x1f, 0x0, 0x7c, 0x1f, 0x0, 0xfc, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x0, 0xf8, 0x1f, 0x1, 0xf0, 0x1f, 0x1, 0xe0, 0x1f, 0x3, 0xc0, 0x3f, 0xf, 0x80, 0x7f, 0xfe, 0x0}

/* Ntilde (209) */
#define NXFONT_METRICS_209 {3, 22, 29, 1, 8, 0}
#define NXFONT_BITMAP_209 {0x0, 0x61, 0x0, 0x0, 0xfb, 0x0, 0x1, 0xbe, 0x0, 0x1, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x1, 0xfc, 0x7f, 0x0, 0x70, 0x3f, 0x80, 0x20, 0x1f, 0x80, 0x20, 0x1f, 0xc0, 0x20, 0x1f, 0xe0,\
                           0x20, 0x17, 0xf0, 0x20, 0x13, 0xf8, 0x20, 0x11, 0xf8, 0x20, 0x11, 0xfc, 0x20, 0x10, 0xfe, 0x20, 0x10, 0x7f, 0x20, 0x10, 0x3f, 0x20, 0x10, 0x1f, 0xa0, 0x10, 0x1f, 0xe0, 0x10, 0xf, 0xe0, 0x10,\
                           0x7, 0xe0, 0x10, 0x3, 0xe0, 0x10, 0x3, 0xe0, 0x10, 0x1, 0xe0, 0x10, 0x0, 0xe0, 0x38, 0x0, 0x60, 0xfe, 0x0, 0x20}

/* Ograve (210) */
#define NXFONT_METRICS_210 {3, 21, 30, 2, 7, 0}
#define NXFONT_BITMAP_210 {0x6, 0x0, 0x0, 0x7, 0x0, 0x0, 0x3, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x7, 0xff, 0x0, 0xf, 0x8f, 0x80, 0x1e, 0x3, 0xc0, 0x3c, 0x1, 0xe0, 0x7c,\
                           0x1, 0xf0, 0x78, 0x0, 0xf0, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0x78, 0x0, 0xf0,\
                           0x7c, 0x1, 0xf0, 0x3c, 0x1, 0xe0, 0x1e, 0x3, 0xc0, 0xf, 0x8f, 0x80, 0x7, 0xff, 0x0, 0x1, 0xfc, 0x0}

/* Oacute (211) */
#define NXFONT_METRICS_211 {3, 21, 30, 2, 7, 0}
#define NXFONT_BITMAP_211 {0x0, 0x3, 0x80, 0x0, 0x7, 0x0, 0x0, 0xe, 0x0, 0x0, 0x18, 0x0, 0x0, 0x30, 0x0, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x7, 0xff, 0x0, 0xf, 0x8f, 0x80, 0x1e, 0x3, 0xc0, 0x3c, 0x1, 0xe0, 0x7c,\
                           0x1, 0xf0, 0x78, 0x0, 0xf0, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0x78, 0x0, 0xf0,\
                           0x7c, 0x1, 0xf0, 0x3c, 0x1, 0xe0, 0x1e, 0x3, 0xc0, 0xf, 0x8f, 0x80, 0x7, 0xff, 0x0, 0x1, 0xfc, 0x0}

/* Ocircumflex (212) */
#define NXFONT_METRICS_212 {3, 21, 30, 2, 7, 0}
#define NXFONT_BITMAP_212 {0x0, 0x30, 0x0, 0x0, 0x78, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xcc, 0x0, 0x1, 0x86, 0x0, 0x1, 0x2, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x7, 0xff, 0x0, 0xf, 0x8f, 0x80, 0x1e, 0x3, 0xc0, 0x3c, 0x1, 0xe0, 0x7c,\
                           0x1, 0xf0, 0x78, 0x0, 0xf0, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0x78, 0x0, 0xf0,\
                           0x7c, 0x1, 0xf0, 0x3c, 0x1, 0xe0, 0x1e, 0x3, 0xc0, 0xf, 0x8f, 0x80, 0x7, 0xff, 0x0, 0x1, 0xfc, 0x0}

/* Otilde (213) */
#define NXFONT_METRICS_213 {3, 21, 29, 2, 8, 0}
#define NXFONT_BITMAP_213 {0x0, 0xc2, 0x0, 0x1, 0xf6, 0x0, 0x3, 0x7c, 0x0, 0x2, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x7, 0xff, 0x0, 0xf, 0x8f, 0x80, 0x1e, 0x3, 0xc0, 0x3c, 0x1, 0xe0, 0x7c, 0x1, 0xf0, 0x78, 0x0, 0xf0, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0x78, 0x0, 0xf0, 0x7c, 0x1, 0xf0, 0x3c, 0x1, 0xe0, 0x1e, 0x3, 0xc0, 0xf, 0x8f, 0x80, 0x7, 0xff, 0x0, 0x1, 0xfc, 0x0}

/* Odieresis (214) */
#define NXFONT_METRICS_214 {3, 21, 29, 2, 8, 0}
#define NXFONT_BITMAP_214 {0x0, 0x84, 0x0, 0x1, 0xce, 0x0, 0x1, 0xce, 0x0, 0x0, 0x84, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x7, 0xff, 0x0, 0xf, 0x8f, 0x80, 0x1e, 0x3, 0xc0, 0x3c, 0x1, 0xe0, 0x7c, 0x1, 0xf0, 0x78, 0x0, 0xf0, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0xf8, 0x0, 0xf8, 0x78, 0x0, 0xf0, 0x7c, 0x1, 0xf0, 0x3c, 0x1, 0xe0, 0x1e, 0x3, 0xc0, 0xf, 0x8f, 0x80, 0x7, 0xff, 0x0, 0x1, 0xfc, 0x0}

/* multiply (215) */
#define NXFONT_METRICS_215 {2, 15, 16, 2, 21, 0}
#define NXFONT_BITMAP_215 {0x40, 0x4, 0xe0, 0xe, 0xf0, 0x1e, 0x78, 0x3c, 0x3c, 0x78, 0x1e, 0xf0, 0xf, 0xe0, 0x7, 0xc0, 0x7, 0xc0, 0xf, 0xe0, 0x1e, 0xf0, 0x3c, 0x78, 0x78, 0x3c, 0xf0, 0x1e, 0xe0, 0xe, 0x40, 0x4}

/* Oslash (216) */
#define NXFONT_METRICS_216 {3, 21, 27, 2, 12, 0}
#define NXFONT_BITMAP_216 {0x0, 0x0, 0x30, 0x0, 0x0, 0x60, 0x1, 0xfc, 0x40, 0x7, 0x8f, 0xc0, 0xe, 0x3, 0x80, 0x1e, 0x1, 0xc0, 0x3c, 0x3, 0xe0, 0x7c, 0x6, 0xf0, 0x78, 0x4, 0xf0, 0xf8, 0xc, 0xf8, 0xf8, 0x18, 0xf8, 0xf8, 0x18, 0xf8, 0xf8, 0x30, 0xf8, 0xf8, 0x20, 0xf8, 0xf8, 0x60, 0xf8, 0xf8, 0xc0, 0xf8, 0xf8, 0x80, 0xf8, 0xf9, 0x80, 0xf8, 0x7b, 0x0, 0xf0, 0x7e, 0x1, 0xf0, 0x3e, 0x1, 0xe0, 0x1c, 0x3, 0xc0, 0xe, 0x7, 0x80, 0x1f, 0xfe, 0x0, 0x11, 0xf8, 0x0, 0x30, 0x0, 0x0, 0x60, 0x0, 0x0}

/* Ugrave (217) */
#define NXFONT_METRICS_217 {3, 23, 30, 0, 7, 0}
#define NXFONT_BITMAP_217 {0x0, 0xc0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x38, 0x0, 0x0, 0xc, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0xff, 0xe0, 0xfe, 0x3f, 0x80, 0x38, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f,\
                           0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10,\
                           0x1f, 0x0, 0x30, 0xf, 0x80, 0x30, 0xf, 0x80, 0x60, 0x7, 0xc0, 0xc0, 0x3, 0xff, 0x80, 0x0, 0xfe, 0x0}

/* Uacute (218) */
#define NXFONT_METRICS_218 {3, 23, 30, 0, 7, 0}
#define NXFONT_BITMAP_218 {0x0, 0x0, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x3, 0x80, 0x0, 0x7, 0x0, 0x0, 0xc, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0xff, 0xe0, 0xfe, 0x3f, 0x80, 0x38, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f,\
                           0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10,\
                           0x1f, 0x0, 0x30, 0xf, 0x80, 0x30, 0xf, 0x80, 0x60, 0x7, 0xc0, 0xc0, 0x3, 0xff, 0x80, 0x0, 0xfe, 0x0}

/* Ucircumflex (219) */
#define NXFONT_METRICS_219 {3, 23, 30, 0, 7, 0}
#define NXFONT_BITMAP_219 {0x0, 0xc, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3f, 0x0, 0x0, 0x33, 0x0, 0x0, 0x61, 0x80, 0x0, 0x40, 0x80, 0x0, 0x0, 0x0, 0xff, 0xe0, 0xfe, 0x3f, 0x80, 0x38, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10,\
                           0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0,\
                           0x10, 0x1f, 0x0, 0x30, 0xf, 0x80, 0x30, 0xf, 0x80, 0x60, 0x7, 0xc0, 0xc0, 0x3, 0xff, 0x80, 0x0, 0xfe, 0x0}

/* Udieresis (220) */
#define NXFONT_METRICS_220 {3, 23, 29, 0, 8, 0}
#define NXFONT_BITMAP_220 {0x0, 0x21, 0x0, 0x0, 0x73, 0x80, 0x0, 0x73, 0x80, 0x0, 0x21, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xe0, 0xfe, 0x3f, 0x80, 0x38, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10,\
                           0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0, 0x10, 0x1f, 0x0,\
                           0x30, 0xf, 0x80, 0x30, 0xf, 0x80, 0x60, 0x7, 0xc0, 0xc0, 0x3, 0xff, 0x80, 0x0, 0xfe, 0x0}

/* Yacute (221) */
#define NXFONT_METRICS_221 {3, 22, 30, 1, 7, 0}
#define NXFONT_BITMAP_221 {0x0, 0x0, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x3, 0x80, 0x0, 0x7, 0x0, 0x0, 0xc, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0xff, 0xc3, 0xfc, 0x7f, 0x0, 0xf0, 0x3f, 0x0, 0x60, 0x3f, 0x0, 0x60, 0x1f, 0x80, 0xc0, 0x1f,\
                           0x80, 0x80, 0xf, 0xc1, 0x80, 0xf, 0xc3, 0x0, 0x7, 0xe3, 0x0, 0x3, 0xe6, 0x0, 0x3, 0xf4, 0x0, 0x1, 0xfc, 0x0, 0x1, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8,\
                           0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xfc, 0x0, 0x7, 0xff, 0x0}

/* Thorn (222) */
#define NXFONT_METRICS_222 {3, 19, 23, 0, 14, 0}
#define NXFONT_BITMAP_222 {0xff, 0xe0, 0x0, 0x3f, 0x80, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0xfe, 0x0, 0x1f, 0xf, 0x80, 0x1f, 0x7, 0xc0, 0x1f, 0x7, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x3, 0xe0, 0x1f, 0x7, 0xe0, 0x1f, 0x7, 0xc0, 0x1f, 0x1f, 0x80, 0x1f, 0xfe, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x3f, 0x80, 0x0, 0xff, 0xe0, 0x0}

/* germandbls (223) */
#define NXFONT_METRICS_223 {3, 17, 23, 0, 14, 0}
#define NXFONT_BITMAP_223 {0x3, 0xf0, 0x0, 0xe, 0x3c, 0x0, 0x1e, 0x3e, 0x0, 0x1c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1c, 0x0, 0x3c, 0x38, 0x0, 0x3c, 0xe0, 0x0, 0x3c, 0x3c, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x80, 0x3c, 0xf, 0x80, 0x3c, 0xf, 0x80, 0x3c, 0xf, 0x80, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0x1e, 0x0, 0xfc, 0x7c, 0x0}

/* agrave (224) */
#define NXFONT_METRICS_224 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_224 {0x30, 0x0, 0x38, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x3, 0x0, 0x0, 0x80, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xe0, 0x70, 0xf0, 0x78, 0xf0, 0x78, 0xf0, 0x30, 0xf0, 0x1, 0xf0, 0x7, 0xf0, 0x1c, 0xf0, 0x38, 0xf0, 0x78, 0xf0, 0xf0, 0xf0, 0xf9, 0xf0, 0xff, 0xf4, 0x7e, 0xfc, 0x3c, 0x78}

/* aacute (225) */
#define NXFONT_METRICS_225 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_225 {0x0, 0x30, 0x0, 0x70, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x0, 0x4, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xe0, 0x70, 0xf0, 0x78, 0xf0, 0x78, 0xf0, 0x30, 0xf0, 0x1, 0xf0, 0x7, 0xf0, 0x1c, 0xf0, 0x38, 0xf0, 0x78, 0xf0, 0xf0, 0xf0, 0xf9, 0xf0, 0xff, 0xf4, 0x7e, 0xfc, 0x3c, 0x78}

/* acircumflex (226) */
#define NXFONT_METRICS_226 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_226 {0x3, 0x0, 0x7, 0x80, 0xf, 0xc0, 0xc, 0xc0, 0x18, 0x60, 0x10, 0x20, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xe0, 0x70, 0xf0, 0x78, 0xf0, 0x78, 0xf0, 0x30, 0xf0, 0x1, 0xf0, 0x7, 0xf0, 0x1c, 0xf0, 0x38, 0xf0, 0x78, 0xf0, 0xf0, 0xf0, 0xf9, 0xf0, 0xff, 0xf4, 0x7e, 0xfc, 0x3c, 0x78}

/* atilde (227) */
#define NXFONT_METRICS_227 {2, 14, 22, 1, 15, 0}
#define NXFONT_BITMAP_227 {0xc, 0x20, 0x1f, 0x60, 0x37, 0xc0, 0x21, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xe0, 0x70, 0xf0, 0x78, 0xf0, 0x78, 0xf0, 0x30, 0xf0, 0x1, 0xf0, 0x7, 0xf0, 0x1c, 0xf0, 0x38, 0xf0, 0x78, 0xf0, 0xf0, 0xf0, 0xf9, 0xf0, 0xff, 0xf4, 0x7e, 0xfc, 0x3c, 0x78}

/* adieresis (228) */
#define NXFONT_METRICS_228 {2, 14, 22, 1, 15, 0}
#define NXFONT_BITMAP_228 {0x8, 0x40, 0x1c, 0xe0, 0x1c, 0xe0, 0x8, 0x40, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xe0, 0x70, 0xf0, 0x78, 0xf0, 0x78, 0xf0, 0x30, 0xf0, 0x1, 0xf0, 0x7, 0xf0, 0x1c, 0xf0, 0x38, 0xf0, 0x78, 0xf0, 0xf0, 0xf0, 0xf9, 0xf0, 0xff, 0xf4, 0x7e, 0xfc, 0x3c, 0x78}

/* aring (229) */
#define NXFONT_METRICS_229 {2, 14, 25, 1, 12, 0}
#define NXFONT_BITMAP_229 {0x7, 0x0, 0xd, 0x80, 0x18, 0xc0, 0x10, 0x40, 0x18, 0xc0, 0xd, 0x80, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x31, 0xe0, 0x70, 0xf0, 0x78, 0xf0, 0x78, 0xf0, 0x30, 0xf0, 0x1, 0xf0, 0x7, 0xf0, 0x1c, 0xf0, 0x38, 0xf0, 0x78, 0xf0, 0xf0, 0xf0, 0xf9, 0xf0, 0xff, 0xf4, 0x7e, 0xfc, 0x3c, 0x78}

/* ae (230) */
#define NXFONT_METRICS_230 {3, 21, 16, 1, 21, 0}
#define NXFONT_BITMAP_230 {0x1f, 0x87, 0xc0, 0x31, 0xee, 0xe0, 0x70, 0xfc, 0x70, 0x78, 0xf8, 0x70, 0x78, 0xf8, 0x38, 0x30, 0xf8, 0x38, 0x1, 0xf8, 0x38, 0x7, 0xff, 0xf8, 0x1c, 0xf8, 0x0, 0x38, 0xf8, 0x0, 0x78, 0xfc, 0x0, 0xf8, 0xfc, 0x8, 0xf8, 0xfe, 0x18, 0xff, 0xff, 0xf0, 0x7e, 0x3f, 0xe0, 0x3c, 0xf, 0xc0}

/* ccedilla (231) */
#define NXFONT_METRICS_231 {2, 13, 23, 1, 21, 0}
#define NXFONT_BITMAP_231 {0x7, 0xe0, 0x1e, 0xf0, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x30, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf8, 0x0, 0x78, 0x0, 0x78, 0x0, 0x3c, 0x30, 0x1f, 0xe0, 0xf, 0xc0, 0x3, 0x0, 0x6, 0x0, 0x6, 0x0, 0x3, 0x80, 0x31, 0x80, 0x3b, 0x80, 0x1f, 0x0}

/* egrave (232) */
#define NXFONT_METRICS_232 {2, 14, 23, 0, 14, 0}
#define NXFONT_BITMAP_232 {0x30, 0x0, 0x38, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x3, 0x0, 0x0, 0x80, 0x0, 0x0, 0x7, 0xc0, 0x1e, 0xf0, 0x3c, 0x70, 0x78, 0x38, 0x78, 0x3c, 0xf8, 0x3c, 0xf8, 0x3c, 0xff, 0xfc, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0x78, 0x0, 0x7c, 0x0, 0x3e, 0x18, 0x1f, 0xf0, 0x7, 0xe0}

/* eacute (233) */
#define NXFONT_METRICS_233 {2, 14, 23, 0, 14, 0}
#define NXFONT_BITMAP_233 {0x0, 0x18, 0x0, 0x38, 0x0, 0x70, 0x0, 0xe0, 0x1, 0x80, 0x2, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1e, 0xf0, 0x3c, 0x70, 0x78, 0x38, 0x78, 0x3c, 0xf8, 0x3c, 0xf8, 0x3c, 0xff, 0xfc, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0x78, 0x0, 0x7c, 0x0, 0x3e, 0x18, 0x1f, 0xf0, 0x7, 0xe0}

/* ecircumflex (234) */
#define NXFONT_METRICS_234 {2, 14, 23, 0, 14, 0}
#define NXFONT_BITMAP_234 {0x3, 0x0, 0x7, 0x80, 0xf, 0xc0, 0xc, 0xc0, 0x18, 0x60, 0x10, 0x20, 0x0, 0x0, 0x7, 0xc0, 0x1e, 0xf0, 0x3c, 0x70, 0x78, 0x38, 0x78, 0x3c, 0xf8, 0x3c, 0xf8, 0x3c, 0xff, 0xfc, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0x78, 0x0, 0x7c, 0x0, 0x3e, 0x18, 0x1f, 0xf0, 0x7, 0xe0}

/* edieresis (235) */
#define NXFONT_METRICS_235 {2, 14, 22, 0, 15, 0}
#define NXFONT_BITMAP_235 {0x4, 0x20, 0xe, 0x70, 0xe, 0x70, 0x4, 0x20, 0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1e, 0xf0, 0x3c, 0x70, 0x78, 0x38, 0x78, 0x3c, 0xf8, 0x3c, 0xf8, 0x3c, 0xff, 0xfc, 0xf8, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0x78, 0x0, 0x7c, 0x0, 0x3e, 0x18, 0x1f, 0xf0, 0x7, 0xe0}

/* igrave (236) */
#define NXFONT_METRICS_236 {1, 8, 23, 0, 14, 0}
#define NXFONT_BITMAP_236 {0xc0, 0xe0, 0x70, 0x38, 0xc, 0x2, 0x0, 0xfc, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7e, 0xff}

/* iacute (237) */
#define NXFONT_METRICS_237 {1, 8, 23, 0, 14, 0}
#define NXFONT_BITMAP_237 {0x3, 0x7, 0xe, 0x1c, 0x30, 0x40, 0x0, 0xfc, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7e, 0xff}

/* icircumflex (238) */
#define NXFONT_METRICS_238 {1, 8, 23, 0, 14, 0}
#define NXFONT_BITMAP_238 {0x18, 0x3c, 0x7e, 0x66, 0xc3, 0x81, 0x0, 0xfc, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7e, 0xff}

/* idieresis (239) */
#define NXFONT_METRICS_239 {1, 8, 22, 0, 15, 0}
#define NXFONT_BITMAP_239 {0x42, 0xe7, 0xe7, 0x42, 0x0, 0x0, 0xfc, 0x7c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x7e, 0xff}

/* eth (240) */
#define NXFONT_METRICS_240 {2, 14, 22, 1, 15, 0}
#define NXFONT_BITMAP_240 {0x38, 0x30, 0x3e, 0xf8, 0xf, 0xf8, 0xff, 0x80, 0xfb, 0xc0, 0x61, 0xe0, 0xf, 0xf0, 0x3c, 0xf8, 0x78, 0x78, 0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x3c, 0xf0, 0xf, 0xc0}

/* ntilde (241) */
#define NXFONT_METRICS_241 {3, 17, 22, 0, 15, 0}
#define NXFONT_BITMAP_241 {0x3, 0x8, 0x0, 0x7, 0xd8, 0x0, 0xd, 0xf0, 0x0, 0x8, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x78, 0x0, 0x7d, 0xfc, 0x0, 0x3f, 0x3e, 0x0, 0x3e, 0x1e, 0x0, 0x3e, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x7e, 0x3f, 0x0, 0xff, 0x7f, 0x80}

/* ograve (242) */
#define NXFONT_METRICS_242 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_242 {0x30, 0x0, 0x38, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x3, 0x0, 0x0, 0x80, 0x0, 0x0, 0xf, 0xc0, 0x3c, 0xf0, 0x78, 0x78, 0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x3c, 0xf0, 0xf, 0xc0}

/* oacute (243) */
#define NXFONT_METRICS_243 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_243 {0x0, 0x18, 0x0, 0x38, 0x0, 0x70, 0x0, 0xe0, 0x1, 0x80, 0x2, 0x0, 0x0, 0x0, 0xf, 0xc0, 0x3c, 0xf0, 0x78, 0x78, 0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x3c, 0xf0, 0xf, 0xc0}

/* ocircumflex (244) */
#define NXFONT_METRICS_244 {2, 14, 23, 1, 14, 0}
#define NXFONT_BITMAP_244 {0x3, 0x0, 0x7, 0x80, 0xf, 0xc0, 0xc, 0xc0, 0x18, 0x60, 0x10, 0x20, 0x0, 0x0, 0xf, 0xc0, 0x3c, 0xf0, 0x78, 0x78, 0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x3c, 0xf0, 0xf, 0xc0}

/* otilde (245) */
#define NXFONT_METRICS_245 {2, 14, 22, 1, 15, 0}
#define NXFONT_BITMAP_245 {0xc, 0x20, 0x1f, 0x60, 0x37, 0xc0, 0x21, 0x80, 0x0, 0x0, 0x0, 0x0, 0xf, 0xc0, 0x3c, 0xf0, 0x78, 0x78, 0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x3c, 0xf0, 0xf, 0xc0}

/* odieresis (246) */
#define NXFONT_METRICS_246 {2, 14, 22, 1, 15, 0}
#define NXFONT_BITMAP_246 {0x8, 0x40, 0x1c, 0xe0, 0x1c, 0xe0, 0x8, 0x40, 0x0, 0x0, 0x0, 0x0, 0xf, 0xc0, 0x3c, 0xf0, 0x78, 0x78, 0x78, 0x78, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x3c, 0xf0, 0xf, 0xc0}

/* divide (247) */
#define NXFONT_METRICS_247 {2, 14, 15, 2, 21, 0}
#define NXFONT_BITMAP_247 {0x3, 0x0, 0x7, 0x80, 0x7, 0x80, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x7, 0x80, 0x7, 0x80, 0x3, 0x0}

/* oslash (248) */
#define NXFONT_METRICS_248 {2, 14, 22, 1, 18, 0}
#define NXFONT_BITMAP_248 {0x0, 0x8, 0x0, 0x18, 0x0, 0x18, 0xf, 0xf0, 0x3c, 0xf0, 0x78, 0x78, 0x78, 0x78, 0xf0, 0xfc, 0xf1, 0xbc, 0xf1, 0x3c, 0xf3, 0x3c, 0xf2, 0x3c, 0xf6, 0x3c, 0xfc, 0x3c, 0xf8, 0x3c, 0x78, 0x78, 0x78, 0x78, 0x3c, 0xf0, 0x6f, 0xc0, 0x60, 0x0, 0xc0, 0x0, 0x80, 0x0}

/* ugrave (249) */
#define NXFONT_METRICS_249 {3, 17, 23, 0, 14, 0}
#define NXFONT_BITMAP_249 {0x18, 0x0, 0x0, 0x1c, 0x0, 0x0, 0xe, 0x0, 0x0, 0x7, 0x0, 0x0, 0x1, 0x80, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x7e, 0x0, 0x7c, 0x3e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x3e, 0x0, 0x3e, 0x7f, 0x0, 0x1f, 0xdf, 0x80, 0x7, 0x8c, 0x0}

/* uacute (250) */
#define NXFONT_METRICS_250 {3, 17, 23, 0, 14, 0}
#define NXFONT_BITMAP_250 {0x0, 0xc, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x38, 0x0, 0x0, 0x70, 0x0, 0x0, 0xc0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x7e, 0x0, 0x7c, 0x3e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x3e, 0x0, 0x3e, 0x7f, 0x0, 0x1f, 0xdf, 0x80, 0x7, 0x8c, 0x0}

/* ucircumflex (251) */
#define NXFONT_METRICS_251 {3, 17, 23, 0, 14, 0}
#define NXFONT_BITMAP_251 {0x1, 0x80, 0x0, 0x3, 0xc0, 0x0, 0x7, 0xe0, 0x0, 0x6, 0x60, 0x0, 0xc, 0x30, 0x0, 0x8, 0x10, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x7e, 0x0, 0x7c, 0x3e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x3e, 0x0, 0x3e, 0x7f, 0x0, 0x1f, 0xdf, 0x80, 0x7, 0x8c, 0x0}

/* udieresis (252) */
#define NXFONT_METRICS_252 {3, 17, 22, 0, 15, 0}
#define NXFONT_BITMAP_252 {0x4, 0x20, 0x0, 0xe, 0x70, 0x0, 0xe, 0x70, 0x0, 0x4, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x7e, 0x0, 0x7c, 0x3e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0x0, 0x3c, 0x3e, 0x0, 0x3e, 0x7f, 0x0, 0x1f, 0xdf, 0x80, 0x7, 0x8c, 0x0}

/* yacute (253) */
#define NXFONT_METRICS_253 {2, 15, 30, 0, 14, 0}
#define NXFONT_BITMAP_253 {0x0, 0xc, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x70, 0x0, 0xc0, 0x1, 0x0, 0x0, 0x0, 0xff, 0xbe, 0x7e, 0xc, 0x3e, 0x8, 0x3e, 0x8, 0x1f, 0x18, 0x1f, 0x10, 0xf, 0x10, 0xf, 0xb0, 0xf, 0xa0, 0x7, 0xa0, 0x7, 0xe0, 0x7, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x0, 0x73, 0x0, 0xf3, 0x0, 0xf6, 0x0, 0xfe, 0x0, 0x78, 0x0}

/* thorn (254) */
#define NXFONT_METRICS_254 {2, 15, 29, 1, 15, 0}
#define NXFONT_BITMAP_254 {0xfc, 0x0, 0x7c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0xe0, 0x3f, 0xf8, 0x3e, 0x7c, 0x3c, 0x3c, 0x3c, 0x3e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x3c, 0x3e, 0x3c, 0x3f, 0xf8, 0x3c, 0xe0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x7e, 0x0, 0xff, 0x0}

/* ydieresis (255) */
#define NXFONT_METRICS_255 {2, 15, 29, 0, 15, 0}
#define NXFONT_BITMAP_255 {0x4, 0x20, 0xe, 0x70, 0xe, 0x70, 0x4, 0x20, 0x0, 0x0, 0x0, 0x0, 0xff, 0xbe, 0x7e, 0xc, 0x3e, 0x8, 0x3e, 0x8, 0x1f, 0x18, 0x1f, 0x10, 0xf, 0x10, 0xf, 0xb0, 0xf, 0xa0, 0x7, 0xa0, 0x7, 0xe0, 0x7, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x0, 0x73, 0x0, 0xf3, 0x0, 0xf6, 0x0, 0xfe, 0x0, 0x78, 0x0}

/****************************************************************************
 * Public Types
 ****************************************************************************/

/****************************************************************************
 * Public Data
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
#define EXTERN extern "C"
extern "C"
{
#else
#define EXTERN extern
#endif

/****************************************************************************
 * Public Functions Definitions
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
}
#endif

#endif /* __LIBS_LIBNX_NXFONTS_NXFONTS_SERIF38X49B_H */
