/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.extension;

import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.extension.BundleVersionCoordinate;
import org.apache.nifi.registry.extension.BundleVersionType;

public class StandardBundleVersionCoordinate
implements BundleVersionCoordinate {
    private final String bucketId;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final BundleVersionType type;

    private StandardBundleVersionCoordinate(Builder builder) {
        this.bucketId = builder.bucketId;
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
        this.type = builder.type;
        Validate.notBlank((CharSequence)this.bucketId, (String)"Bucket Id is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.groupId, (String)"Group Id is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.artifactId, (String)"Artifact Id is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.version, (String)"Version is required", (Object[])new Object[0]);
        Validate.notNull((Object)this.type, (String)"BundleVersionType is required", (Object[])new Object[0]);
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public BundleVersionType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardBundleVersionCoordinate that = (StandardBundleVersionCoordinate)o;
        return this.bucketId.equals(that.bucketId) && this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId) && this.version.equals(that.version) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.groupId, this.artifactId, this.version, this.type);
    }

    public String toString() {
        return "BundleVersionCoordinate [bucketId='" + this.bucketId + "', groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', version='" + this.version + "', type=" + String.valueOf(this.type) + "]";
    }

    public static class Builder {
        private String bucketId;
        private String groupId;
        private String artifactId;
        private String version;
        private BundleVersionType type;

        public Builder bucketId(String bucketId) {
            this.bucketId = bucketId;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder type(BundleVersionType type) {
            this.type = type;
            return this;
        }

        public StandardBundleVersionCoordinate build() {
            return new StandardBundleVersionCoordinate(this);
        }
    }
}

