/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import java.io.IOException;
import java.io.OutputStream;

public class JacksonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectWriter OBJECT_WRITER;

    public static ObjectMapper getObjectMapper() {
        return MAPPER;
    }

    public static ObjectWriter getObjectWriter() {
        return OBJECT_WRITER;
    }

    public static void write(Object result, final OutputStream output) throws IOException {
        OBJECT_WRITER.writeValue(new OutputStream(){

            @Override
            public void write(byte[] b) throws IOException {
                output.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                output.write(b, off, len);
            }

            @Override
            public void write(int b) throws IOException {
                output.write(b);
            }

            @Override
            public void close() throws IOException {
                output.flush();
            }
        }, result);
    }

    static {
        MAPPER.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.setAnnotationIntrospector((AnnotationIntrospector)new JakartaXmlBindAnnotationIntrospector(MAPPER.getTypeFactory()));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_WRITER = MAPPER.writerWithDefaultPrettyPrinter();
    }
}

