/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.io.PrintStream;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.DataCorruptionException;
import jetbrains.exodus.log.DataIterator;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.TreeCursor;
import jetbrains.exodus.tree.btree.AddressIterator;
import jetbrains.exodus.tree.btree.BTreeBalancePolicy;
import jetbrains.exodus.tree.btree.BTreeCursorDup;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeMutatingTraverser;
import jetbrains.exodus.tree.btree.BTreeMutatingTraverserDup;
import jetbrains.exodus.tree.btree.BTreeTraverser;
import jetbrains.exodus.tree.btree.BTreeTraverserDup;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.BasePageImmutable;
import jetbrains.exodus.tree.btree.BottomPage;
import jetbrains.exodus.tree.btree.ILeafNode;
import jetbrains.exodus.tree.btree.InternalPage;
import jetbrains.exodus.tree.btree.LeafNode;
import jetbrains.exodus.tree.btree.LeafNodeDup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BTreeBase
implements ITree {
    public static final byte BOTTOM_ROOT = 2;
    public static final byte INTERNAL_ROOT = 3;
    public static final byte BOTTOM = 4;
    public static final byte INTERNAL = 5;
    public static final byte LEAF = 6;
    public static final byte LEAF_DUP_BOTTOM_ROOT = 7;
    public static final byte LEAF_DUP_INTERNAL_ROOT = 8;
    public static final byte DUP_BOTTOM = 9;
    public static final byte DUP_INTERNAL = 10;
    public static final byte DUP_LEAF = 11;
    @NotNull
    protected final Log log;
    protected DataIterator dataIterator = null;
    @NotNull
    protected final BTreeBalancePolicy balancePolicy;
    protected final boolean allowsDuplicates;
    protected long size = -1L;
    protected final int structureId;

    BTreeBase(@NotNull Log log, @NotNull BTreeBalancePolicy balancePolicy, boolean allowsDuplicates, int structureId) {
        this.log = log;
        this.balancePolicy = balancePolicy;
        this.allowsDuplicates = allowsDuplicates;
        this.structureId = structureId;
    }

    @Override
    @NotNull
    public abstract BTreeMutable getMutableCopy();

    @NotNull
    protected abstract BasePage getRoot();

    @Override
    public int getStructureId() {
        return this.structureId;
    }

    @Override
    public boolean isEmpty() {
        return this.getRoot().getSize() == 0;
    }

    @Override
    @NotNull
    public Log getLog() {
        return this.log;
    }

    @Override
    @NotNull
    public DataIterator getDataIterator(long address) {
        if (this.dataIterator == null) {
            this.dataIterator = new DataIterator(this.log, address);
        } else if (address >= 0L) {
            this.dataIterator.checkPage(address);
        }
        return this.dataIterator;
    }

    @NotNull
    public BTreeBalancePolicy getBalancePolicy() {
        return this.balancePolicy;
    }

    @Override
    public AddressIterator addressIterator() {
        BTreeTraverser traverser = this.allowsDuplicates ? BTreeMutatingTraverserDup.create(this) : BTreeMutatingTraverser.create(this);
        return new AddressIterator(this.isEmpty() ? null : this, traverser.currentPos >= 0 && !this.isEmpty(), traverser);
    }

    @Override
    public ITreeCursor openCursor() {
        return this.allowsDuplicates ? new BTreeCursorDup(new BTreeTraverserDup(this.getRoot())) : new TreeCursor(new BTreeTraverser(this.getRoot()));
    }

    protected final RandomAccessLoggable getLoggable(long address) {
        return this.log.readNotNull(this.getDataIterator(address), address);
    }

    @NotNull
    protected final BasePageImmutable loadPage(long address) {
        RandomAccessLoggable loggable = this.getLoggable(address);
        return this.loadPage(loggable.getType(), loggable.getData());
    }

    @NotNull
    protected final BasePageImmutable loadPage(int type, @NotNull ByteIterableWithAddress data) {
        BasePageImmutable result;
        switch (type) {
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                result = new BottomPage(this, data);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                result = new InternalPage(this, data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown loggable type [" + type + ']');
            }
        }
        return result;
    }

    @NotNull
    protected LeafNode loadLeaf(long address) {
        RandomAccessLoggable loggable = this.getLoggable(address);
        byte type = loggable.getType();
        switch (type) {
            case 6: 
            case 11: {
                return new LeafNode(loggable);
            }
            case 7: 
            case 8: {
                if (this.allowsDuplicates) {
                    return new LeafNodeDup(this, loggable);
                }
                throw new ExodusException("Try to load leaf with duplicates, but tree is not configured to support duplicates.");
            }
        }
        DataCorruptionException.raise("Unexpected loggable type: " + type, this.log, address);
        throw new RuntimeException();
    }

    protected boolean isDupKey(long address) {
        byte type = this.getLoggable(address).getType();
        return type == 7 || type == 8;
    }

    int compareLeafToKey(long address, @NotNull ByteIterable key) {
        RandomAccessLoggable loggable = this.getLoggable(address);
        ByteIterableWithAddress data = loggable.getData();
        int keyLength = data.getCompressedUnsignedInt();
        int keyRecordSize = CompressedUnsignedLongByteIterable.getCompressedSize(keyLength);
        return data.compareTo(keyRecordSize, keyLength, key);
    }

    @Override
    @Nullable
    public ByteIterable get(@NotNull ByteIterable key) {
        ILeafNode leaf = this.getRoot().get(key);
        return leaf == null ? null : leaf.getValue();
    }

    @Override
    public boolean hasKey(@NotNull ByteIterable key) {
        return this.getRoot().keyExists(key);
    }

    @Override
    public boolean hasPair(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.getRoot().exists(key, value);
    }

    @Override
    public void dump(PrintStream out) {
        this.getRoot().dump(out, 0, null);
    }

    @Override
    public void dump(PrintStream out, Dumpable.ToString renderer) {
        this.getRoot().dump(out, 0, renderer);
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

