/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.nifi.registry.extension.BundlePersistenceProvider;
import org.apache.nifi.registry.extension.ExtensionClassLoader;
import org.apache.nifi.registry.extension.ExtensionManager;
import org.apache.nifi.registry.flow.FlowPersistenceProvider;
import org.apache.nifi.registry.hook.EventHookProvider;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.provider.ProviderConfigurationContext;
import org.apache.nifi.registry.provider.ProviderContext;
import org.apache.nifi.registry.provider.ProviderFactory;
import org.apache.nifi.registry.provider.ProviderFactoryException;
import org.apache.nifi.registry.provider.StandardProviderConfigurationContext;
import org.apache.nifi.registry.provider.generated.Property;
import org.apache.nifi.registry.provider.generated.Provider;
import org.apache.nifi.registry.provider.generated.Providers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.xml.sax.SAXException;

@Configuration
public class StandardProviderFactory
implements ProviderFactory,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardProviderFactory.class);
    private static final String PROVIDERS_XSD = "/providers.xsd";
    private static final String JAXB_GENERATED_PATH = "org.apache.nifi.registry.provider.generated";
    private static final JAXBContext JAXB_CONTEXT = StandardProviderFactory.initializeJaxbContext();
    private final NiFiRegistryProperties properties;
    private final ExtensionManager extensionManager;
    private final DataSource dataSource;
    private final AtomicReference<Providers> providersHolder = new AtomicReference<Object>(null);
    private FlowPersistenceProvider flowPersistenceProvider;
    private List<EventHookProvider> eventHookProviders;
    private BundlePersistenceProvider bundlePersistenceProvider;

    private static JAXBContext initializeJaxbContext() {
        try {
            return JAXBContext.newInstance((String)JAXB_GENERATED_PATH, (ClassLoader)StandardProviderFactory.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.", e);
        }
    }

    @Autowired
    public StandardProviderFactory(NiFiRegistryProperties properties, ExtensionManager extensionManager, DataSource dataSource) {
        this.properties = properties;
        this.extensionManager = extensionManager;
        this.dataSource = dataSource;
        if (this.properties == null) {
            throw new IllegalStateException("NiFiRegistryProperties cannot be null");
        }
        if (this.extensionManager == null) {
            throw new IllegalStateException("ExtensionManager cannot be null");
        }
        if (this.dataSource == null) {
            throw new IllegalStateException("DataSource cannot be null");
        }
    }

    @Override
    @PostConstruct
    public synchronized void initialize() throws ProviderFactoryException {
        if (this.providersHolder.get() == null) {
            File providersConfigFile = this.properties.getProvidersConfigurationFile();
            if (providersConfigFile.exists()) {
                try {
                    SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    Schema schema = schemaFactory.newSchema(StandardProviderFactory.class.getResource(PROVIDERS_XSD));
                    Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
                    unmarshaller.setSchema(schema);
                    JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(providersConfigFile), Providers.class);
                    this.providersHolder.set((Providers)element.getValue());
                }
                catch (JAXBException | SAXException e) {
                    LOGGER.error(e.getMessage(), e);
                    throw new ProviderFactoryException("Unable to load the providers configuration file at: " + providersConfigFile.getAbsolutePath(), e);
                }
            } else {
                throw new ProviderFactoryException("Unable to find the providers configuration file at " + providersConfigFile.getAbsolutePath());
            }
        }
    }

    @Override
    @Bean
    public synchronized FlowPersistenceProvider getFlowPersistenceProvider() {
        if (this.flowPersistenceProvider == null) {
            if (this.providersHolder.get() == null) {
                throw new ProviderFactoryException("ProviderFactory must be initialized before obtaining a Provider");
            }
            Providers providers = this.providersHolder.get();
            Provider jaxbFlowProvider = providers.getFlowPersistenceProvider();
            String flowProviderClassName = jaxbFlowProvider.getClazz();
            try {
                ExtensionClassLoader classLoader = this.extensionManager.getExtensionClassLoader(flowProviderClassName);
                if (classLoader == null) {
                    throw new IllegalStateException("Extension not found in any of the configured class loaders: " + flowProviderClassName);
                }
                Class<?> rawFlowProviderClass = Class.forName(flowProviderClassName, true, classLoader);
                Class<FlowPersistenceProvider> flowProviderClass = rawFlowProviderClass.asSubclass(FlowPersistenceProvider.class);
                Constructor<FlowPersistenceProvider> constructor = flowProviderClass.getConstructor(new Class[0]);
                this.flowPersistenceProvider = constructor.newInstance(new Object[0]);
                this.performMethodInjection(this.flowPersistenceProvider, flowProviderClass);
                LOGGER.info("Instantiated FlowPersistenceProvider with class name {}", (Object)flowProviderClassName);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ProviderFactoryException("Error creating FlowPersistenceProvider with class name: " + flowProviderClassName, e);
            }
            ProviderConfigurationContext configurationContext = this.createConfigurationContext(jaxbFlowProvider.getProperty());
            this.flowPersistenceProvider.onConfigured(configurationContext);
            LOGGER.info("Configured FlowPersistenceProvider with class name {}", (Object)flowProviderClassName);
        }
        return this.flowPersistenceProvider;
    }

    @Override
    @Bean
    public List<EventHookProvider> getEventHookProviders() {
        if (this.eventHookProviders == null) {
            this.eventHookProviders = new ArrayList<EventHookProvider>();
            if (this.providersHolder.get() == null) {
                throw new ProviderFactoryException("ProviderFactory must be initialized before obtaining a Provider");
            }
            Providers providers = this.providersHolder.get();
            List<Provider> jaxbHookProvider = providers.getEventHookProvider();
            if (jaxbHookProvider == null || jaxbHookProvider.isEmpty()) {
                return this.eventHookProviders;
            }
            for (Provider hookProvider : jaxbHookProvider) {
                EventHookProvider hook;
                String hookProviderClassName = hookProvider.getClazz();
                try {
                    ExtensionClassLoader classLoader = this.extensionManager.getExtensionClassLoader(hookProviderClassName);
                    if (classLoader == null) {
                        throw new IllegalStateException("Extension not found in any of the configured class loaders: " + hookProviderClassName);
                    }
                    Class<?> rawHookProviderClass = Class.forName(hookProviderClassName, true, classLoader);
                    Class<EventHookProvider> hookProviderClass = rawHookProviderClass.asSubclass(EventHookProvider.class);
                    Constructor<EventHookProvider> constructor = hookProviderClass.getConstructor(new Class[0]);
                    hook = constructor.newInstance(new Object[0]);
                    this.performMethodInjection(hook, hookProviderClass);
                    LOGGER.info("Instantiated EventHookProvider with class name {}", (Object)hookProviderClassName);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new ProviderFactoryException("Error creating EventHookProvider with class name: " + hookProviderClassName, e);
                }
                ProviderConfigurationContext configurationContext = this.createConfigurationContext(hookProvider.getProperty());
                hook.onConfigured(configurationContext);
                this.eventHookProviders.add(hook);
                LOGGER.info("Configured EventHookProvider with class name {}", (Object)hookProviderClassName);
            }
        }
        return this.eventHookProviders;
    }

    @Override
    @Bean
    public synchronized BundlePersistenceProvider getBundlePersistenceProvider() {
        if (this.bundlePersistenceProvider == null) {
            if (this.providersHolder.get() == null) {
                throw new ProviderFactoryException("ProviderFactory must be initialized before obtaining a Provider");
            }
            Providers providers = this.providersHolder.get();
            Provider jaxbExtensionBundleProvider = providers.getExtensionBundlePersistenceProvider();
            String extensionBundleProviderClassName = jaxbExtensionBundleProvider.getClazz();
            try {
                ExtensionClassLoader classLoader = this.extensionManager.getExtensionClassLoader(extensionBundleProviderClassName);
                if (classLoader == null) {
                    throw new IllegalStateException("Extension not found in any of the configured class loaders: " + extensionBundleProviderClassName);
                }
                Class<?> rawProviderClass = Class.forName(extensionBundleProviderClassName, true, classLoader);
                Class<BundlePersistenceProvider> extensionBundleProviderClass = rawProviderClass.asSubclass(BundlePersistenceProvider.class);
                Constructor<BundlePersistenceProvider> constructor = extensionBundleProviderClass.getConstructor(new Class[0]);
                this.bundlePersistenceProvider = constructor.newInstance(new Object[0]);
                this.performMethodInjection(this.bundlePersistenceProvider, extensionBundleProviderClass);
                LOGGER.info("Instantiated BundlePersistenceProvider with class name {}", (Object)extensionBundleProviderClassName);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ProviderFactoryException("Error creating BundlePersistenceProvider with class name: " + extensionBundleProviderClassName, e);
            }
            ProviderConfigurationContext configurationContext = this.createConfigurationContext(jaxbExtensionBundleProvider.getProperty());
            this.bundlePersistenceProvider.onConfigured(configurationContext);
            LOGGER.info("Configured BundlePersistenceProvider with class name {}", (Object)extensionBundleProviderClassName);
        }
        return this.bundlePersistenceProvider;
    }

    public void destroy() throws Exception {
        ArrayList<EventHookProvider> providers = new ArrayList<EventHookProvider>(this.eventHookProviders);
        providers.add((EventHookProvider)this.flowPersistenceProvider);
        providers.add((EventHookProvider)this.bundlePersistenceProvider);
        for (org.apache.nifi.registry.provider.Provider provider : providers) {
            if (provider == null) continue;
            try {
                provider.preDestruction();
            }
            catch (Throwable t) {
                LOGGER.error(t.getMessage(), t);
            }
        }
    }

    private ProviderConfigurationContext createConfigurationContext(List<Property> configProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (configProperties != null) {
            configProperties.stream().forEach(p -> properties.put(p.getName(), p.getValue()));
        }
        return new StandardProviderConfigurationContext(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performMethodInjection(Object instance, Class providerClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : providerClass.getMethods()) {
            if (!method.isAnnotationPresent(ProviderContext.class)) continue;
            boolean isAccessible = method.isAccessible();
            method.setAccessible(true);
            try {
                Class<?> argumentType;
                Class<?>[] argumentTypes = method.getParameterTypes();
                if (argumentTypes.length != 1 || !DataSource.class.isAssignableFrom(argumentType = argumentTypes[0])) continue;
                method.invoke(instance, this.dataSource);
            }
            finally {
                method.setAccessible(isAccessible);
            }
        }
        Class parentClass = providerClass.getSuperclass();
        if (parentClass != null && org.apache.nifi.registry.provider.Provider.class.isAssignableFrom(parentClass)) {
            this.performMethodInjection(instance, parentClass);
        }
    }
}

