/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.EnumSet;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class LoggerNotStaticFinal {
    public static ErrorDescription checkLoggerDeclaration(HintContext ctx) {
        Element e = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (!(e == null || e.getEnclosingElement().getKind() != ElementKind.CLASS || e.getModifiers().contains((Object)Modifier.STATIC) && e.getModifiers().contains((Object)Modifier.FINAL) || ctx.getInfo().getElementUtilities().outermostTypeElement(e) != e.getEnclosingElement())) {
            return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(LoggerNotStaticFinal.class, "MSG_LoggerNotStaticFinal_checkLoggerDeclaration", e), new LoggerNotStaticFinalFix(NbBundle.getMessage(LoggerNotStaticFinal.class, "MSG_LoggerNotStaticFinal_checkLoggerDeclaration_fix", e), TreePathHandle.create(e, ctx.getInfo())).toEditorFix());
        }
        return null;
    }

    private static final class LoggerNotStaticFinalFix
    extends JavaFix {
        private final String text;

        public LoggerNotStaticFinalFix(String text, TreePathHandle loggerFieldHandle) {
            super(loggerFieldHandle);
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            VariableTree vt = (VariableTree)tp.getLeaf();
            ModifiersTree mt = vt.getModifiers();
            EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
            modifiers.addAll(mt.getFlags());
            modifiers.add(Modifier.FINAL);
            modifiers.add(Modifier.STATIC);
            ModifiersTree newMod = wc.getTreeMaker().Modifiers(modifiers, mt.getAnnotations());
            wc.rewrite(mt, newMod);
        }
    }
}

