/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.util.HashMap;
import java.util.Map;

import javax.faces.view.facelets.FaceletHandler;

import org.apache.myfaces.view.facelets.tag.TagLibrary;

/**
 * 
 * @author Jacob Hookom
 * @version $Id$
 */
final class NamespaceUnit extends CompilationUnit
{

    private final Map<String, String> ns = new HashMap<>();
    private final TagLibrary library;

    public NamespaceUnit(TagLibrary library)
    {
        this.library = library;
    }

    @Override
    public FaceletHandler createFaceletHandler()
    {
        FaceletHandler next = this.getNextFaceletHandler();
        return new NamespaceHandler(next, this.library, this.ns);
    }

    public void setNamespace(String prefix, String uri)
    {
        this.ns.put(prefix, uri);
    }

}
