/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package javax.faces.component.html;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;


// Generated from class javax.faces.component.html._HtmlInputSecret.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlInputSecret extends javax.faces.component.UIInput
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Input";
    static public final String COMPONENT_TYPE =
        "javax.faces.HtmlInputSecret";


    public HtmlInputSecret()
    {
        setRendererType("javax.faces.Secret");
    }

    @Override    
    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }
    

    // Property: maxlength
    private int _maxlength;
    
    private boolean _maxlengthSet;
    
    public int getMaxlength()
    {
        if (_maxlengthSet)
        {
            return _maxlength;
        }
        ValueExpression vb = getValueExpression("maxlength");
        if (vb != null)
        {
            return ((Integer) vb.getValue(getFacesContext().getELContext())).intValue();
        }
        return Integer.MIN_VALUE; 
    }

    public void setMaxlength(int maxlength)
    {
        this._maxlength = maxlength;
        this._maxlengthSet = true;        
    }
    // Property: redisplay
    private boolean _redisplay;
    
    private boolean _redisplaySet;
    
    public boolean isRedisplay()
    {
        if (_redisplaySet)
        {
            return _redisplay;
        }
        ValueExpression vb = getValueExpression("redisplay");
        if (vb != null)
        {
            return ((Boolean) vb.getValue(getFacesContext().getELContext())).booleanValue();
        }
        return false; 
    }

    public void setRedisplay(boolean redisplay)
    {
        this._redisplay = redisplay;
        this._redisplaySet = true;        
    }
    // Property: size
    private int _size;
    
    private boolean _sizeSet;
    
    public int getSize()
    {
        if (_sizeSet)
        {
            return _size;
        }
        ValueExpression vb = getValueExpression("size");
        if (vb != null)
        {
            return ((Integer) vb.getValue(getFacesContext().getELContext())).intValue();
        }
        return Integer.MIN_VALUE; 
    }

    public void setSize(int size)
    {
        this._size = size;
        this._sizeSet = true;        
    }
    // Property: autocomplete
    private String _autocomplete;
    
    public String getAutocomplete()
    {
        if (_autocomplete != null)
        {
            return _autocomplete;
        }
        ValueExpression vb = getValueExpression("autocomplete");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setAutocomplete(String autocomplete)
    {
        this._autocomplete = autocomplete;
    }
    // Property: label
    private String _label;
    
    public String getLabel()
    {
        if (_label != null)
        {
            return _label;
        }
        ValueExpression vb = getValueExpression("label");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setLabel(String label)
    {
        this._label = label;
    }
    // Property: style
    private String _style;
    
    public String getStyle()
    {
        if (_style != null)
        {
            return _style;
        }
        ValueExpression vb = getValueExpression("style");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String style)
    {
        this._style = style;
    }
    // Property: styleClass
    private String _styleClass;
    
    public String getStyleClass()
    {
        if (_styleClass != null)
        {
            return _styleClass;
        }
        ValueExpression vb = getValueExpression("styleClass");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String styleClass)
    {
        this._styleClass = styleClass;
    }
    // Property: alt
    private String _alt;
    
    public String getAlt()
    {
        if (_alt != null)
        {
            return _alt;
        }
        ValueExpression vb = getValueExpression("alt");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setAlt(String alt)
    {
        this._alt = alt;
    }
    // Property: tabindex
    private String _tabindex;
    
    public String getTabindex()
    {
        if (_tabindex != null)
        {
            return _tabindex;
        }
        ValueExpression vb = getValueExpression("tabindex");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setTabindex(String tabindex)
    {
        this._tabindex = tabindex;
    }
    // Property: onblur
    private String _onblur;
    
    public String getOnblur()
    {
        if (_onblur != null)
        {
            return _onblur;
        }
        ValueExpression vb = getValueExpression("onblur");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnblur(String onblur)
    {
        this._onblur = onblur;
    }
    // Property: onfocus
    private String _onfocus;
    
    public String getOnfocus()
    {
        if (_onfocus != null)
        {
            return _onfocus;
        }
        ValueExpression vb = getValueExpression("onfocus");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnfocus(String onfocus)
    {
        this._onfocus = onfocus;
    }
    // Property: accesskey
    private String _accesskey;
    
    public String getAccesskey()
    {
        if (_accesskey != null)
        {
            return _accesskey;
        }
        ValueExpression vb = getValueExpression("accesskey");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setAccesskey(String accesskey)
    {
        this._accesskey = accesskey;
    }
    // Property: onchange
    private String _onchange;
    
    public String getOnchange()
    {
        if (_onchange != null)
        {
            return _onchange;
        }
        ValueExpression vb = getValueExpression("onchange");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnchange(String onchange)
    {
        this._onchange = onchange;
    }
    // Property: onselect
    private String _onselect;
    
    public String getOnselect()
    {
        if (_onselect != null)
        {
            return _onselect;
        }
        ValueExpression vb = getValueExpression("onselect");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnselect(String onselect)
    {
        this._onselect = onselect;
    }
    // Property: onclick
    private String _onclick;
    
    public String getOnclick()
    {
        if (_onclick != null)
        {
            return _onclick;
        }
        ValueExpression vb = getValueExpression("onclick");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnclick(String onclick)
    {
        this._onclick = onclick;
    }
    // Property: ondblclick
    private String _ondblclick;
    
    public String getOndblclick()
    {
        if (_ondblclick != null)
        {
            return _ondblclick;
        }
        ValueExpression vb = getValueExpression("ondblclick");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOndblclick(String ondblclick)
    {
        this._ondblclick = ondblclick;
    }
    // Property: onkeydown
    private String _onkeydown;
    
    public String getOnkeydown()
    {
        if (_onkeydown != null)
        {
            return _onkeydown;
        }
        ValueExpression vb = getValueExpression("onkeydown");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnkeydown(String onkeydown)
    {
        this._onkeydown = onkeydown;
    }
    // Property: onkeypress
    private String _onkeypress;
    
    public String getOnkeypress()
    {
        if (_onkeypress != null)
        {
            return _onkeypress;
        }
        ValueExpression vb = getValueExpression("onkeypress");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnkeypress(String onkeypress)
    {
        this._onkeypress = onkeypress;
    }
    // Property: onkeyup
    private String _onkeyup;
    
    public String getOnkeyup()
    {
        if (_onkeyup != null)
        {
            return _onkeyup;
        }
        ValueExpression vb = getValueExpression("onkeyup");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnkeyup(String onkeyup)
    {
        this._onkeyup = onkeyup;
    }
    // Property: onmousedown
    private String _onmousedown;
    
    public String getOnmousedown()
    {
        if (_onmousedown != null)
        {
            return _onmousedown;
        }
        ValueExpression vb = getValueExpression("onmousedown");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnmousedown(String onmousedown)
    {
        this._onmousedown = onmousedown;
    }
    // Property: onmousemove
    private String _onmousemove;
    
    public String getOnmousemove()
    {
        if (_onmousemove != null)
        {
            return _onmousemove;
        }
        ValueExpression vb = getValueExpression("onmousemove");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnmousemove(String onmousemove)
    {
        this._onmousemove = onmousemove;
    }
    // Property: onmouseout
    private String _onmouseout;
    
    public String getOnmouseout()
    {
        if (_onmouseout != null)
        {
            return _onmouseout;
        }
        ValueExpression vb = getValueExpression("onmouseout");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnmouseout(String onmouseout)
    {
        this._onmouseout = onmouseout;
    }
    // Property: onmouseover
    private String _onmouseover;
    
    public String getOnmouseover()
    {
        if (_onmouseover != null)
        {
            return _onmouseover;
        }
        ValueExpression vb = getValueExpression("onmouseover");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnmouseover(String onmouseover)
    {
        this._onmouseover = onmouseover;
    }
    // Property: onmouseup
    private String _onmouseup;
    
    public String getOnmouseup()
    {
        if (_onmouseup != null)
        {
            return _onmouseup;
        }
        ValueExpression vb = getValueExpression("onmouseup");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnmouseup(String onmouseup)
    {
        this._onmouseup = onmouseup;
    }
    // Property: dir
    private String _dir;
    
    public String getDir()
    {
        if (_dir != null)
        {
            return _dir;
        }
        ValueExpression vb = getValueExpression("dir");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setDir(String dir)
    {
        this._dir = dir;
    }
    // Property: lang
    private String _lang;
    
    public String getLang()
    {
        if (_lang != null)
        {
            return _lang;
        }
        ValueExpression vb = getValueExpression("lang");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setLang(String lang)
    {
        this._lang = lang;
    }
    // Property: title
    private String _title;
    
    public String getTitle()
    {
        if (_title != null)
        {
            return _title;
        }
        ValueExpression vb = getValueExpression("title");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setTitle(String title)
    {
        this._title = title;
    }
    // Property: disabled
    private boolean _disabled;
    
    private boolean _disabledSet;
    
    public boolean isDisabled()
    {
        if (_disabledSet)
        {
            return _disabled;
        }
        ValueExpression vb = getValueExpression("disabled");
        if (vb != null)
        {
            return ((Boolean) vb.getValue(getFacesContext().getELContext())).booleanValue();
        }
        return false; 
    }

    public void setDisabled(boolean disabled)
    {
        this._disabled = disabled;
        this._disabledSet = true;        
    }
    // Property: readonly
    private boolean _readonly;
    
    private boolean _readonlySet;
    
    public boolean isReadonly()
    {
        if (_readonlySet)
        {
            return _readonly;
        }
        ValueExpression vb = getValueExpression("readonly");
        if (vb != null)
        {
            return ((Boolean) vb.getValue(getFacesContext().getELContext())).booleanValue();
        }
        return false; 
    }

    public void setReadonly(boolean readonly)
    {
        this._readonly = readonly;
        this._readonlySet = true;        
    }

    @Override
    public Object saveState(FacesContext facesContext)
    {
        Object[] values = new Object[35];
        values[0] = super.saveState(facesContext);
        values[1] = Integer.valueOf(_maxlength);
        values[2] = Boolean.valueOf(_maxlengthSet);
        values[3] = Boolean.valueOf(_redisplay);
        values[4] = Boolean.valueOf(_redisplaySet);
        values[5] = Integer.valueOf(_size);
        values[6] = Boolean.valueOf(_sizeSet);
        values[7] = _autocomplete;
        values[8] = _label;
        values[9] = _style;
        values[10] = _styleClass;
        values[11] = _alt;
        values[12] = _tabindex;
        values[13] = _onblur;
        values[14] = _onfocus;
        values[15] = _accesskey;
        values[16] = _onchange;
        values[17] = _onselect;
        values[18] = _onclick;
        values[19] = _ondblclick;
        values[20] = _onkeydown;
        values[21] = _onkeypress;
        values[22] = _onkeyup;
        values[23] = _onmousedown;
        values[24] = _onmousemove;
        values[25] = _onmouseout;
        values[26] = _onmouseover;
        values[27] = _onmouseup;
        values[28] = _dir;
        values[29] = _lang;
        values[30] = _title;
        values[31] = Boolean.valueOf(_disabled);
        values[32] = Boolean.valueOf(_disabledSet);
        values[33] = Boolean.valueOf(_readonly);
        values[34] = Boolean.valueOf(_readonlySet);
        return values; 
    }

    @Override
    public void restoreState(FacesContext facesContext, Object state)
    {
        Object[] values = (Object[])state;
        super.restoreState(facesContext,values[0]);
        _maxlength = ((Integer) values[1]).intValue();
        _maxlengthSet = ((Boolean) values[2]).booleanValue();
        _redisplay = ((Boolean) values[3]).booleanValue();
        _redisplaySet = ((Boolean) values[4]).booleanValue();
        _size = ((Integer) values[5]).intValue();
        _sizeSet = ((Boolean) values[6]).booleanValue();
        _autocomplete = (java.lang.String) values[7];
        _label = (java.lang.String) values[8];
        _style = (java.lang.String) values[9];
        _styleClass = (java.lang.String) values[10];
        _alt = (java.lang.String) values[11];
        _tabindex = (java.lang.String) values[12];
        _onblur = (java.lang.String) values[13];
        _onfocus = (java.lang.String) values[14];
        _accesskey = (java.lang.String) values[15];
        _onchange = (java.lang.String) values[16];
        _onselect = (java.lang.String) values[17];
        _onclick = (java.lang.String) values[18];
        _ondblclick = (java.lang.String) values[19];
        _onkeydown = (java.lang.String) values[20];
        _onkeypress = (java.lang.String) values[21];
        _onkeyup = (java.lang.String) values[22];
        _onmousedown = (java.lang.String) values[23];
        _onmousemove = (java.lang.String) values[24];
        _onmouseout = (java.lang.String) values[25];
        _onmouseover = (java.lang.String) values[26];
        _onmouseup = (java.lang.String) values[27];
        _dir = (java.lang.String) values[28];
        _lang = (java.lang.String) values[29];
        _title = (java.lang.String) values[30];
        _disabled = ((Boolean) values[31]).booleanValue();
        _disabledSet = ((Boolean) values[32]).booleanValue();
        _readonly = ((Boolean) values[33]).booleanValue();
        _readonlySet = ((Boolean) values[34]).booleanValue();
    }
}
