/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.converter;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.jsf.ConvertHandler;
import com.sun.facelets.tag.jsf.ConverterConfig;

public class ConvertDateTimeTagHandler extends ConvertHandler
{

    public ConvertDateTimeTagHandler(ConverterConfig config)
    {
        super(config);
    }
    
    public void setAttributes(FaceletContext ctx, Object obj)
    {
        super.setAttributes(ctx, obj);
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type)
    {
        MetaRuleset ruleSet = super.createMetaRuleset(type);
        
        ruleSet.addRule(_DateTimeConverterRule.Instance);
        
        //Add locale rule
        ruleSet.addRule(_LocaleRule.Instance);
        
        //Add timeZone rule
        ruleSet.addRule(_TimeZoneRule.Instance);
        
        return ruleSet;
    }
}
