/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.commons.validator;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.apache.myfaces.commons.validator.model.DateListProvider;


// Generated from class org.apache.myfaces.commons.validator.AbstractDateRestrictionValidator.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class DateRestrictionValidator extends org.apache.myfaces.commons.validator.AbstractDateRestrictionValidator
{

    static public final String VALIDATOR_ID = 
        "org.apache.myfaces.commons.validator.DateRestriction";

    public DateRestrictionValidator()
    {
    }


    // Property: invalidMonths
    private String[] _invalidMonths;
    
    public String[] getInvalidMonths()
    {
        if (_invalidMonths != null)
        {
            return _invalidMonths;
        }
        ValueExpression vb = getValueExpression("invalidMonths");
        if (vb != null)
        {
            return (String[]) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setInvalidMonths(String[] invalidMonths)
    {
        this._invalidMonths = invalidMonths;
    }

    // Property: invalidDaysOfWeek
    private String[] _invalidDaysOfWeek;
    
    public String[] getInvalidDaysOfWeek()
    {
        if (_invalidDaysOfWeek != null)
        {
            return _invalidDaysOfWeek;
        }
        ValueExpression vb = getValueExpression("invalidDaysOfWeek");
        if (vb != null)
        {
            return (String[]) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setInvalidDaysOfWeek(String[] invalidDaysOfWeek)
    {
        this._invalidDaysOfWeek = invalidDaysOfWeek;
    }

    // Property: invalidDays
    private DateListProvider _invalidDays;
    
    public DateListProvider getInvalidDays()
    {
        if (_invalidDays != null)
        {
            return _invalidDays;
        }
        ValueExpression vb = getValueExpression("invalidDays");
        if (vb != null)
        {
            return (DateListProvider) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setInvalidDays(DateListProvider invalidDays)
    {
        this._invalidDays = invalidDays;
    }


    public Object saveState(FacesContext facesContext)
    {
        Object[] values = new Object[4];
        values[0] = super.saveState(facesContext);
        values[1] = _invalidMonths;
        values[2] = _invalidDaysOfWeek;
        values[3] = _invalidDays;
        return values; 
    }

    public void restoreState(FacesContext facesContext, Object state)
    {
        Object[] values = (Object[])state;
        super.restoreState(facesContext,values[0]);
        _invalidMonths = (java.lang.String[]) values[1];
        _invalidDaysOfWeek = (java.lang.String[]) values[2];
        _invalidDays = (org.apache.myfaces.commons.validator.model.DateListProvider) values[3];
    }
}
