/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean;

import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.bean.ValueExpressionValueBinding;

class ValueBindingValueExpression
extends ValueExpression {
    private final ValueBinding _binding;
    private static final long serialVersionUID = 1L;

    public static ValueExpression getValueExpression(ValueBinding binding) {
        if (binding instanceof ValueExpressionValueBinding) {
            return ((ValueExpressionValueBinding)binding).getValueExpression();
        }
        if (binding instanceof StateHolder) {
            if (binding instanceof Serializable) {
                return new SerializableStateHolderValueBindingValueExpression(binding);
            }
            return new StateHolderValueBindingValueExpression(binding);
        }
        if (binding instanceof Serializable) {
            return new SerializableValueBindingValueExpression(binding);
        }
        return new ValueBindingValueExpression(binding);
    }

    private ValueBindingValueExpression(ValueBinding binding) {
        if (binding == null) {
            throw new NullPointerException();
        }
        this._binding = binding;
    }

    public ValueBinding getValueBinding() {
        return this._binding;
    }

    public Object getValue(ELContext elContext) {
        try {
            return this._binding.getValue(FacesContext.getCurrentInstance());
        }
        catch (EvaluationException ee) {
            throw new ELException(ee.getMessage(), ee.getCause());
        }
    }

    public void setValue(ELContext elContext, Object object) {
        try {
            this._binding.setValue(FacesContext.getCurrentInstance(), object);
        }
        catch (EvaluationException ee) {
            throw new ELException(ee.getMessage(), ee.getCause());
        }
    }

    public boolean isReadOnly(ELContext elContext) {
        try {
            return this._binding.isReadOnly(FacesContext.getCurrentInstance());
        }
        catch (EvaluationException ee) {
            throw new ELException(ee.getMessage(), ee.getCause());
        }
    }

    public Class<?> getType(ELContext elContext) {
        try {
            return this._binding.getType(FacesContext.getCurrentInstance());
        }
        catch (EvaluationException ee) {
            throw new ELException(ee.getMessage(), ee.getCause());
        }
    }

    public Class<?> getExpectedType() {
        return null;
    }

    public String getExpressionString() {
        return this._binding.getExpressionString();
    }

    public boolean isLiteralText() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueBindingValueExpression)) {
            return false;
        }
        ValueBindingValueExpression that = (ValueBindingValueExpression)((Object)o);
        return that._binding.equals(this._binding);
    }

    public int hashCode() {
        return this._binding.hashCode();
    }

    public String toString() {
        return super.toString() + ", binding=" + this._binding;
    }

    private static class SerializableStateHolderValueBindingValueExpression
    extends StateHolderValueBindingValueExpression
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SerializableStateHolderValueBindingValueExpression(ValueBinding binding) {
            super(binding);
        }
    }

    private static class StateHolderValueBindingValueExpression
    extends ValueBindingValueExpression
    implements StateHolder {
        private final StateHolder _stateHolder;
        private static final long serialVersionUID = 1L;

        public StateHolderValueBindingValueExpression(ValueBinding binding) {
            super(binding);
            this._stateHolder = (StateHolder)binding;
        }

        public Object saveState(FacesContext facesContext) {
            return this._stateHolder.saveState(facesContext);
        }

        public void restoreState(FacesContext facesContext, Object object) {
            this._stateHolder.restoreState(facesContext, object);
        }

        public boolean isTransient() {
            return this._stateHolder.isTransient();
        }

        public void setTransient(boolean b) {
            this._stateHolder.setTransient(b);
        }
    }

    private static class SerializableValueBindingValueExpression
    extends ValueBindingValueExpression
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SerializableValueBindingValueExpression(ValueBinding binding) {
            super(binding);
        }
    }
}

