/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.application;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.InternalView;
import org.apache.myfaces.trinidad.view.ViewDeclarationLanguageWrapper;
import org.apache.myfaces.trinidadinternal.application.InternalViewHandlingStrategy;

public class ViewDeclarationLanguageFactoryImpl
extends ViewDeclarationLanguageFactory {
    private final ViewDeclarationLanguageFactory _wrapped;
    private final InternalViewHandlingStrategy _internalViewStrategy;
    private Map<String, InternalView> _internalViews;
    private static final Object _NOT_FOUND = new Object();
    private static final String _VIEWID_MAPPING = "org.apache.myfaces.trinidadinternal.application.viewIdMapping";
    private final Map<String, Object> _internalViewCache = new ConcurrentHashMap<String, Object>();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ViewDeclarationLanguageFactoryImpl.class);

    public ViewDeclarationLanguageFactoryImpl(ViewDeclarationLanguageFactory delegate) {
        this._wrapped = delegate;
        this._loadInternalViews();
        InternalViewFinder finder = new InternalViewFinder(){

            @Override
            public InternalView getInternalView(FacesContext context, String viewId) {
                return ViewDeclarationLanguageFactoryImpl.this._getInternalView(context, viewId);
            }
        };
        this._internalViewStrategy = new InternalViewHandlingStrategy(finder);
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(String viewId) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this._getInternalView(context, viewId) != null) {
            return this._internalViewStrategy;
        }
        viewId = ViewDeclarationLanguageFactoryImpl._getPath(context, viewId);
        ViewDeclarationLanguage vdl = this.getWrapped().getViewDeclarationLanguage(viewId);
        if (vdl instanceof ChangeApplyingVDLWrapper) {
            return vdl;
        }
        return new ChangeApplyingVDLWrapper(this.getWrapped().getViewDeclarationLanguage(viewId));
    }

    public ViewDeclarationLanguageFactory getWrapped() {
        return this._wrapped;
    }

    private InternalView _getInternalView(FacesContext context, String viewId) {
        ExternalContext external;
        Object cached = this._internalViewCache.get(viewId);
        if (cached != null) {
            return cached == _NOT_FOUND ? null : (InternalView)cached;
        }
        InternalView internal = this._internalViews.get(viewId);
        if (internal == null && (external = context.getExternalContext()).getRequestPathInfo() == null) {
            String suffix = external.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            if (suffix == null) {
                suffix = ".jspx";
            }
            if (viewId.endsWith(suffix)) {
                String viewIdWithoutSuffix = viewId.substring(0, viewId.length() - suffix.length());
                internal = this._internalViews.get(viewIdWithoutSuffix);
            }
        }
        this._internalViewCache.put(viewId, internal == null ? _NOT_FOUND : internal);
        return internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadInternalViews() {
        this._internalViews = new HashMap<String, InternalView>();
        ArrayList<URL> list = new ArrayList<URL>();
        ClassLoader loader = ViewDeclarationLanguageFactoryImpl._getClassLoader();
        try {
            Enumeration<URL> en = loader.getResources("META-INF/org.apache.myfaces.trinidad.render.InternalView.properties");
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            en = loader.getResources("META-INF/org.apache.myfaces.trinidad.InternalView.properties");
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            Collections.reverse(list);
        }
        catch (IOException ioe) {
            _LOG.severe((Throwable)ioe);
        }
        for (URL url : list) {
            try {
                Properties properties = new Properties();
                _LOG.fine("Loading internal views from {0}", (Object)url);
                InputStream is = url.openStream();
                try {
                    properties.load(is);
                }
                finally {
                    is.close();
                }
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String name = (String)entry.getKey();
                    String className = (String)entry.getValue();
                    Class<?> clazz = loader.loadClass(className);
                    InternalView view = (InternalView)clazz.newInstance();
                    this._internalViews.put(name, view);
                }
            }
            catch (IllegalAccessException iae) {
                _LOG.severe("CANNOT_LOAD_URL", (Object)url);
                _LOG.severe((Throwable)iae);
            }
            catch (InstantiationException ie) {
                _LOG.severe("CANNOT_LOAD_URL", (Object)url);
                _LOG.severe((Throwable)ie);
            }
            catch (ClassNotFoundException cnfe) {
                _LOG.severe("CANNOT_LOAD_URL", (Object)url);
                _LOG.severe((Throwable)cnfe);
            }
            catch (IOException ioe) {
                _LOG.severe("CANNOT_LOAD_URL", (Object)url);
                _LOG.severe((Throwable)ioe);
            }
        }
    }

    private static ClassLoader _getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ViewDeclarationLanguageFactoryImpl.class.getClassLoader();
        }
        return loader;
    }

    private static String _getPath(FacesContext context, String uri) {
        RequestContext afc;
        UIViewRoot viewRoot = context.getViewRoot();
        boolean viewMatch = false;
        HashMap<String, String> viewIdMap = (HashMap<String, String>)context.getAttributes().get(_VIEWID_MAPPING);
        if (viewRoot != null && viewRoot.getViewId().equals(uri)) {
            String cachedPhysicalURI;
            viewMatch = true;
            if (viewIdMap != null && (cachedPhysicalURI = (String)viewIdMap.get(uri)) != null) {
                return cachedPhysicalURI;
            }
        }
        if ((afc = RequestContext.getCurrentInstance()) != null) {
            String physicalURI = afc.getPageResolver().getPhysicalURI(uri);
            if (viewMatch) {
                if (viewIdMap == null) {
                    viewIdMap = new HashMap<String, String>();
                    context.getAttributes().put(_VIEWID_MAPPING, viewIdMap);
                }
                viewIdMap.put(uri, physicalURI);
            }
            return physicalURI;
        }
        return uri;
    }

    private static class ChangeApplyingVDLWrapper
    extends ViewDeclarationLanguageWrapper {
        private final ViewDeclarationLanguage _wrapped;
        private Boolean _facelets = null;

        ChangeApplyingVDLWrapper(ViewDeclarationLanguage wrapped) {
            this._wrapped = wrapped;
        }

        public ViewDeclarationLanguage getWrapped() {
            return this._wrapped;
        }

        public void buildView(FacesContext facesContext, UIViewRoot uiViewRoot) throws IOException {
            super.buildView(facesContext, uiViewRoot);
            if (PhaseId.RENDER_RESPONSE.equals(FacesContext.getCurrentInstance().getCurrentPhaseId())) {
                ChangeManager cm = RequestContext.getCurrentInstance().getChangeManager();
                cm.applyComponentChangesForCurrentView(FacesContext.getCurrentInstance());
            }
        }

        public void renderView(FacesContext context, UIViewRoot view) throws IOException {
            if (!context.isPostback() && this._isFacelets()) {
                context.getExternalContext().getSession(true);
            }
            super.renderView(context, view);
        }

        private boolean _isFacelets() {
            if (this._facelets == null) {
                this._facelets = "java.faces.Facelets".equals(this.getId());
            }
            return this._facelets;
        }
    }

    static interface InternalViewFinder {
        public InternalView getInternalView(FacesContext var1, String var2);
    }
}

