/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.style.Styles;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HtmlRenderer;
import org.apache.myfaces.trinidadinternal.skin.SkinStyleProvider;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;
import org.apache.myfaces.trinidadinternal.style.StyleSheetNamingStrategy;

class StyleContextImpl
implements StyleContext {
    private RenderingContext _arc;
    private String _generatedFilesPath;
    private StyleProvider _styleProvider;
    private Styles _styles;
    private Boolean _isDisableStyleCompression;
    private Boolean _isRequestSecure;
    private StyleSheetNamingStrategy _namingStrategy;
    private static final String _SKIN_DIRTY_PARAM = "org.apache.myfaces.trinidad.skin.dirty";
    private static final String _NAMING_STRATEGY_PARAM = "org.apache.myfaces.trinidadinternal.STYLE_SHEET_NAMING_STRATEGY";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleContextImpl.class);

    public StyleContextImpl(RenderingContext arc, String generatedFilesPath) {
        this._arc = arc;
        this._generatedFilesPath = generatedFilesPath;
        assert (this._arc.getAccessibilityProfile() != null);
    }

    @Override
    public StyleProvider getStyleProvider() {
        if (this._styleProvider == null) {
            Skin skin = ((CoreRenderingContext)this._arc).getSkin();
            this._styleProvider = this._getDefaultStyleProvider(skin);
        }
        return this._styleProvider;
    }

    @Override
    public StyleProvider getStyleProvider(boolean recompute) {
        if (recompute) {
            this._styleProvider = null;
            this._isDisableStyleCompression = null;
            this.isDisableStyleCompression();
        }
        return this.getStyleProvider();
    }

    @Override
    public Styles getStyles() {
        if (this._styles == null) {
            this._styles = this.getStyleProvider().getStyles(this);
        }
        return this._styles;
    }

    @Override
    public LocaleContext getLocaleContext() {
        return this._arc.getLocaleContext();
    }

    @Override
    public String getGeneratedFilesPath() {
        return this._generatedFilesPath;
    }

    @Override
    public TrinidadAgent getAgent() {
        return ((CoreRenderingContext)this._arc).getTrinidadAgent();
    }

    @Override
    public boolean checkStylesModified() {
        FacesContext context = FacesContext.getCurrentInstance();
        String checkTimestamp = context.getExternalContext().getInitParameter("org.apache.myfaces.trinidad.CHECK_FILE_MODIFICATION");
        return "true".equals(checkTimestamp);
    }

    @Override
    public boolean isDirty() {
        FacesContext context;
        Object requestSkinDirty;
        if (this._arc.isDesignTime() && Boolean.TRUE.equals(requestSkinDirty = this._getRequestMapSkinDirty(context = FacesContext.getCurrentInstance()))) {
            this._arc.getSkin().setDirty(true);
            return true;
        }
        return this._arc.getSkin().isDirty();
    }

    @Override
    public boolean disableStandardsMode() {
        FacesContext fContext = FacesContext.getCurrentInstance();
        return HtmlRenderer.isStandardsModeDisabled(fContext);
    }

    @Override
    public AccessibilityProfile getAccessibilityProfile() {
        return this._arc.getAccessibilityProfile();
    }

    private StyleProvider _getDefaultStyleProvider(Skin skin) {
        String cachePath = this._generatedFilesPath + "/adf/styles/cache/";
        try {
            return SkinStyleProvider.getSkinStyleProvider(skin, cachePath);
        }
        catch (RuntimeException e) {
            _LOG.severe("CANNOT_GET_STYLESHEET_CACHE", (Throwable)e);
            return NullStyleProvider.getInstance();
        }
    }

    private Object _getRequestMapSkinDirty(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object requestedSkinDirty = requestMap.get(_SKIN_DIRTY_PARAM);
        return requestedSkinDirty;
    }

    @Override
    public boolean isPortletMode() {
        return "portlet".equals(this._arc.getOutputMode());
    }

    @Override
    public boolean isRequestSecure() {
        if (this._isRequestSecure == null) {
            String scheme = FacesContext.getCurrentInstance().getExternalContext().getRequestScheme();
            this._isRequestSecure = "https".equals(scheme);
        }
        return this._isRequestSecure;
    }

    @Override
    public boolean isDisableStyleCompression() {
        if (this._isDisableStyleCompression == null) {
            boolean disableContentCompressionBoolean;
            FacesContext context = FacesContext.getCurrentInstance();
            String disableContentCompression = context.getExternalContext().getInitParameter("org.apache.myfaces.trinidad.DISABLE_CONTENT_COMPRESSION");
            if (disableContentCompression != null) {
                disableContentCompressionBoolean = "true".equals(disableContentCompression);
            } else {
                boolean bl = disableContentCompressionBoolean = !context.isProjectStage(ProjectStage.Production);
            }
            if (disableContentCompressionBoolean) {
                this._isDisableStyleCompression = Boolean.TRUE;
                if (context.isProjectStage(ProjectStage.Production) && !this._arc.isDesignTime()) {
                    _LOG.warning("DISABLE_CONTENT_COMPRESSION_IN_PRODUCTION_STAGE");
                }
            }
            if ("portlet".equals(this._arc.getOutputMode())) {
                Skin skin = ((CoreRenderingContext)this._arc).getSkin();
                boolean isPortletSkin = "portlet".equals(skin.getRenderKitId());
                if (isPortletSkin) {
                    this._isDisableStyleCompression = Boolean.TRUE;
                } else if (!((CoreRenderingContext)this._arc).isRequestMapStyleSheetIdAndSkinEqual(context, skin)) {
                    this._isDisableStyleCompression = Boolean.TRUE;
                }
            }
        }
        if (this._isDisableStyleCompression == null) {
            this._isDisableStyleCompression = Boolean.FALSE;
        }
        return Boolean.TRUE.equals(this._isDisableStyleCompression);
    }

    @Override
    public StyleSheetNamingStrategy getNamingStrategy() {
        StyleSheetNamingStrategy namingStrategy = this._getCachedFileNamingStrategy();
        if (namingStrategy == null) {
            namingStrategy = this._getInitParamFileNamingStrategy();
            assert (namingStrategy != null);
            this._putCachedFileNamingStrategy(namingStrategy);
        }
        return namingStrategy;
    }

    private StyleSheetNamingStrategy _getCachedFileNamingStrategy() {
        if (this._namingStrategy != null) {
            return this._namingStrategy;
        }
        ConcurrentMap<String, Object> appMap = this._getConcurrentApplicationScopedMap();
        return (StyleSheetNamingStrategy)((Object)appMap.get(_NAMING_STRATEGY_PARAM));
    }

    private void _putCachedFileNamingStrategy(StyleSheetNamingStrategy namingStrategy) {
        ConcurrentMap<String, Object> appMap = this._getConcurrentApplicationScopedMap();
        appMap.put(_NAMING_STRATEGY_PARAM, (Object)namingStrategy);
        this._namingStrategy = namingStrategy;
    }

    private StyleSheetNamingStrategy _getInitParamFileNamingStrategy() {
        ExternalContext external = this._arc.getFacesContext().getExternalContext();
        String strategyParam = external.getInitParameter(_NAMING_STRATEGY_PARAM);
        if (strategyParam != null && (strategyParam = strategyParam.trim()).length() > 0) {
            try {
                return StyleSheetNamingStrategy.valueOfDisplayName(strategyParam);
            }
            catch (IllegalArgumentException e) {
                _LOG.warning("INVALID_ENUM_IN_CONFIG", new Object[]{strategyParam, _NAMING_STRATEGY_PARAM});
            }
        }
        return StyleSheetNamingStrategy.STABLE;
    }

    private ConcurrentMap<String, Object> _getConcurrentApplicationScopedMap() {
        return this._arc.getRequestContext().getApplicationScopedConcurrentMap();
    }

    private static class NullStyleProvider
    implements StyleProvider {
        private static StyleProvider _sInstance;

        private NullStyleProvider() {
        }

        public static StyleProvider getInstance() {
            if (_sInstance == null) {
                _sInstance = new NullStyleProvider();
            }
            return _sInstance;
        }

        @Override
        public String getContentStyleType(StyleContext context) {
            return null;
        }

        @Override
        public Map<String, String> getShortStyleClasses(StyleContext context) {
            return null;
        }

        @Override
        public List<String> getStyleSheetURIs(StyleContext context) {
            return null;
        }

        @Override
        public Styles getStyles(StyleContext context) {
            return null;
        }

        @Override
        public ConcurrentMap<String, Icon> getIcons(StyleContext context) {
            return null;
        }

        @Override
        public ConcurrentMap<Object, Object> getSkinProperties(StyleContext context) {
            return null;
        }
    }
}

