/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidad.share.io.NameResolver;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.share.io.CachingNameResolver;
import org.apache.myfaces.trinidadinternal.share.io.FileInputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.io.URLInputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContextImpl;
import org.apache.myfaces.trinidadinternal.skin.SkinStyleSheetParserUtils;
import org.apache.myfaces.trinidadinternal.skin.StyleSheetNameResolver;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;

class StyleSheetEntry {
    private static final String _NAME_RESOLVER_CLASS_NAME = NameResolver.class.getName();
    private static final String _STYLES_DIR_ERROR = "Could not locate the Trinidad styles directory.Please be sure that the Trinidad installable resources are installed.";
    private static final String _SERVICES_RESOLVER_IOEXCEPTION_MSG = "IOException when calling the META-INF/services NameResolver's getProvider method. Trying next nameResolver.";
    private static final String _SERVICES_RESOLVER_KEY = "org.apache.myfaces.trinidadinternal.skin.SERVICES_RESOLVER_KEY";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleSheetEntry.class);
    private String _name;
    private StyleSheetDocument _document;

    public static StyleSheetEntry createEntry(StyleContext context, String styleSheetName) {
        NameResolver resolver = StyleSheetEntry._getNameResolver(context, styleSheetName);
        if (resolver == null) {
            return null;
        }
        StyleSheetEntry skinStyleSheet = StyleSheetEntry._createSkinStyleSheet(resolver, styleSheetName);
        if (skinStyleSheet == null) {
            return null;
        }
        boolean checkStylesModified = context.checkStylesModified();
        return new CheckModifiedEntry(styleSheetName, skinStyleSheet.getDocument(), resolver, checkStylesModified);
    }

    StyleSheetEntry(String styleSheetName, StyleSheetDocument document) {
        this._name = styleSheetName;
        this._document = document;
    }

    StyleSheetEntry(String styleSheetName) {
        this(styleSheetName, null);
    }

    private StyleSheetEntry() {
    }

    public String getStyleSheetName() {
        return this._name;
    }

    public StyleSheetDocument getDocument() {
        return this._document;
    }

    public boolean checkModified(StyleContext context) {
        return false;
    }

    public static File resolveLocalFile(File localStylesDir, String name) {
        File file = new File(localStylesDir, name);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static URL resolveClassLoaderURL(String name) {
        if (name == null) {
            return null;
        }
        return ClassLoaderUtils.getResource((String)name);
    }

    public static URL resolveNonStaticURL(String name) {
        if (name == null) {
            return null;
        }
        FacesContext fContext = FacesContext.getCurrentInstance();
        if (fContext != null) {
            try {
                if (name.startsWith("http:") || name.startsWith("https:") || name.startsWith("file:") || name.startsWith("ftp:") || name.startsWith("jar:")) {
                    URL url = new URL(name);
                    if (url != null) {
                        return url;
                    }
                } else {
                    String rootName = StyleSheetEntry._getRootName(name);
                    URL url = fContext.getExternalContext().getResource(rootName);
                    if (url != null) {
                        return url;
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    void __setDocument(StyleSheetDocument document) {
        this._document = document;
    }

    private static StyleSheetEntry _createSkinStyleSheet(NameResolver resolver, String styleSheetName) {
        StyleSheetEntry skinStyleSheet = null;
        if (styleSheetName.endsWith(".css")) {
            skinStyleSheet = StyleSheetEntry._createSkinStyleSheetFromCSS(resolver, styleSheetName);
        } else {
            String message = _LOG.getMessage("INVALID_STYLESHEET_TYPE", new Object[]{styleSheetName});
            _LOG.severe(message);
        }
        return skinStyleSheet;
    }

    private static StyleSheetEntry _createSkinStyleSheetFromCSS(NameResolver resolver, String styleSheetName) {
        try {
            _LOG.info("LOADING_STYLESHEET", (Object)styleSheetName);
            ParseContextImpl parseContext = new ParseContextImpl();
            return SkinStyleSheetParserUtils.parseCSSSource(parseContext, resolver, styleSheetName, StyleSheetEntry.class);
        }
        catch (Exception e) {
            if (_LOG.isSevere()) {
                _LOG.severe("CANNOT_LOAD_STYLESHEET", (Object)styleSheetName);
            }
            _LOG.severe((Throwable)e);
            return null;
        }
    }

    private static NameResolver _getNameResolver(StyleContext context, String styleSheetName) {
        File localStylesDir = StyleSheetEntry._getStylesDir(context);
        if (localStylesDir == null) {
            _LOG.warning(_STYLES_DIR_ERROR);
            return null;
        }
        NameResolver resolver = null;
        try {
            resolver = StyleSheetEntry._getNameResolverForStyleSheetFile(context, localStylesDir, styleSheetName);
        }
        catch (IOException e) {
            if (_LOG.isWarning()) {
                _LOG.warning("CANNOT_LOAD_STYLESHEET", (Object)styleSheetName);
            }
            _LOG.warning(e.getMessage());
        }
        if (resolver == null) {
            return null;
        }
        return new CachingNameResolver(resolver, null, true);
    }

    private static NameResolver _getNameResolverForStyleSheetFile(StyleContext context, File localStylesDir, String filename) throws IOException {
        Object provider = null;
        File file = StyleSheetEntry.resolveLocalFile(localStylesDir, filename);
        if (file != null) {
            provider = new FileInputStreamProvider(file);
        }
        if (provider == null) {
            URL url = StyleSheetEntry.resolveNonStaticURL(filename);
            if (url != null) {
                provider = new URLInputStreamProvider(url);
            } else {
                url = StyleSheetEntry.resolveClassLoaderURL(filename);
                if (url != null) {
                    provider = new StaticURLInputStreamProvider(url);
                }
            }
        }
        if (provider != null) {
            return StyleSheetNameResolver.createResolver(context, localStylesDir, provider);
        }
        NameResolver servicesNameResolver = StyleSheetEntry._loadNameResolverFromServices(filename);
        if (servicesNameResolver != null) {
            if (_LOG.isFine()) {
                _LOG.fine("Using the InputStreamProvider from META-INF\\services");
            }
            return servicesNameResolver;
        }
        throw new FileNotFoundException(StyleSheetEntry._getFileNotFoundMessage(localStylesDir, filename));
    }

    private static String _getFileNotFoundMessage(File localStylesDir, String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Unable to locate the skin's style sheet \"");
        buffer.append(name);
        buffer.append("\" in ");
        if (localStylesDir != null) {
            buffer.append("local styles directory (");
            buffer.append(localStylesDir.getPath());
            buffer.append("), ");
        }
        buffer.append("or on the class path.\n");
        buffer.append("Please be sure that this style sheet is installed.");
        return buffer.toString();
    }

    private static File _getStylesDir(StyleContext context) {
        String contextPath = context.getGeneratedFilesPath();
        if (contextPath == null) {
            return null;
        }
        String stylesPath = contextPath + "/adf/styles";
        File stylesDir = new File(stylesPath);
        if (stylesDir.exists()) {
            return stylesDir;
        }
        return null;
    }

    private static String _getRootName(String name) {
        return name.startsWith("/") ? name : "/" + name;
    }

    private static NameResolver _loadNameResolverFromServices(String name) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map appMap = context.getExternalContext().getApplicationMap();
        NameResolver savedResolver = (NameResolver)appMap.get(_SERVICES_RESOLVER_KEY);
        if (savedResolver != null) {
            return savedResolver;
        }
        List resolvers = ClassLoaderUtils.getServices((String)_NAME_RESOLVER_CLASS_NAME);
        for (NameResolver customNameResolver : resolvers) {
            InputStreamProvider provider;
            block4: {
                provider = null;
                try {
                    provider = customNameResolver.getProvider(name);
                }
                catch (IOException e) {
                    if (!_LOG.isFine()) break block4;
                    _LOG.fine(_SERVICES_RESOLVER_IOEXCEPTION_MSG);
                }
            }
            if (provider == null) continue;
            appMap.put(_SERVICES_RESOLVER_KEY, customNameResolver);
            return customNameResolver;
        }
        return null;
    }

    private static class StaticURLInputStreamProvider
    extends URLInputStreamProvider {
        public StaticURLInputStreamProvider(URL url) {
            super(url);
        }

        @Override
        public boolean hasSourceChanged() {
            return false;
        }
    }

    private static class CheckModifiedEntry
    extends StyleSheetEntry {
        private InputStreamProvider _provider;
        private boolean _checkFileModifiedFlagSet;

        public CheckModifiedEntry(String styleSheetName, StyleSheetDocument document, NameResolver resolver, boolean checkFileModifiedFlagSet) {
            super(styleSheetName, document);
            this._provider = this._getInputStreamProvider(resolver);
            this._checkFileModifiedFlagSet = checkFileModifiedFlagSet;
        }

        @Override
        public boolean checkModified(StyleContext context) {
            if (context.isDirty() || this._checkFileModifiedFlagSet && this._provider != null && this._provider.hasSourceChanged()) {
                this._provider = null;
                this.__setDocument(null);
                String name = this.getStyleSheetName();
                NameResolver resolver = StyleSheetEntry._getNameResolver(context, name);
                if (resolver != null) {
                    StyleSheetEntry skinStyleSheet = StyleSheetEntry._createSkinStyleSheet(resolver, name);
                    if (skinStyleSheet != null) {
                        this._provider = this._getInputStreamProvider(resolver);
                        this.__setDocument(skinStyleSheet.getDocument());
                    }
                    return true;
                }
            }
            return false;
        }

        private InputStreamProvider _getInputStreamProvider(NameResolver resolver) {
            assert (resolver instanceof CachingNameResolver);
            try {
                return resolver.getProvider(this.getStyleSheetName());
            }
            catch (IOException e) {
                assert (false);
                return null;
            }
        }
    }
}

