/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyBase;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyList;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectManyRendererBase;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyListRenderer<T extends AbstractUISelectManyList>
extends SelectManyRendererBase<T> {
    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_SELECT_MANY_LIST;
    }

    @Override
    protected CssItem[] getComponentCss(FacesContext facesContext, T component) {
        List<SelectItem> items = SelectItemUtils.getItemList(facesContext, component);
        boolean disabled = !items.iterator().hasNext() || ((AbstractUISelectManyList)component).isDisabled() || ((AbstractUISelectManyBase)component).isReadonly();
        ArrayList<TobagoClass> cssItems = new ArrayList<TobagoClass>();
        if (disabled) {
            cssItems.add(TobagoClass.DISABLED);
        }
        return cssItems.toArray(new CssItem[0]);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUISelectManyList)component).getFieldId(facesContext);
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        String fieldId = ((AbstractUISelectManyList)component).getFieldId(facesContext);
        String selectFieldId = clientId + "::" + "selectField";
        String filterId = clientId + "::" + "filter";
        List<SelectItem> items = SelectItemUtils.getItemList(facesContext, component);
        boolean disabled = !items.iterator().hasNext() || ((AbstractUISelectManyList)component).isDisabled() || ((AbstractUISelectManyBase)component).isReadonly();
        String filter = ((AbstractUISelectManyList)component).getFilter();
        boolean expanded = ((AbstractUISelectManyList)component).isExpanded();
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        Integer tabIndex = ((AbstractUISelectManyList)component).getTabIndex();
        this.encodeHiddenSelect(facesContext, component, items, clientId, fieldId, disabled);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(expanded ? BootstrapClass.LIST_GROUP : BootstrapClass.DROPDOWN, expanded ? BootstrapClass.borderColor(ComponentUtils.getMaximumSeverity(component)) : null);
        this.encodeSelectField(facesContext, component, clientId, selectFieldId, filterId, filter, disabled, expanded, title, tabIndex);
        this.encodeOptions(facesContext, component, items, clientId, expanded, disabled);
        writer.endElement(HtmlElements.DIV);
    }

    @Override
    protected void writeAdditionalAttributes(FacesContext facesContext, TobagoResponseWriter writer, T input) throws IOException {
        super.writeAdditionalAttributes(facesContext, writer, input);
        writer.writeAttribute(CustomAttributes.FILTER, ((AbstractUISelectManyList)input).getFilter(), true);
    }

    private void encodeHiddenSelect(FacesContext facesContext, T component, List<SelectItem> items, String clientId, String fieldId, boolean disabled) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.SELECT);
        writer.writeIdAttribute(fieldId);
        writer.writeNameAttribute(clientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, component.isRequired());
        writer.writeClassAttribute(BootstrapClass.D_NONE);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        Object[] values = ((AbstractUISelectManyList)component).getSelectedValues();
        String[] submittedValues = this.getSubmittedValues((UIInput)component);
        this.renderSelectItems((UIInput)component, null, (Iterable<SelectItem>)items, values, submittedValues, writer, facesContext);
        writer.endElement(HtmlElements.SELECT);
    }

    private void encodeSelectField(FacesContext facesContext, T component, String clientId, String selectFieldId, String filterId, String filter, boolean disabled, boolean expanded, String title, Integer tabIndex) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = component.getMarkup() != null ? component.getMarkup() : Markup.NULL;
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(selectFieldId);
        writer.writeNameAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeClassAttribute(expanded ? BootstrapClass.FORM_CONTROL : BootstrapClass.FORM_SELECT, expanded && markup.contains(Markup.LARGE) ? BootstrapClass.FORM_CONTROL_LG : null, expanded && markup.contains(Markup.SMALL) ? BootstrapClass.FORM_CONTROL_SM : null, !expanded && markup.contains(Markup.LARGE) ? BootstrapClass.FORM_SELECT_LG : null, !expanded && markup.contains(Markup.SMALL) ? BootstrapClass.FORM_SELECT_SM : null, TobagoClass.SELECT__FIELD, expanded ? BootstrapClass.LIST_GROUP_ITEM : BootstrapClass.DROPDOWN_TOGGLE, expanded ? null : BootstrapClass.borderColor(ComponentUtils.getMaximumSeverity(component)), component.getCustomClass());
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute(Arias.EXPANDED, Boolean.FALSE.toString(), false);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.SEARCH);
        writer.writeIdAttribute(filterId);
        writer.writeClassAttribute(TobagoClass.FILTER, BootstrapClass.FORM_CONTROL);
        writer.writeAttribute(HtmlAttributes.AUTOCOMPLETE, "off", false);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, filter == null || filter.isEmpty());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, tabIndex);
        SelectManyListRenderer.renderFocus(clientId, ((AbstractUISelectManyList)component).isFocus(), ((AbstractUISelectManyList)component).isError(), facesContext, writer);
        writer.endElement(HtmlElements.INPUT);
        writer.endElement(HtmlElements.DIV);
    }

    private void encodeOptions(FacesContext facesContext, T component, List<SelectItem> items, String clientId, boolean expanded, boolean disabled) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = component.getMarkup() != null ? component.getMarkup() : Markup.NULL;
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(new CssItem[]{TobagoClass.OPTIONS, expanded ? BootstrapClass.LIST_GROUP_ITEM : TobagoClass.DROPDOWN__MENU});
        writer.writeNameAttribute(clientId);
        writer.startElement(HtmlElements.TABLE);
        writer.writeClassAttribute(BootstrapClass.TABLE, BootstrapClass.TABLE_HOVER, markup.contains(Markup.LARGE) ? TobagoClass.LARGE : null, markup.contains(Markup.SMALL) ? TobagoClass.SMALL : null, markup.contains(Markup.LARGE) ? null : BootstrapClass.TABLE_SM);
        writer.startElement(HtmlElements.TBODY);
        Object[] values = ((AbstractUISelectManyList)component).getSelectedValues();
        String[] submittedValues = this.getSubmittedValues((UIInput)component);
        for (SelectItem item : items) {
            Object itemValue = item.getValue();
            if (itemValue instanceof String && values != null && values.length > 0 && !(values[0] instanceof String)) {
                itemValue = ComponentUtils.getConvertedValue(facesContext, component, (String)itemValue);
            }
            String formattedValue = this.getFormattedValue(facesContext, component, itemValue);
            boolean contains = submittedValues == null ? ArrayUtils.contains(values, itemValue) : ArrayUtils.contains(submittedValues, formattedValue);
            writer.startElement(HtmlElements.TR);
            writer.writeAttribute(DataAttributes.VALUE, formattedValue, true);
            writer.writeClassAttribute(contains ? BootstrapClass.TABLE_PRIMARY : null, disabled || item.isDisabled() ? TobagoClass.DISABLED : null);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, -1);
            writer.startElement(HtmlElements.TD);
            writer.writeAttribute(HtmlAttributes.VALUE, formattedValue, true);
            writer.writeText(item.getLabel());
            writer.endElement(HtmlElements.TD);
            writer.endElement(HtmlElements.TR);
        }
        writer.endElement(HtmlElements.TBODY);
        writer.startElement(HtmlElements.TFOOT);
        writer.startElement(HtmlElements.TR);
        writer.writeClassAttribute(TobagoClass.NO__ENTRIES, BootstrapClass.D_NONE);
        writer.startElement(HtmlElements.TD);
        writer.writeText("---");
        writer.endElement(HtmlElements.TD);
        writer.endElement(HtmlElements.TR);
        writer.endElement(HtmlElements.TFOOT);
        writer.endElement(HtmlElements.TABLE);
        writer.endElement(HtmlElements.DIV);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }
}

