/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.validator;

import java.util.Arrays;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.servlet.http.Part;
import org.apache.myfaces.tobago.internal.component.AbstractUIFile;
import org.apache.myfaces.tobago.internal.util.ContentType;
import org.apache.myfaces.tobago.util.MessageUtils;

public class FileItemValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "org.apache.myfaces.tobago.FileItem";
    public static final String SIZE_LIMIT_MESSAGE_ID = "org.apache.myfaces.tobago.FileItemValidator.SIZE_LIMIT";
    public static final String CONTENT_TYPE_MESSAGE_ID = "org.apache.myfaces.tobago.FileItemValidator.CONTENT_TYPE";
    private Integer maxSize = null;
    private String[] contentType;
    private boolean transientValue;

    public void validate(FacesContext facesContext, UIComponent component, Object value) throws ValidatorException {
        if (value != null && component instanceof AbstractUIFile) {
            Part file = (Part)value;
            if (this.maxSize != null && file.getSize() > (long)this.maxSize.intValue()) {
                throw new ValidatorException(MessageUtils.getMessage(facesContext, FacesMessage.SEVERITY_ERROR, SIZE_LIMIT_MESSAGE_ID, this.maxSize, component.getId()));
            }
            if (file.getSize() > 0L && this.contentType != null && this.contentType.length > 0) {
                boolean found = false;
                for (String contentTypeStr : this.contentType) {
                    if (!ContentType.valueOf(contentTypeStr).match(ContentType.valueOf(file.getContentType()))) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    String message = this.contentType.length == 1 ? this.contentType[0] : Arrays.toString(this.contentType);
                    throw new ValidatorException(MessageUtils.getMessage(facesContext, FacesMessage.SEVERITY_ERROR, CONTENT_TYPE_MESSAGE_ID, message, component.getId()));
                }
            }
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize > 0) {
            this.maxSize = maxSize;
        }
    }

    public String[] getContentType() {
        return this.contentType;
    }

    public void setContentType(String[] contentType) {
        this.contentType = contentType;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maxSize, this.contentType};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maxSize = (Integer)values[0];
        this.contentType = (String[])values[1];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientValue = newTransientValue;
    }
}

