/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.storage;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.API})
public class ModelValidationEntry {
    private UIComponent component;
    private List<Class> groups = new ArrayList<Class>();
    private List<Object> validationTargets = new ArrayList<Object>();
    private boolean displayMessageInline = false;
    private String customMessage = "";
    private Object metaDataSourceObject;
    private String viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();

    public void addGroup(Class group) {
        if (!this.groups.contains(group)) {
            if (!(this.groups instanceof ArrayList)) {
                ArrayList<Class> newGroupList = new ArrayList<Class>();
                for (Class currentClass : this.groups) {
                    newGroupList.add(currentClass);
                }
                this.groups = newGroupList;
            }
            this.groups.add(group);
        }
    }

    public void removeGroup(Class group) {
        this.groups.remove(group);
    }

    public void addValidationTarget(Object target) {
        if (!this.validationTargets.contains(target)) {
            if (!(this.validationTargets instanceof ArrayList)) {
                ArrayList<Object> validationTargetList = new ArrayList<Object>();
                for (Object currentTarget : this.validationTargets) {
                    validationTargetList.add(currentTarget);
                }
                this.validationTargets = validationTargetList;
            }
            this.validationTargets.add(target);
        }
    }

    public UIComponent getComponent() {
        return this.component;
    }

    public void setComponent(UIComponent component) {
        this.component = component;
    }

    public Class[] getGroups() {
        return this.groups.toArray(new Class[this.groups.size()]);
    }

    public void setGroups(List<Class> groups) {
        this.groups = groups;
    }

    public List<Object> getValidationTargets() {
        return this.validationTargets;
    }

    public Object getMetaDataSourceObject() {
        return this.metaDataSourceObject;
    }

    public void setMetaDataSourceObject(Object metaDataSourceObject) {
        this.metaDataSourceObject = metaDataSourceObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelValidationEntry that = (ModelValidationEntry)o;
        if (this.component != null ? !this.component.equals(that.component) : that.component != null) {
            return false;
        }
        if (!((Object)this.groups).equals(that.groups)) {
            return false;
        }
        return ((Object)this.validationTargets).equals(that.validationTargets);
    }

    public boolean isDisplayMessageInline() {
        return this.displayMessageInline;
    }

    public void setDisplayMessageInline(boolean displayMessageInline) {
        this.displayMessageInline = displayMessageInline;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public void setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
    }

    public int hashCode() {
        int result = this.component != null ? this.component.hashCode() : 0;
        result = 31 * result + ((Object)this.groups).hashCode();
        result = 31 * result + ((Object)this.validationTargets).hashCode();
        return result;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }
}

