/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval.strategy;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.baseval.annotation.SkipValidationSupport;
import org.apache.myfaces.extensions.validator.crossval.annotation.DateIs;
import org.apache.myfaces.extensions.validator.crossval.annotation.MessageTarget;
import org.apache.myfaces.extensions.validator.crossval.strategy.AbstractCompareStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SkipValidationSupport
@UsageInformation(value={UsageCategory.INTERNAL})
public class DateIsStrategy
extends AbstractCompareStrategy<DateIs> {
    protected static final String TOO_EARLY = "early";
    protected static final String TOO_LATE = "late";
    protected static final String TOO_EARLY_SAME = "earlyNotSame";
    protected static final String TOO_LATE_SAME = "lateNotSame";
    protected static final String NOT_EQUAL_DATE_TIME = "not equal";
    protected static final String RESULT_KEY = "result";
    protected static final String COMPARED_VALUE_KEY = "target value";
    protected static final String REVERSE_COMPARED_VALUE_KEY = "reverse target value";

    @Override
    protected MessageTarget getMessageTarget(DateIs annotation) {
        return annotation.validationErrorMsgTarget();
    }

    @Override
    public boolean isViolation(Object object1, Object object2, DateIs annotation) {
        boolean violationFound = false;
        switch (annotation.type()) {
            case before: {
                boolean bl = violationFound = object1 != null && object2 != null && (!new Date(((Date)object1).getTime()).before((Date)object2) || object1.equals(object2));
                if (!violationFound) break;
                this.violationResultStorage.put(RESULT_KEY, TOO_LATE);
                break;
            }
            case after: {
                boolean bl = violationFound = object1 != null && object2 != null && (!new Date(((Date)object1).getTime()).after((Date)object2) || object1.equals(object2));
                if (!violationFound) break;
                this.violationResultStorage.put(RESULT_KEY, TOO_EARLY);
                break;
            }
            case same: {
                boolean bl = violationFound = object1 != null && !object1.equals(object2);
                if (!violationFound) break;
                this.violationResultStorage.put(RESULT_KEY, NOT_EQUAL_DATE_TIME);
                break;
            }
            case beforeOrSame: {
                boolean bl = violationFound = object1 != null && object2 != null && new Date(((Date)object1).getTime()).after((Date)object2);
                if (!violationFound) break;
                this.violationResultStorage.put(RESULT_KEY, TOO_LATE_SAME);
                break;
            }
            case afterOrSame: {
                boolean bl = violationFound = object1 != null && object2 != null && new Date(((Date)object1).getTime()).before((Date)object2);
                if (!violationFound) break;
                this.violationResultStorage.put(RESULT_KEY, TOO_EARLY_SAME);
                break;
            }
        }
        if (violationFound) {
            this.violationResultStorage.put(COMPARED_VALUE_KEY, object1);
            this.violationResultStorage.put(REVERSE_COMPARED_VALUE_KEY, object2);
        }
        return violationFound;
    }

    @Override
    public String[] getValidationTargets(DateIs annotation) {
        return annotation.valueOf();
    }

    @Override
    protected String getValidationErrorMsgKey(DateIs annotation, boolean isTargetComponent) {
        String result = (String)this.violationResultStorage.get(RESULT_KEY);
        if (!isTargetComponent) {
            result = this.reverseResult(result);
        }
        if (TOO_EARLY.equals(result)) {
            return this.getNotAfterErrorMsgKey(annotation);
        }
        if (TOO_EARLY_SAME.equals(result)) {
            return this.getNotAfterOrSameErrorMsgKey(annotation);
        }
        if (TOO_LATE.equals(result)) {
            return this.getNotBeforeErrorMsgKey(annotation);
        }
        if (TOO_LATE_SAME.equals(result)) {
            return this.getNotBeforeOrSameErrorMsgKey(annotation);
        }
        return this.getNotEqualErrorMsgKey(annotation);
    }

    private String reverseResult(String result) {
        if (TOO_EARLY.equals(result)) {
            return TOO_LATE;
        }
        if (TOO_EARLY_SAME.equals(result)) {
            return TOO_LATE_SAME;
        }
        if (TOO_LATE_SAME.equals(result)) {
            return TOO_EARLY_SAME;
        }
        if (TOO_LATE.equals(result)) {
            return TOO_EARLY;
        }
        return result;
    }

    @Override
    protected String getErrorMessageSummary(DateIs annotation, boolean isTargetComponent) {
        return this.getErrorMessage(this.getValidationErrorMsgKey(annotation, isTargetComponent), annotation, isTargetComponent);
    }

    @Override
    protected String getErrorMessageDetail(DateIs annotation, boolean isTargetComponent) {
        try {
            return this.getErrorMessage(this.getValidationErrorMsgKey(annotation, isTargetComponent) + "_detail", annotation, isTargetComponent);
        }
        catch (MissingResourceException e) {
            this.logger.log(Level.WARNING, "couldn't find key " + this.getValidationErrorMsgKey(annotation, isTargetComponent) + "_detail", e);
            return null;
        }
    }

    @Override
    protected String getReverseErrorMessageSummary(DateIs annotation) {
        return this.getErrorMessage(this.getValidationErrorMsgKey(annotation, false), annotation, false);
    }

    @Override
    protected String getReverseErrorMessageDetail(DateIs annotation) {
        try {
            return this.getErrorMessage(this.getValidationErrorMsgKey(annotation, false) + "_detail", annotation, false);
        }
        catch (MissingResourceException e) {
            this.logger.log(Level.WARNING, "couldn't find key " + this.getValidationErrorMsgKey(annotation) + "_detail", e);
            return null;
        }
    }

    protected String getErrorMessage(String key, DateIs annotation, boolean isTargetComponent) {
        String message = this.resolveMessage(key);
        DateFormat dateFormat = this.getDateFormat(annotation.errorMessageDateStyle(), annotation.errorMessageDatePattern());
        String result = isTargetComponent ? message.replace("{0}", dateFormat.format((Date)this.violationResultStorage.get(COMPARED_VALUE_KEY))) : message.replace("{0}", dateFormat.format((Date)this.violationResultStorage.get(REVERSE_COMPARED_VALUE_KEY)));
        return result;
    }

    private DateFormat getDateFormat(int dateStyle, String datePattern) {
        if (datePattern == null || datePattern.length() == 0) {
            return DateFormat.getDateInstance(dateStyle, FacesContext.getCurrentInstance().getViewRoot().getLocale());
        }
        return new SimpleDateFormat(datePattern, FacesContext.getCurrentInstance().getViewRoot().getLocale());
    }

    private String getNotAfterErrorMsgKey(DateIs annotation) {
        if (annotation.validationErrorMsgKey().equals("")) {
            return annotation.notAfterErrorMsgKey();
        }
        return annotation.validationErrorMsgKey();
    }

    private String getNotAfterOrSameErrorMsgKey(DateIs annotation) {
        if (annotation.validationErrorMsgKey().equals("")) {
            return annotation.notAfterOrSameErrorMsgKey();
        }
        return annotation.validationErrorMsgKey();
    }

    private String getNotBeforeErrorMsgKey(DateIs annotation) {
        if (annotation.validationErrorMsgKey().equals("")) {
            return annotation.notBeforeErrorMsgKey();
        }
        return annotation.validationErrorMsgKey();
    }

    private String getNotBeforeOrSameErrorMsgKey(DateIs annotation) {
        if (annotation.validationErrorMsgKey().equals("")) {
            return annotation.notBeforeOrSameErrorMsgKey();
        }
        return annotation.validationErrorMsgKey();
    }

    private String getNotEqualErrorMsgKey(DateIs annotation) {
        if (annotation.validationErrorMsgKey().equals("")) {
            return annotation.notEqualErrorMsgKey();
        }
        return annotation.validationErrorMsgKey();
    }
}

