/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.push.cdi.WebsocketChannel;
import org.apache.myfaces.push.cdi.WebsocketChannelMetadata;

@ApplicationScoped
public class WebsocketApplicationBean {
    private Map<String, List<WebsocketChannel>> channelTokenListMap = new HashMap<String, List<WebsocketChannel>>(2);

    public void registerWebsocketSession(String token, WebsocketChannelMetadata metadata) {
        if ("application".equals(metadata.getScope())) {
            this.channelTokenListMap.putIfAbsent(metadata.getChannel(), new ArrayList(1));
            this.channelTokenListMap.get(metadata.getChannel()).add(new WebsocketChannel(token, metadata));
        }
    }

    public boolean isChannelAvailable(String channel) {
        return this.channelTokenListMap.containsKey(channel);
    }

    public List<String> getChannelTokensFor(String channel) {
        List<WebsocketChannel> list = this.channelTokenListMap.get(channel);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> value = new ArrayList<String>(list.size());
            for (WebsocketChannel md : list) {
                value.add(md.getChannelToken());
            }
            return value;
        }
        return Collections.emptyList();
    }

    public <S extends Serializable> List<String> getChannelTokensFor(String channel, S user) {
        List<WebsocketChannel> list = this.channelTokenListMap.get(channel);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> value = new ArrayList<String>(list.size());
            for (WebsocketChannel md : list) {
                if (!user.equals(md.getUser())) continue;
                value.add(md.getChannelToken());
            }
            return value;
        }
        return null;
    }
}

