/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class InjectionProviderFactory {
    protected static final String FACTORY_DEFAULT = "org.apache.myfaces.spi.impl.DefaultInjectionProviderFactory";
    private static final String FACTORY_KEY = InjectionProviderFactory.class.getName();

    public static InjectionProviderFactory getInjectionProviderFactory() {
        return InjectionProviderFactory.getInjectionProviderFactory(FacesContext.getCurrentInstance().getExternalContext());
    }

    public static InjectionProviderFactory getInjectionProviderFactory(ExternalContext ctx) {
        Map<String, Object> applicationMap = ctx.getApplicationMap();
        InjectionProviderFactory instance = (InjectionProviderFactory)applicationMap.get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        InjectionProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                lpf = (InjectionProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, InjectionProviderFactory.class, InjectionProviderFactory.FACTORY_DEFAULT);
                    }
                });
            } else {
                lpf = (InjectionProviderFactory)SpiUtils.build(ctx, InjectionProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException(pae);
        }
        if (lpf != null) {
            applicationMap.put(FACTORY_KEY, lpf);
        }
        return lpf;
    }

    public static void setInjectionProviderFactory(InjectionProviderFactory instance) {
        FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract InjectionProvider getInjectionProvider(ExternalContext var1);

    public abstract void release();
}

