/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.FacesException;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.ExternalContext;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.faces.view.facelets.FaceletsResourceResolver;
import org.apache.myfaces.cdi.util.BeanProvider;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.annotation.CdiAnnotationProviderExtension;
import org.apache.myfaces.config.annotation._ClassByteCodeAnnotationFilter;
import org.apache.myfaces.config.annotation._PackageInfo;
import org.apache.myfaces.config.util.GAEUtils;
import org.apache.myfaces.config.util.JarUtils;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.StringUtils;
import org.apache.myfaces.spi.AnnotationProvider;
import org.apache.myfaces.spi.AnnotationProviderFactory;
import org.apache.myfaces.util.ContainerUtils;
import org.apache.myfaces.view.facelets.util.Classpath;

public class DefaultAnnotationProvider
extends AnnotationProvider {
    private static final Logger log = Logger.getLogger(DefaultAnnotationProvider.class.getName());
    public static final String SCAN_PACKAGES = "org.apache.myfaces.annotation.SCAN_PACKAGES";
    private static final String WEB_CLASSES_PREFIX = "/WEB-INF/classes/";
    private static final String WEB_LIB_PREFIX = "/WEB-INF/lib/";
    private static final String META_INF_PREFIX = "META-INF/";
    private static final String FACES_CONFIG_SUFFIX = ".faces-config.xml";
    private static final String FACES_CONFIG_IMPLICIT = "META-INF/faces-config.xml";
    private final _ClassByteCodeAnnotationFilter _filter = new _ClassByteCodeAnnotationFilter();
    private static Set<String> byteCodeAnnotationsNames;
    private static final Set<Class<? extends Annotation>> JSF_ANNOTATION_CLASSES;

    @Override
    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(ExternalContext ctx) {
        String useCdiForAnnotationScanning = ctx.getInitParameter("org.apache.myfaces.annotation.USE_CDI_FOR_ANNOTATION_SCANNING");
        if (useCdiForAnnotationScanning != null && "true".equalsIgnoreCase(useCdiForAnnotationScanning.trim())) {
            BeanManager beanManager = CDIUtils.getBeanManager(ctx);
            CdiAnnotationProviderExtension extension = BeanProvider.getContextualReference(beanManager, CdiAnnotationProviderExtension.class, false, new Annotation[0]);
            return extension.getMap();
        }
        HashMap map = new HashMap();
        Collection<Class<?>> classes = null;
        try {
            classes = this.getAnnotatedWebInfClasses(ctx);
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        for (Class<?> clazz : classes) {
            this.processClass(map, clazz);
        }
        String jarAnnotationFilesToScanParam = MyfacesConfig.getCurrentInstance(ctx).getGaeJsfAnnotationsJarFiles();
        String string = jarAnnotationFilesToScanParam = jarAnnotationFilesToScanParam != null ? jarAnnotationFilesToScanParam.trim() : null;
        if (ContainerUtils.isRunningOnGoogleAppEngine(ctx) && jarAnnotationFilesToScanParam != null && jarAnnotationFilesToScanParam.length() > 0) {
            classes = this.getGAEAnnotatedMetaInfClasses(ctx, jarAnnotationFilesToScanParam);
        } else {
            try {
                AnnotationProvider provider = AnnotationProviderFactory.getAnnotationProviderFactory(ctx).getAnnotationProvider(ctx);
                classes = this.getAnnotatedMetaInfClasses(ctx, provider.getBaseUrls(ctx));
            }
            catch (IOException e) {
                throw new FacesException(e);
            }
        }
        for (Class<?> clazz : classes) {
            this.processClass(map, clazz);
        }
        return map;
    }

    @Override
    public Set<URL> getBaseUrls() throws IOException {
        HashSet<URL> urlSet = new HashSet<URL>();
        Enumeration<URL> resources = this.getClassLoader().getResources(FACES_CONFIG_IMPLICIT);
        while (resources.hasMoreElements()) {
            urlSet.add(resources.nextElement());
        }
        URL[] urls = Classpath.search(this.getClassLoader(), META_INF_PREFIX, FACES_CONFIG_SUFFIX);
        for (int i = 0; i < urls.length; ++i) {
            urlSet.add(urls[i]);
        }
        return urlSet;
    }

    @Override
    public Set<URL> getBaseUrls(ExternalContext context) throws IOException {
        String jarFilesToScanParam = MyfacesConfig.getCurrentInstance(context).getGaeJsfJarFiles();
        String string = jarFilesToScanParam = jarFilesToScanParam != null ? jarFilesToScanParam.trim() : null;
        if (ContainerUtils.isRunningOnGoogleAppEngine(context) && jarFilesToScanParam != null && jarFilesToScanParam.length() > 0) {
            HashSet<URL> urlSet = new HashSet<URL>();
            Enumeration<URL> resources = this.getClassLoader().getResources(FACES_CONFIG_IMPLICIT);
            while (resources.hasMoreElements()) {
                urlSet.add(resources.nextElement());
            }
            Collection<URL> urlsGAE = GAEUtils.searchInWebLib(context, this.getClassLoader(), jarFilesToScanParam, META_INF_PREFIX, FACES_CONFIG_SUFFIX);
            if (urlsGAE != null) {
                urlSet.addAll(urlsGAE);
            }
            return urlSet;
        }
        return this.getBaseUrls();
    }

    protected Collection<Class<?>> getAnnotatedMetaInfClasses(ExternalContext ctx, Set<URL> urls) {
        if (urls != null && !urls.isEmpty()) {
            ArrayList list = new ArrayList();
            for (URL url : urls) {
                try {
                    JarFile jarFile = this.getJarFile(url);
                    if (jarFile == null) continue;
                    this.archiveClasses(jarFile, list);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "cannot scan jar file for annotations:" + url, e);
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    protected Collection<Class<?>> getGAEAnnotatedMetaInfClasses(ExternalContext context, String filter) {
        if (!filter.equals("none")) {
            String[] jarFilesToScan = StringUtils.trim(StringUtils.splitLongString(filter, ','));
            Set<String> paths = context.getResourcePaths(WEB_LIB_PREFIX);
            if (paths != null) {
                ArrayList list = new ArrayList();
                for (String pathObject : paths) {
                    String path = pathObject;
                    if (!path.endsWith(".jar") || !GAEUtils.wildcardMatch(path, jarFilesToScan, WEB_LIB_PREFIX)) continue;
                    try {
                        URL jarUrl = new URL("jar:" + context.getResource(path).toExternalForm() + "!/");
                        JarFile jarFile = JarUtils.getJarFile(jarUrl);
                        if (jarFile == null) continue;
                        this.archiveClasses(jarFile, list);
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "IOException when reading jar file for annotations using filter: " + filter, e);
                    }
                }
                return list;
            }
        }
        return Collections.emptyList();
    }

    protected Collection<Class<?>> getAnnotatedMyfacesImplClasses(ExternalContext ctx, URL url) {
        return Collections.emptyList();
    }

    protected Collection<Class<?>> getAnnotatedWebInfClasses(ExternalContext ctx) throws IOException {
        String scanPackages = ctx.getInitParameter(SCAN_PACKAGES);
        if (scanPackages != null) {
            try {
                return this.packageClasses(ctx, scanPackages);
            }
            catch (ClassNotFoundException e) {
                throw new FacesException(e);
            }
            catch (IOException e) {
                throw new FacesException(e);
            }
        }
        return this.webClasses(ctx);
    }

    private List<Class<?>> packageClasses(ExternalContext externalContext, String scanPackages) throws ClassNotFoundException, IOException {
        String[] scanPackageTokens;
        ArrayList list = new ArrayList();
        for (String scanPackageToken : scanPackageTokens = scanPackages.split(",")) {
            if (scanPackageToken.toLowerCase().endsWith(".jar")) {
                URL jarResource = externalContext.getResource(WEB_LIB_PREFIX + scanPackageToken);
                String jarURLString = "jar:" + jarResource.toString() + "!/";
                URL url = new URL(jarURLString);
                JarFile jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                this.archiveClasses(jarFile, list);
                continue;
            }
            ArrayList<Class> list2 = new ArrayList<Class>();
            _PackageInfo.getInstance().getClasses(list2, scanPackageToken);
            for (Class c : list2) {
                list.add(c);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<?>> archiveClasses(JarFile jar, List<Class<?>> list) {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || (name = entry.getName()).startsWith(META_INF_PREFIX) || !name.endsWith(".class")) continue;
            DataInputStream in = null;
            boolean couldContainAnnotation = false;
            try {
                in = new DataInputStream(jar.getInputStream(entry));
                couldContainAnnotation = this._filter.couldContainAnnotationsOnClassDef(in, byteCodeAnnotationsNames);
            }
            catch (IOException e) {
                couldContainAnnotation = true;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("IOException when filtering class " + name + " for annotations");
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (!couldContainAnnotation) continue;
            name = name.substring(0, name.length() - 6);
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(name.replace('/', '.'));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clazz == null) continue;
            list.add(clazz);
        }
        return list;
    }

    private List<Class<?>> webClasses(ExternalContext externalContext) {
        ArrayList list = new ArrayList();
        this.webClasses(externalContext, WEB_CLASSES_PREFIX, list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void webClasses(ExternalContext externalContext, String prefix, List<Class<?>> list) {
        ClassLoader loader = this.getClassLoader();
        Set<String> paths = externalContext.getResourcePaths(prefix);
        if (paths == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("webClasses(" + prefix + ") - Received " + paths.size() + " paths to check");
        }
        String path = null;
        if (paths.isEmpty()) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("AnnotationConfigurator does not found classes for annotations in " + prefix + " . This could happen because maven jetty plugin is used (goal jetty:run). Try configure " + SCAN_PACKAGES + " init parameter or use jetty:run-exploded instead.");
            }
        } else {
            for (String pathObject : paths) {
                path = pathObject;
                if (path.endsWith("/")) {
                    this.webClasses(externalContext, path, list);
                    continue;
                }
                if (!path.endsWith(".class")) continue;
                DataInputStream in = null;
                boolean couldContainAnnotation = false;
                try {
                    in = new DataInputStream(externalContext.getResourceAsStream(path));
                    couldContainAnnotation = this._filter.couldContainAnnotationsOnClassDef(in, byteCodeAnnotationsNames);
                }
                catch (IOException e) {
                    couldContainAnnotation = true;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("IOException when filtering class " + path + " for annotations");
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (!couldContainAnnotation) continue;
                path = path.substring(WEB_CLASSES_PREFIX.length());
                path = path.substring(0, path.length() - 6);
                path = path.replace('/', '.');
                Class<?> clazz = null;
                try {
                    clazz = loader.loadClass(path);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (clazz == null) continue;
                list.add(clazz);
            }
        }
    }

    private JarFile getJarFile(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        conn.setDefaultUseCaches(false);
        JarFile jarFile = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarFile() : DefaultAnnotationProvider._getAlternativeJarFile(url);
        return jarFile;
    }

    private static JarFile _getAlternativeJarFile(URL url) throws IOException {
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf(33);
        }
        if (separatorIndex != -1) {
            String jarFileUrl = urlFile.substring(0, separatorIndex);
            if (jarFileUrl.startsWith("file:")) {
                jarFileUrl = jarFileUrl.substring("file:".length());
            }
            return new JarFile(jarFileUrl);
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }

    private void processClass(Map<Class<? extends Annotation>, Set<Class<?>>> map, Class<?> clazz) {
        Annotation[] annotations;
        for (Annotation anno : annotations = clazz.getAnnotations()) {
            Class<? extends Annotation> annotationClass = anno.annotationType();
            if (!JSF_ANNOTATION_CLASSES.contains(annotationClass)) continue;
            Set<Class<?>> set = map.get(annotationClass);
            if (set == null) {
                set = new HashSet();
                set.add(clazz);
                map.put(annotationClass, set);
                continue;
            }
            set.add(clazz);
        }
    }

    static {
        HashSet<Object> bcan = new HashSet<Object>(10, 1.0f);
        bcan.add("Ljavax/faces/component/FacesComponent;");
        bcan.add("Ljavax/faces/component/behavior/FacesBehavior;");
        bcan.add("Ljavax/faces/convert/FacesConverter;");
        bcan.add("Ljavax/faces/validator/FacesValidator;");
        bcan.add("Ljavax/faces/render/FacesRenderer;");
        bcan.add("Ljavax/faces/bean/ManagedBean;");
        bcan.add("Ljavax/faces/event/NamedEvent;");
        bcan.add("Ljavax/faces/render/FacesBehaviorRenderer;");
        bcan.add("Ljavax/faces/view/facelets/FaceletsResourceResolver;");
        byteCodeAnnotationsNames = Collections.unmodifiableSet(bcan);
        bcan = new HashSet(10, 1.0f);
        bcan.add(FacesComponent.class);
        bcan.add(FacesBehavior.class);
        bcan.add(FacesConverter.class);
        bcan.add(FacesValidator.class);
        bcan.add(FacesRenderer.class);
        bcan.add(ManagedBean.class);
        bcan.add(NamedEvent.class);
        bcan.add(FacesBehaviorRenderer.class);
        bcan.add(FaceletsResourceResolver.class);
        JSF_ANNOTATION_CLASSES = Collections.unmodifiableSet(bcan);
    }
}

