/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsExcelTextExtractor
extends AbstractTextExtractor {
    private static final Logger logger = LoggerFactory.getLogger((Class)MsExcelTextExtractor.class);

    public MsExcelTextExtractor() {
        super(new String[]{"application/vnd.ms-excel", "application/msexcel", "application/excel"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(stream);
            StringReader stringReader = new StringReader(new ExcelExtractor(fs).getText());
            return stringReader;
        }
        catch (RuntimeException e) {
            logger.warn("Failed to extract Excel text content", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
        }
    }

    static {
        POIFSFileSystem.class.getName();
    }
}

