/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.storage.jcr.privatedata;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.vysper.storage.jcr.JcrStorage;
import org.apache.vysper.storage.jcr.JcrStorageException;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.extension.xep0049_privatedata.PrivateDataPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPrivateDataPersistenceManager
implements PrivateDataPersistenceManager {
    final Logger logger = LoggerFactory.getLogger(JcrPrivateDataPersistenceManager.class);
    protected JcrStorage jcrStorage;

    public JcrPrivateDataPersistenceManager(JcrStorage jcrStorage) {
        this.jcrStorage = jcrStorage;
    }

    public boolean isAvailable() {
        Session session = null;
        try {
            session = this.jcrStorage.getRepositorySession();
            return session != null;
        }
        catch (JcrStorageException e) {
            return false;
        }
    }

    public String getPrivateData(Entity entity, String key) {
        Node entityNode = this.getEntityNodeSave(entity, false);
        if (entityNode == null) {
            return null;
        }
        try {
            return entityNode.getProperty(key).getString();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public boolean setPrivateData(Entity entity, String key, String xml) {
        Node entityNode = this.getEntityNodeSave(entity, true);
        try {
            entityNode.setProperty(key, xml);
            entityNode.save();
            this.logger.info("JCR node created: " + entityNode);
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private Node getEntityNodeSave(Entity entity, boolean createIfMissing) {
        Node entityNode;
        try {
            entityNode = this.jcrStorage.getEntityNode(entity.getBareJID(), "jabber:iq:private", createIfMissing);
        }
        catch (JcrStorageException e) {
            return null;
        }
        if (entityNode == null) {
            return null;
        }
        return entityNode;
    }
}

