/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.handler;

import java.util.ArrayList;
import java.util.List;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.AbstractInviteDecline;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.Decline;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.Invite;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.Password;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.X;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUCHandlerHelper {
    public static boolean verifyNamespace(Stanza stanza) {
        XMLElement xElement = stanza.getFirstInnerElement();
        if (xElement != null && xElement.getName().equals("x") && xElement.getNamespaceURI().equals("http://jabber.org/protocol/muc")) {
            return true;
        }
        if (xElement != null && xElement.getNamespaceURI().length() == 0) {
            return true;
        }
        return xElement == null;
    }

    public static Stanza createErrorStanza(String stanzaName, String namespaceUri, Entity from, Entity to, String id, String type, String errorName, List<XMLElement> innerElements) {
        StanzaBuilder builder = new StanzaBuilder(stanzaName, namespaceUri);
        builder.addAttribute("from", from.getFullQualifiedName());
        builder.addAttribute("to", to.getFullQualifiedName());
        if (id != null) {
            builder.addAttribute("id", id);
        }
        builder.addAttribute("type", "error");
        if (innerElements != null) {
            for (XMLElement innerElement : innerElements) {
                builder.addPreparedElement(innerElement);
            }
        }
        ((StanzaBuilder)builder.startInnerElement("error", "jabber:client")).addAttribute("type", type);
        ((StanzaBuilder)builder.startInnerElement(errorName, "urn:ietf:params:xml:ns:xmpp-stanzas")).endInnerElement();
        builder.endInnerElement();
        return (Stanza)builder.build();
    }

    public static Stanza createErrorReply(Stanza originalStanza, StanzaErrorType type, StanzaErrorCondition error) {
        StanzaBuilder builder = new StanzaBuilder(originalStanza.getName(), originalStanza.getNamespaceURI());
        builder.addAttribute("from", originalStanza.getTo().getFullQualifiedName());
        builder.addAttribute("to", originalStanza.getFrom().getFullQualifiedName());
        builder.addAttribute("id", originalStanza.getAttributeValue("id"));
        builder.addAttribute("type", "error");
        for (XMLElement inner : originalStanza.getInnerElements()) {
            builder.addPreparedElement(inner);
        }
        ((StanzaBuilder)builder.startInnerElement("error", "jabber:client")).addAttribute("type", type.value());
        ((StanzaBuilder)builder.startInnerElement(error.value(), "urn:ietf:params:xml:ns:xmpp-stanzas")).endInnerElement();
        builder.endInnerElement();
        return (Stanza)builder.build();
    }

    public static Stanza createInviteMessageStanza(Stanza original, String password) throws EntityFormatException {
        X orginalX = X.fromStanza(original);
        Invite invite = orginalX.getInvite();
        if (invite == null || invite.getTo() == null) {
            throw new IllegalArgumentException("Invalid invite element, must exist and contain to attribute");
        }
        Invite newInvite = new Invite(original.getFrom(), null, invite.getReason());
        return MUCHandlerHelper.createInviteDeclineMessageStanza(original, invite.getTo(), password, newInvite);
    }

    public static Stanza createDeclineMessageStanza(Stanza original) throws EntityFormatException {
        X orginalX = X.fromStanza(original);
        Decline decline = orginalX.getDecline();
        if (decline == null || decline.getTo() == null) {
            throw new IllegalArgumentException("Invalid decline element, must exist and contain to attribute");
        }
        Decline newDecline = new Decline(original.getFrom(), null, decline.getReason());
        return MUCHandlerHelper.createInviteDeclineMessageStanza(original, decline.getTo(), null, newDecline);
    }

    public static Stanza createInviteDeclineMessageStanza(Stanza original, Entity to, String password, AbstractInviteDecline invdec) throws EntityFormatException {
        StanzaBuilder builder = StanzaBuilder.createMessageStanza((Entity)original.getTo(), (Entity)to, null, null);
        ArrayList<XMLElement> inner = new ArrayList<XMLElement>();
        inner.add(invdec);
        if (password != null) {
            inner.add(new Password(password));
        }
        X newX = new X("http://jabber.org/protocol/muc#user", inner);
        builder.addPreparedElement((XMLElement)newX);
        return (Stanza)builder.build();
    }
}

