/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import org.apache.poi.hwpf.model.Ffn;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;

public class FontTable {
    private short _stringCount;
    private short _extraDataSz;
    private int lcbSttbfffn;
    private int fcSttbfffn;
    private Ffn[] _fontNames = null;

    public FontTable(byte[] buf, int offset, int lcbSttbfffn) {
        this.lcbSttbfffn = lcbSttbfffn;
        this.fcSttbfffn = offset;
        this._stringCount = LittleEndian.getShort((byte[])buf, (int)offset);
        this._extraDataSz = LittleEndian.getShort((byte[])buf, (int)(offset += 2));
        offset += 2;
        this._fontNames = new Ffn[this._stringCount];
        for (int i = 0; i < this._stringCount; ++i) {
            this._fontNames[i] = new Ffn(buf, offset);
            offset += this._fontNames[i].getSize();
        }
    }

    public short getStringCount() {
        return this._stringCount;
    }

    public short getExtraDataSz() {
        return this._extraDataSz;
    }

    public Ffn[] getFontNames() {
        return this._fontNames;
    }

    public int getSize() {
        return this.lcbSttbfffn;
    }

    public String getMainFont(int chpFtc) {
        if (chpFtc >= this._stringCount) {
            System.out.println("Mismatch in chpFtc with stringCount");
            return null;
        }
        return this._fontNames[chpFtc].getMainFontName();
    }

    public String getAltFont(int chpFtc) {
        if (chpFtc >= this._stringCount) {
            System.out.println("Mismatch in chpFtc with stringCount");
            return null;
        }
        return this._fontNames[chpFtc].getAltFontName();
    }

    public void setStringCount(short stringCount) {
        this._stringCount = stringCount;
    }

    public void writeTo(HWPFFileSystem sys) throws IOException {
        HWPFOutputStream tableStream = sys.getStream("1Table");
        byte[] buf = new byte[2];
        LittleEndian.putShort((byte[])buf, (short)this._stringCount);
        tableStream.write(buf);
        LittleEndian.putShort((byte[])buf, (short)this._extraDataSz);
        tableStream.write(buf);
        for (int i = 0; i < this._fontNames.length; ++i) {
            tableStream.write(this._fontNames[i].toByteArray());
        }
    }

    public boolean equals(Object o) {
        boolean retVal = true;
        if (((FontTable)o).getStringCount() == this._stringCount) {
            if (((FontTable)o).getExtraDataSz() == this._extraDataSz) {
                Ffn[] fontNamesNew = ((FontTable)o).getFontNames();
                for (int i = 0; i < this._stringCount; ++i) {
                    if (this._fontNames[i].equals(fontNamesNew[i])) continue;
                    retVal = false;
                }
            } else {
                retVal = false;
            }
        } else {
            retVal = false;
        }
        return retVal;
    }
}

