/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.apache.sshd.cli.CliSupport;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.BuiltinIdentities;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.security.SecurityUtils;

public class SshKeyScanMain
implements Channel,
Callable<Void>,
ServerKeyVerifier,
SessionListener,
SimplifiedLog {
    public static final List<String> DEFAULT_KEY_TYPES = Collections.unmodifiableList(Arrays.asList("RSA", "ECDSA"));
    public static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    public static final Level DEFAULT_LEVEL = Level.INFO;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private SshClient client;
    private int port;
    private long timeout;
    private List<String> keyTypes;
    private InputStream input;
    private Level level;
    private final Map<String, String> currentHostFingerprints = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public void setInputStream(InputStream input) {
        this.input = input;
    }

    public List<String> getKeyTypes() {
        return this.keyTypes;
    }

    public void setKeyTypes(List<String> keyTypes) {
        this.keyTypes = keyTypes;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Level getLogLevel() {
        return this.level;
    }

    public void setLogLevel(Level level) {
        this.level = level;
    }

    public void log(Level level, Object message, Throwable t) {
        if (this.isEnabledLevel(level)) {
            PrintStream ps = System.out;
            if (t != null || Level.SEVERE.equals(level) || Level.WARNING.equals(level)) {
                ps = System.err;
            }
            ps.append('\t').println(message);
            if (t != null) {
                ps.append("\t\t").append(t.getClass().getSimpleName()).append(": ").println(t.getMessage());
            }
        }
    }

    public boolean isEnabledLevel(Level level) {
        return SimplifiedLog.isLoggable((Level)level, (Level)this.getLogLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        ValidateUtils.checkTrue((boolean)this.isOpen(), (String)"Scanner is closed");
        List<String> typeNames = this.getKeyTypes();
        Map<String, List<KeyPair>> pairsMap = this.createKeyPairs(typeNames);
        TreeMap<String, List<NamedFactory<Signature>>> sigFactories = new TreeMap<String, List<NamedFactory<Signature>>>(String.CASE_INSENSITIVE_ORDER);
        NavigableSet sigTypes = GenericUtils.asSortedSet(sigFactories.comparator(), pairsMap.keySet());
        for (String kt : sigTypes) {
            List<NamedFactory<Signature>> factories = this.resolveSignatureFactories(kt);
            if (GenericUtils.isEmpty(factories)) {
                if (this.isEnabledLevel(Level.FINEST)) {
                    this.log(Level.FINEST, "Skip empty signature factories for " + kt);
                }
                pairsMap.remove(kt);
                continue;
            }
            sigFactories.put(kt, factories);
        }
        ValidateUtils.checkTrue((!MapEntryUtils.isEmpty(pairsMap) ? 1 : 0) != 0, (String)"No client key pairs");
        ValidateUtils.checkTrue((!MapEntryUtils.isEmpty(sigFactories) ? 1 : 0) != 0, (String)"No signature factories");
        Exception err = null;
        try {
            ValidateUtils.checkTrue((this.client == null ? 1 : 0) != 0, (String)"Client still active");
            this.client = SshClient.setUpDefaultClient();
            this.client.setServerKeyVerifier((ServerKeyVerifier)this);
            try (BufferedReader rdr = new BufferedReader(new InputStreamReader(this.getInputStream(), StandardCharsets.UTF_8));){
                this.client.setUserInteraction(new UserInteraction(){

                    public boolean isInteractionAllowed(ClientSession session) {
                        return true;
                    }

                    public String[] interactive(ClientSession session, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
                        return null;
                    }

                    public String getUpdatedPassword(ClientSession session, String prompt, String lang) {
                        return null;
                    }

                    public void serverVersionInfo(ClientSession session, List<String> lines) {
                        if (SshKeyScanMain.this.isEnabledLevel(Level.FINE) && GenericUtils.isNotEmpty(lines)) {
                            for (String l : lines) {
                                SshKeyScanMain.this.log(Level.FINE, "Server Info: " + l);
                            }
                        }
                    }

                    public void welcome(ClientSession session, String banner, String lang) {
                        if (SshKeyScanMain.this.isEnabledLevel(Level.FINE) && GenericUtils.isNotEmpty((CharSequence)banner)) {
                            String[] lines;
                            for (String l : lines = GenericUtils.split((String)banner, (char)'\n')) {
                                SshKeyScanMain.this.log(Level.FINE, "Welcome[" + lang + "]: " + l);
                            }
                        }
                    }
                });
                this.client.start();
                String line = rdr.readLine();
                while (line != null) {
                    Object[] hosts = GenericUtils.split((String)(line = GenericUtils.replaceWhitespaceAndTrim((String)line)), (char)',');
                    if (!GenericUtils.isEmpty((Object[])hosts)) {
                        for (Object h : hosts) {
                            if (!this.isOpen()) {
                                throw new InterruptedIOException("Closed while preparing to contact host=" + (String)h);
                            }
                            try {
                                this.resolveServerKeys(this.client, (String)h, pairsMap, sigFactories);
                            }
                            catch (Exception e) {
                                if (e instanceof InterruptedIOException) {
                                    throw e;
                                }
                                if (this.isEnabledLevel(Level.FINE)) {
                                    this.log(Level.FINE, "Failed to retrieve keys from " + (String)h, e);
                                }
                                err = (Exception)ExceptionUtils.accumulateException((Throwable)err, (Throwable)e);
                            }
                            finally {
                                this.currentHostFingerprints.clear();
                            }
                        }
                    }
                    line = rdr.readLine();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                this.close();
            }
            catch (IOException e) {
                err = (Exception)ExceptionUtils.accumulateException(err, (Throwable)e);
            }
            throw throwable;
        }
        try {
            this.close();
        }
        catch (IOException e) {
            err = (Exception)ExceptionUtils.accumulateException((Throwable)err, (Throwable)e);
        }
        if (err != null) {
            throw err;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveServerKeys(SshClient client, String host, Map<String, List<KeyPair>> pairsMap, Map<String, List<NamedFactory<Signature>>> sigFactories) throws IOException {
        for (Map.Entry<String, List<KeyPair>> pe : pairsMap.entrySet()) {
            String kt = pe.getKey();
            if (!this.isOpen()) {
                throw new InterruptedIOException("Closed while attempting to retrieve key type=" + kt + " from " + host);
            }
            List current = client.getSignatureFactories();
            try {
                List<NamedFactory<Signature>> forced = sigFactories.get(kt);
                client.setSignatureFactories(forced);
                this.resolveServerKeys(client, host, kt, pe.getValue());
            }
            catch (Exception e) {
                if (this.isEnabledLevel(Level.FINE)) {
                    this.log(Level.FINE, "Failed to resolve key=" + kt + " for " + host);
                }
                if (!(e instanceof ConnectException)) continue;
                return;
            }
            finally {
                client.setSignatureFactories(current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveServerKeys(SshClient client, String host, String kt, List<KeyPair> ids) throws Exception {
        block17: {
            long waitTime;
            ConnectFuture future;
            int connectPort = this.getPort();
            if (this.isEnabledLevel(Level.FINE)) {
                this.log(Level.FINE, "Connecting to " + host + ":" + connectPort + " to retrieve key type=" + kt);
            }
            if (!(future = client.connect(UUID.randomUUID().toString(), host, connectPort)).await(waitTime = this.getTimeout())) {
                throw new ConnectException("Failed to connect to " + host + ":" + connectPort + " within " + waitTime + " msec. to retrieve key type=" + kt);
            }
            try (ClientSession session = (ClientSession)future.getSession();){
                IoSession ioSession = session.getIoSession();
                SocketAddress remoteAddress = ioSession.getRemoteAddress();
                String remoteLocation = SshKeyScanMain.toString(remoteAddress);
                if (this.isEnabledLevel(Level.FINE)) {
                    this.log(Level.FINE, "Connected to " + remoteLocation + " to retrieve key type=" + kt);
                }
                try {
                    session.addSessionListener((SessionListener)this);
                    if (this.isEnabledLevel(Level.FINER)) {
                        this.log(Level.FINER, "Authenticating with key type=" + kt + " to " + remoteLocation);
                    }
                    GenericUtils.forEach(ids, arg_0 -> ((ClientSession)session).addPublicKeyIdentity(arg_0));
                    try {
                        session.auth().verify(waitTime);
                        this.log(Level.WARNING, "Unexpected authentication success using key type=" + kt + " with " + remoteLocation);
                    }
                    catch (Exception e) {
                        block18: {
                            try {
                                if (!this.isEnabledLevel(Level.FINER)) break block18;
                                this.log(Level.FINER, "Failed to authenticate using key type=" + kt + " with " + remoteLocation);
                            }
                            catch (Throwable throwable) {
                                GenericUtils.forEach(ids, arg_0 -> ((ClientSession)session).removePublicKeyIdentity(arg_0));
                                throw throwable;
                            }
                        }
                        GenericUtils.forEach(ids, arg_0 -> ((ClientSession)session).removePublicKeyIdentity(arg_0));
                        break block17;
                    }
                    GenericUtils.forEach(ids, arg_0 -> ((ClientSession)session).removePublicKeyIdentity(arg_0));
                }
                finally {
                    session.removeSessionListener((SessionListener)this);
                }
            }
        }
    }

    public void sessionCreated(Session session) {
        this.logSessionEvent(session, "Created");
    }

    public void sessionEvent(Session session, SessionListener.Event event) {
        this.logSessionEvent(session, event);
        if (this.isEnabledLevel(Level.FINEST) && SessionListener.Event.KexCompleted.equals((Object)event)) {
            IoSession ioSession = session.getIoSession();
            SocketAddress remoteAddress = ioSession.getRemoteAddress();
            String remoteLocation = SshKeyScanMain.toString(remoteAddress);
            for (KexProposalOption paramType : KexProposalOption.VALUES) {
                String paramValue = session.getNegotiatedKexParameter(paramType);
                this.log(Level.FINEST, remoteLocation + "[" + paramType.getDescription() + "]: " + paramValue);
            }
        }
    }

    public void sessionException(Session session, Throwable t) {
        this.logSessionEvent(session, t);
    }

    public void sessionClosed(Session session) {
        this.logSessionEvent(session, "Closed");
    }

    public void sessionNegotiationStart(Session session, Map<KexProposalOption, String> clientProposal, Map<KexProposalOption, String> serverProposal) {
        this.logSessionEvent(session, "sessionNegotiationStart");
        this.logNegotiationProposal("c2s", clientProposal);
        this.logNegotiationProposal("s2c", serverProposal);
    }

    protected void logNegotiationProposal(String type, Map<KexProposalOption, String> proposal) {
        if (!this.isEnabledLevel(Level.FINEST)) {
            return;
        }
        proposal.forEach((option, value) -> this.log(Level.FINEST, option.getDescription() + "[" + type + "]: " + value));
    }

    public void sessionNegotiationEnd(Session session, Map<KexProposalOption, String> clientProposal, Map<KexProposalOption, String> serverProposal, Map<KexProposalOption, String> negotiatedOptions, Throwable reason) {
        if (reason == null) {
            this.logSessionEvent(session, "sessionNegotiationStart");
        } else {
            this.logSessionEvent(session, reason);
        }
    }

    protected void logSessionEvent(Session session, Object event) {
        if (this.isEnabledLevel(Level.FINEST)) {
            IoSession ioSession = session.getIoSession();
            SocketAddress remoteAddress = ioSession.getRemoteAddress();
            this.log(Level.FINEST, "Session " + SshKeyScanMain.toString(remoteAddress) + " event: " + event);
        }
    }

    public boolean verifyServerKey(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        String remoteLocation = SshKeyScanMain.toString(remoteAddress);
        String extra = KeyUtils.getFingerPrint((PublicKey)serverKey);
        try {
            String current;
            String keyType = KeyUtils.getKeyType((Key)serverKey);
            String string = current = GenericUtils.isEmpty((CharSequence)keyType) ? null : this.currentHostFingerprints.get(keyType);
            if (Objects.equals(current, extra)) {
                if (this.isEnabledLevel(Level.FINER)) {
                    this.log(Level.FINER, "verifyServerKey(" + remoteLocation + ")[" + keyType + "] skip existing key: " + extra);
                }
            } else {
                if (this.isEnabledLevel(Level.FINE)) {
                    this.log(Level.FINE, "verifyServerKey(" + remoteLocation + ")[" + keyType + "] found new key: " + extra);
                }
                this.writeServerKey(remoteLocation, keyType, serverKey);
                if (!GenericUtils.isEmpty((CharSequence)keyType)) {
                    this.currentHostFingerprints.put(keyType, extra);
                }
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Failed to output the public key " + extra + " from " + remoteLocation, e);
        }
        return true;
    }

    protected void writeServerKey(String remoteLocation, String keyType, PublicKey serverKey) throws Exception {
        StringBuilder sb = new StringBuilder(256).append(remoteLocation).append(' ');
        PublicKeyEntry.appendPublicKeyEntry((Appendable)sb, (PublicKey)serverKey);
        this.log(Level.INFO, sb);
    }

    private static String toString(SocketAddress addr) {
        if (addr == null) {
            return null;
        }
        if (addr instanceof InetSocketAddress) {
            return ((InetSocketAddress)addr).getHostString();
        }
        if (addr instanceof SshdSocketAddress) {
            return ((SshdSocketAddress)addr).getHostName();
        }
        return addr.toString();
    }

    protected List<NamedFactory<Signature>> resolveSignatureFactories(String keyType) throws GeneralSecurityException {
        if (this.isEnabledLevel(Level.FINE)) {
            this.log(Level.FINE, "Resolve signature factories for " + keyType);
        }
        if ("RSA".equalsIgnoreCase(keyType)) {
            return Collections.singletonList(BuiltinSignatures.rsa);
        }
        if ("DSA".equalsIgnoreCase(keyType)) {
            return Collections.singletonList(BuiltinSignatures.dsa);
        }
        if ("ECDSA".equalsIgnoreCase(keyType)) {
            ArrayList<NamedFactory<Signature>> factories = new ArrayList<NamedFactory<Signature>>(ECCurves.NAMES.size());
            for (String n : ECCurves.NAMES) {
                if (this.isEnabledLevel(Level.FINER)) {
                    this.log(Level.FINER, "Resolve signature factory for curve=" + n);
                }
                NamedFactory f = (NamedFactory)ValidateUtils.checkNotNull((Object)BuiltinSignatures.fromString((String)n), (String)"Unknown curve signature: %s", (Object)n);
                factories.add((NamedFactory<Signature>)f);
            }
            return factories;
        }
        if ("ED25519".equalsIgnoreCase(keyType)) {
            return Collections.singletonList(BuiltinSignatures.ed25519);
        }
        throw new NoSuchAlgorithmException("Unknown key type: " + keyType);
    }

    protected Map<String, List<KeyPair>> createKeyPairs(Collection<String> typeNames) throws GeneralSecurityException {
        if (GenericUtils.isEmpty(typeNames)) {
            return Collections.emptyMap();
        }
        TreeMap<String, List<KeyPair>> pairsMap = new TreeMap<String, List<KeyPair>>(String.CASE_INSENSITIVE_ORDER);
        for (String kt : typeNames) {
            if ("*".equalsIgnoreCase(kt) || "all".equalsIgnoreCase(kt)) {
                ValidateUtils.checkTrue((typeNames.size() == 1 ? 1 : 0) != 0, (String)"Wildcard key type must be the only one specified: %s", typeNames);
                return this.createKeyPairs(BuiltinIdentities.NAMES);
            }
            if (pairsMap.containsKey(kt)) {
                this.log(Level.WARNING, "Key type " + kt + " re-specified");
                continue;
            }
            List<KeyPair> kps = this.createKeyPairs(kt);
            if (GenericUtils.isEmpty(kps)) {
                this.log(Level.WARNING, "No key-pairs generated for key type " + kt);
                continue;
            }
            pairsMap.put(kt, kps);
        }
        return pairsMap;
    }

    protected List<KeyPair> createKeyPairs(String keyType) throws GeneralSecurityException {
        if (this.isEnabledLevel(Level.FINE)) {
            this.log(Level.FINE, "Generate key pairs for " + keyType);
        }
        if ("RSA".equalsIgnoreCase(keyType)) {
            return Collections.singletonList(KeyUtils.generateKeyPair((String)"ssh-rsa", (int)1024));
        }
        if ("DSA".equalsIgnoreCase(keyType)) {
            return Collections.singletonList(KeyUtils.generateKeyPair((String)"ssh-dss", (int)512));
        }
        if ("ECDSA".equalsIgnoreCase(keyType)) {
            ArrayList<KeyPair> kps = new ArrayList<KeyPair>(ECCurves.NAMES.size());
            for (ECCurves curve : ECCurves.VALUES) {
                String curveName = curve.getName();
                if (this.isEnabledLevel(Level.FINER)) {
                    this.log(Level.FINER, "Generate key pair for curve=" + curveName);
                }
                kps.add(KeyUtils.generateKeyPair((String)curve.getKeyType(), (int)curve.getKeySize()));
            }
            return kps;
        }
        if ("ED25519".equalsIgnoreCase(keyType)) {
            if (!SecurityUtils.isEDDSACurveSupported()) {
                throw new NoSuchAlgorithmException("EDDSA curves not supported: " + keyType);
            }
            KeyPairGenerator g = SecurityUtils.getKeyPairGenerator((String)"EdDSA");
            return Collections.singletonList(g.generateKeyPair());
        }
        throw new InvalidKeySpecException("Unknown key type: " + keyType);
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.open.getAndSet(false)) {
            return;
        }
        IOException err = null;
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                err = (IOException)ExceptionUtils.accumulateException(err, (Throwable)e);
            }
            finally {
                this.input = null;
            }
        }
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                err = (IOException)ExceptionUtils.accumulateException((Throwable)err, (Throwable)e);
            }
            finally {
                try {
                    this.client.stop();
                }
                finally {
                    this.client = null;
                }
            }
        }
        if (err != null) {
            throw err;
        }
    }

    public static List<String> parseCommandLineArguments(SshKeyScanMain scanner, String ... args) throws IOException {
        int numArgs = GenericUtils.length((Object[])args);
        for (int index = 0; index < numArgs; ++index) {
            String optName = args[index];
            if ("-f".equals(optName)) {
                ValidateUtils.checkTrue((++index < numArgs ? 1 : 0) != 0, (String)"Missing %s option argument", (Object)optName);
                ValidateUtils.checkTrue((scanner.getInputStream() == null ? 1 : 0) != 0, (String)"%s option re-specified", (Object)optName);
                String filePath = args[index];
                if ("-".equals(filePath)) {
                    scanner.setInputStream((InputStream)new NoCloseInputStream(System.in));
                    continue;
                }
                scanner.setInputStream(new FileInputStream(filePath));
                continue;
            }
            if ("-t".equals(optName)) {
                ValidateUtils.checkTrue((++index < numArgs ? 1 : 0) != 0, (String)"Missing %s option argument", (Object)optName);
                ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty(scanner.getKeyTypes()), (String)"%s option re-specified", (Object)optName);
                String typeList = args[index];
                Object[] types = GenericUtils.split((String)typeList, (char)',');
                ValidateUtils.checkTrue((GenericUtils.length((Object[])types) > 0 ? 1 : 0) != 0, (String)"No types specified for %s", (Object)optName);
                scanner.setKeyTypes(Arrays.asList(types));
                continue;
            }
            if ("-p".equals(optName)) {
                ValidateUtils.checkTrue((++index < numArgs ? 1 : 0) != 0, (String)"Missing %s option argument", (Object)optName);
                ValidateUtils.checkTrue((scanner.getPort() <= 0 ? 1 : 0) != 0, (String)"%s option re-specified", (Object)optName);
                String portValue = args[index];
                int port = Integer.parseInt(portValue);
                ValidateUtils.checkTrue((port > 0 && port <= 65535 ? 1 : 0) != 0, (String)"Bad port: %s", (Object)portValue);
                scanner.setPort(port);
                continue;
            }
            if ("-T".equals(optName)) {
                ValidateUtils.checkTrue((++index < numArgs ? 1 : 0) != 0, (String)"Missing %s option argument", (Object)optName);
                ValidateUtils.checkTrue((scanner.getTimeout() <= 0L ? 1 : 0) != 0, (String)"%s option re-specified", (Object)optName);
                String timeoutValue = args[index];
                long timeout = Long.parseLong(timeoutValue);
                ValidateUtils.checkTrue((timeout > 0L ? 1 : 0) != 0, (String)"Bad timeout: %s", (Object)timeoutValue);
                scanner.setTimeout(timeout);
                continue;
            }
            if ("-v".equals(optName)) {
                ValidateUtils.checkTrue((scanner.getLogLevel() == null ? 1 : 0) != 0, (String)"%s option re-specified", (Object)optName);
                scanner.setLogLevel(Level.FINEST);
                continue;
            }
            if ("-io".equals(optName)) {
                String provider;
                BuiltinIoServiceFactoryFactories factory;
                if (index + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + optName);
                    break;
                }
                if ((factory = CliSupport.resolveBuiltinIoServiceFactory(System.err, optName, provider = args[++index])) == null) break;
                System.setProperty(IoServiceFactory.class.getName(), factory.getFactoryClassName());
                continue;
            }
            ValidateUtils.checkTrue((optName.charAt(0) != '-' ? 1 : 0) != 0, (String)"Unknown option: %s", (Object)optName);
            int remaining = numArgs - index;
            if (remaining == 1) {
                return Collections.singletonList(optName);
            }
            ArrayList<String> hosts = new ArrayList<String>(remaining);
            while (index < numArgs) {
                hosts.add(args[index]);
                ++index;
            }
            return hosts;
        }
        return Collections.emptyList();
    }

    public static <S extends SshKeyScanMain> S setInputStream(S scanner, Collection<String> hosts) throws IOException {
        if (GenericUtils.isEmpty(hosts)) {
            Objects.requireNonNull(scanner.getInputStream(), "No hosts or file specified");
        } else {
            ValidateUtils.checkTrue((scanner.getInputStream() == null ? 1 : 0) != 0, (String)"Both hosts and file specified");
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(hosts.size() * 32);){
                try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);){
                    for (String h : hosts) {
                        ((Writer)w).append(h).append(IoUtils.EOL);
                    }
                }
                byte[] data = baos.toByteArray();
                scanner.setInputStream(new ByteArrayInputStream(data));
            }
        }
        return scanner;
    }

    public static <S extends SshKeyScanMain> S initializeScanner(S scanner, Collection<String> hosts) throws IOException {
        SshKeyScanMain.setInputStream(scanner, hosts);
        if (scanner.getPort() <= 0) {
            scanner.setPort(22);
        }
        if (scanner.getTimeout() <= 0L) {
            scanner.setTimeout(DEFAULT_TIMEOUT);
        }
        if (GenericUtils.isEmpty(scanner.getKeyTypes())) {
            scanner.setKeyTypes(DEFAULT_KEY_TYPES);
        }
        if (scanner.getLogLevel() == null) {
            scanner.setLogLevel(DEFAULT_LEVEL);
        }
        return scanner;
    }

    public static void main(String[] args) throws Exception {
        try (SshKeyScanMain scanner = new SshKeyScanMain();){
            List<String> hosts = SshKeyScanMain.parseCommandLineArguments(scanner, args);
            SshKeyScanMain.initializeScanner(scanner, hosts);
            scanner.call();
        }
    }
}

