/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.spring.integration;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.simple.SimpleClientConfigurator;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.auth.MutableBasicCredentials;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderManager;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.loader.pem.PEMResourceParserUtils;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.spring.integration.SpringIoResource;
import org.apache.sshd.sftp.spring.integration.SpringSftpSession;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SharedSessionCapable;

public class ApacheSshdSftpSessionFactory
extends AbstractLoggingBean
implements SessionFactory<SftpClient.DirEntry>,
SharedSessionCapable,
MutableBasicCredentials,
FilePasswordProviderManager,
SimpleClientConfigurator,
InitializingBean,
DisposableBean {
    private final boolean sharedSession;
    private final AtomicReference<ClientSession> sharedSessionHolder = new AtomicReference();
    private volatile String hostValue;
    private volatile int portValue = 22;
    private volatile String userValue;
    private volatile String passwordValue;
    private volatile KeyPair privateKeyPair;
    private volatile Resource privateKey;
    private volatile String privateKeyPassphrase;
    private volatile FilePasswordProvider passwordProvider;
    private volatile Properties sessionConfig;
    private volatile long connTimeout = Long.MAX_VALUE;
    private volatile long authTimeout = Long.MAX_VALUE;
    private volatile SftpVersionSelector versionSelector = SftpVersionSelector.CURRENT;
    private SshClient sshClient;

    public ApacheSshdSftpSessionFactory() {
        this(false);
    }

    public ApacheSshdSftpSessionFactory(boolean sharedSession) {
        this.sharedSession = sharedSession;
    }

    public String getHost() {
        return this.hostValue;
    }

    public void setHost(String host) {
        this.hostValue = ValidateUtils.checkNotNullAndNotEmpty((String)host, (String)"No host name provided");
    }

    public int getPort() {
        return this.portValue;
    }

    public void setPort(int port) {
        ValidateUtils.checkTrue((port > 0 ? 1 : 0) != 0, (String)"Non-positive port value specified: %d", (long)port);
        this.portValue = port;
    }

    public String getUsername() {
        return this.userValue;
    }

    public void setUsername(String user) {
        this.userValue = ValidateUtils.checkNotNullAndNotEmpty((String)user, (String)"No user specified: %s", (Object)user);
    }

    public String getPassword() {
        return this.passwordValue;
    }

    public void setPassword(String password) {
        this.passwordValue = password;
    }

    public Resource getPrivateKeyLocation() {
        return this.privateKey;
    }

    public void setPrivateKeyLocation(Resource privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    public FilePasswordProvider getFilePasswordProvider() {
        return this.passwordProvider;
    }

    public void setFilePasswordProvider(FilePasswordProvider provider) {
        this.passwordProvider = provider;
    }

    public KeyPair getPrivateKeyPair() {
        return this.privateKeyPair;
    }

    public void setPrivateKeyPair(KeyPair privateKeyPair) {
        this.privateKeyPair = privateKeyPair;
    }

    public long getConnectTimeout() {
        return this.connTimeout;
    }

    public void setConnectTimeout(long timeout) {
        this.connTimeout = timeout;
    }

    public long getAuthenticationTimeout() {
        return this.authTimeout;
    }

    public void setAuthenticationTimeout(long timeout) {
        this.authTimeout = timeout;
    }

    public Properties getSessionConfig() {
        return this.sessionConfig;
    }

    public void setSessionConfig(Properties sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public SshClient getSshClient() {
        return this.sshClient;
    }

    public void setSshClient(SshClient sshClient) {
        this.sshClient = sshClient;
    }

    public boolean isSharedSession() {
        return this.sharedSession;
    }

    public SftpVersionSelector getSftpVersionSelector() {
        return this.versionSelector;
    }

    public void setSftpVersion(String version) {
        if ("CURRENT".equalsIgnoreCase(version)) {
            this.setSftpVersionSelector((SftpVersionSelector)SftpVersionSelector.CURRENT);
        } else if ("MAXIMUM".equalsIgnoreCase(version)) {
            this.setSftpVersionSelector((SftpVersionSelector)SftpVersionSelector.MAXIMUM);
        } else if ("MINIMUM".equalsIgnoreCase(version)) {
            this.setSftpVersionSelector((SftpVersionSelector)SftpVersionSelector.MINIMUM);
        } else {
            int fixedVersion = Integer.parseInt(version);
            ValidateUtils.checkTrue((fixedVersion >= 3 && fixedVersion <= 6 ? 1 : 0) != 0, (String)"Unsupported SFTP version: %s", (Object)version);
            this.setSftpVersionSelector((SftpVersionSelector)SftpVersionSelector.fixedVersionSelector((int)fixedVersion));
        }
    }

    public void setSftpVersionSelector(SftpVersionSelector selector) {
        this.versionSelector = Objects.requireNonNull(selector, "No version selector provided");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSession getSharedClientSession() {
        AtomicReference<ClientSession> atomicReference = this.sharedSessionHolder;
        synchronized (atomicReference) {
            return this.sharedSessionHolder.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSharedSession() {
        ClientSession sharedSession;
        AtomicReference<ClientSession> atomicReference = this.sharedSessionHolder;
        synchronized (atomicReference) {
            sharedSession = this.sharedSessionHolder.getAndSet(null);
        }
        if (sharedSession != null) {
            this.log.info("resetSharedSession - session={}", (Object)sharedSession);
            sharedSession.close(false).addListener((SshFutureListener)new SshFutureListener<CloseFuture>(){

                public void operationComplete(CloseFuture future) {
                    ApacheSshdSftpSessionFactory.this.log.info("resetSharedSession - session closed: {}", (Object)sharedSession);
                }
            });
        }
    }

    public void afterPropertiesSet() throws Exception {
        KeyPair kp = this.getPrivateKeyPair();
        Resource privateKeyLocation = this.getPrivateKeyLocation();
        ValidateUtils.checkState((GenericUtils.isNotEmpty((CharSequence)this.getPassword()) || kp != null || privateKeyLocation != null ? 1 : 0) != 0, (String)"Either password or private key must be provided");
        SshClient client = this.getSshClient();
        if (client == null) {
            client = this.createSshClientInstance();
            this.setSshClient(client);
        }
        if (!client.isStarted()) {
            this.log.info("afterPropertiesSet() - starting client");
            client.start();
            this.log.info("afterPropertiesSet() - client started");
        }
    }

    protected SshClient createSshClientInstance() throws Exception {
        return SshClient.setUpDefaultClient();
    }

    public void destroy() throws Exception {
        SshClient client = this.getSshClient();
        if (client != null && client.isOpen()) {
            this.log.info("destroy() - stopping client");
            client.close(false);
            this.log.info("destroy() - client stopped");
        }
    }

    protected KeyPair resolveKeyIdentity(ClientSession session) throws IOException, GeneralSecurityException {
        KeyPair kp = this.getPrivateKeyPair();
        if (kp != null) {
            return kp;
        }
        Resource location = this.getPrivateKeyLocation();
        if (location == null) {
            return null;
        }
        kp = this.loadPrivateKey(session, location, this.getPrivateKeyPassphrase());
        if (kp != null) {
            this.setPrivateKeyPair(kp);
        }
        return kp;
    }

    protected FilePasswordProvider resolveFilePasswordProvider(ClientSession session, Resource keyResource, String keyPassword) {
        FilePasswordProvider provider = this.getFilePasswordProvider();
        if (provider != null) {
            return provider;
        }
        return GenericUtils.isEmpty((CharSequence)keyPassword) ? FilePasswordProvider.EMPTY : FilePasswordProvider.of((String)keyPassword);
    }

    protected KeyPair loadPrivateKey(ClientSession session, Resource keyResource, String keyPassword) throws IOException, GeneralSecurityException {
        FilePasswordProvider provider;
        SpringIoResource location;
        Collection keyPairs;
        int numLoaded;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("loadPrivateKey({}) loading from {}", (Object)session, (Object)keyResource);
        }
        if ((numLoaded = GenericUtils.size((Collection)(keyPairs = PEMResourceParserUtils.PROXY.loadKeyPairs((SessionContext)session, (IoResource)(location = new SpringIoResource(keyResource)), provider = this.resolveFilePasswordProvider(session, keyResource, keyPassword))))) <= 0 && debugEnabled) {
            this.log.debug("loadPrivateKey({}) no keys loaded from {}", (Object)session, (Object)keyResource);
        }
        ValidateUtils.checkState((numLoaded == 1 ? 1 : 0) != 0, (String)"Multiple keys loaded from %s", (Object)keyResource);
        KeyPair kp = (KeyPair)GenericUtils.head((Iterable)keyPairs);
        if (debugEnabled) {
            PublicKey pubKey = kp.getPublic();
            this.log.debug("loadPrivateKey({}) loaded {} key={} from {}", new Object[]{session, KeyUtils.getKeyType((Key)pubKey), KeyUtils.getFingerPrint((PublicKey)pubKey), keyResource});
        }
        return kp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session<SftpClient.DirEntry> getSession() {
        SpringSftpSession springSftpSession;
        block14: {
            boolean sharedInstance = this.isSharedSession();
            ClientSession session = null;
            try {
                session = this.resolveClientSession(sharedInstance);
                SftpVersionSelector selector = this.getSftpVersionSelector();
                SftpClientFactory sftpFactory = SftpClientFactory.instance();
                SftpClient sftpClient = sftpFactory.createSftpClient(session, selector);
                ClientSession sessionInstance = session;
                SpringSftpSession result = sharedInstance ? new SpringSftpSession(sftpClient) : new SpringSftpSession(sftpClient, () -> {
                    try {
                        sessionInstance.close();
                        return null;
                    }
                    catch (Exception e) {
                        return e;
                    }
                });
                session = null;
                springSftpSession = result;
                if (session == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        finally {
                            if (sharedInstance) {
                                this.resetSharedSession();
                            }
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionUtils.toRuntimeException((Throwable)e);
                }
            }
            try {
                session.close();
            }
            finally {
                if (sharedInstance) {
                    this.resetSharedSession();
                }
            }
        }
        return springSftpSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSession resolveClientSession(boolean sharedInstance) throws Exception {
        ClientSession session;
        if (sharedInstance) {
            AtomicReference<ClientSession> atomicReference = this.sharedSessionHolder;
            synchronized (atomicReference) {
                session = this.sharedSessionHolder.get();
                if (session == null) {
                    session = this.createClientSession();
                }
                this.sharedSessionHolder.set(session);
            }
        } else {
            session = this.createClientSession();
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSession createClientSession() throws Exception {
        String hostname = ValidateUtils.checkNotNullAndNotEmpty((String)this.getHost(), (String)"Host must not be empty");
        String username = ValidateUtils.checkNotNullAndNotEmpty((String)this.getUsername(), (String)"User must not be empty");
        try (ClientSession session = this.createClientSession(hostname, username, this.getPort(), this.getEffectiveTimeoutValue(this.getConnectTimeout()));){
            session = this.configureClientSessionProperties(session, this.getSessionConfig());
            ClientSession newSession = session = this.authenticateClientSession(session, this.getEffectiveTimeoutValue(this.getAuthenticationTimeout()));
            if (this.log.isDebugEnabled()) {
                this.log.debug("createClientSession - session={}", (Object)session);
            }
            session = null;
            ClientSession clientSession = newSession;
            return clientSession;
        }
    }

    protected ClientSession createClientSession(String hostname, String username, int port, long timeout) throws IOException {
        SshClient client = this.getSshClient();
        if (this.log.isDebugEnabled()) {
            this.log.debug("createClientSession({}@{}:{}) waitTimeout={}", new Object[]{username, hostname, port, timeout});
        }
        ConnectFuture connectFuture = client.connect(username, hostname, port);
        return (ClientSession)((ConnectFuture)connectFuture.verify(timeout)).getSession();
    }

    protected ClientSession configureClientSessionProperties(ClientSession session, Properties props) throws IOException {
        if (MapEntryUtils.isEmpty((Map)props)) {
            return session;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        for (String propName : props.stringPropertyNames()) {
            String propValue = props.getProperty(propName);
            if (debugEnabled) {
                this.log.debug("configureClientSessionProperties({}) set {}={}", new Object[]{session, propName, propValue});
            }
            PropertyResolverUtils.updateProperty((PropertyResolver)session, (String)propName, (Object)propValue);
        }
        return session;
    }

    protected ClientSession authenticateClientSession(ClientSession session, long timeout) throws IOException, GeneralSecurityException {
        KeyPair privateKeyIdentity;
        boolean debugEnabled = this.log.isDebugEnabled();
        String passwordIdentity = this.getPassword();
        if (GenericUtils.isNotEmpty((CharSequence)passwordIdentity)) {
            if (debugEnabled) {
                this.log.debug("authenticateClientSession({}) using password identity", (Object)session);
            }
            session.addPasswordIdentity(passwordIdentity);
        }
        if ((privateKeyIdentity = this.resolveKeyIdentity(session)) != null) {
            if (debugEnabled) {
                PublicKey pubKey = privateKeyIdentity.getPublic();
                this.log.debug("authenticateClientSession({}) using {} key={}", new Object[]{session, KeyUtils.getKeyType((Key)pubKey), KeyUtils.getFingerPrint((PublicKey)pubKey)});
            }
            session.addPublicKeyIdentity(privateKeyIdentity);
        }
        if (debugEnabled) {
            this.log.debug("authenticateClientSession({}) authenticate - timeout={}", (Object)session, (Object)timeout);
        }
        session.auth().verify(timeout);
        return session;
    }

    protected long getEffectiveTimeoutValue(long timeoutSeconds) {
        if (timeoutSeconds < 151202820276307800L) {
            return TimeUnit.SECONDS.toMillis(timeoutSeconds);
        }
        return timeoutSeconds;
    }
}

