/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.impl.DefaultSslConfiguration;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConfigurationFactory {
    private final Logger LOG = LoggerFactory.getLogger(SslConfigurationFactory.class);
    private File keystoreFile = new File("./res/.keystore");
    private String keystorePass;
    private String keystoreType = KeyStore.getDefaultType();
    private String keystoreAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private File trustStoreFile;
    private String trustStorePass;
    private String trustStoreType = KeyStore.getDefaultType();
    private String trustStoreAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private String[] sslProtocols = new String[]{"TLSv1.2"};
    private ClientAuth clientAuth = ClientAuth.NONE;
    private String keyPass;
    private String keyAlias;
    private String[] enabledCipherSuites;

    public File getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(File keyStoreFile) {
        if (keyStoreFile == null || keyStoreFile.length() == 0L) {
            throw new FtpServerConfigurationException("KeystoreFile must not be null or zero length");
        }
        this.keystoreFile = keyStoreFile;
    }

    public String getKeystorePassword() {
        return this.keystorePass;
    }

    public void setKeystorePassword(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        if (keystoreType == null || keystoreType.length() == 0) {
            throw new FtpServerConfigurationException("KeystoreType must not be null or zero length");
        }
        this.keystoreType = keystoreType;
    }

    public String getKeystoreAlgorithm() {
        return this.keystoreAlgorithm;
    }

    public void setKeystoreAlgorithm(String keystoreAlgorithm) {
        if (keystoreAlgorithm == null || keystoreAlgorithm.length() == 0) {
            throw new FtpServerConfigurationException("KeystoreAlgorithm must not be null or zero length");
        }
        this.keystoreAlgorithm = keystoreAlgorithm;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public void setSslProtocol(String ... sslProtocols) {
        if (sslProtocols == null || sslProtocols.length == 0) {
            throw new FtpServerConfigurationException("SslProcotol must not be null or zero length");
        }
        this.sslProtocols = sslProtocols;
    }

    public void setClientAuthentication(String clientAuthReqd) {
        this.clientAuth = "true".equalsIgnoreCase(clientAuthReqd) || "yes".equalsIgnoreCase(clientAuthReqd) || "need".equalsIgnoreCase(clientAuthReqd) ? ClientAuth.NEED : ("want".equalsIgnoreCase(clientAuthReqd) ? ClientAuth.WANT : ClientAuth.NONE);
    }

    public String getKeyPassword() {
        return this.keyPass;
    }

    public void setKeyPassword(String keyPass) {
        this.keyPass = keyPass;
    }

    public File getTruststoreFile() {
        return this.trustStoreFile;
    }

    public void setTruststoreFile(File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getTruststorePassword() {
        return this.trustStorePass;
    }

    public void setTruststorePassword(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    public String getTruststoreType() {
        return this.trustStoreType;
    }

    public void setTruststoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTruststoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public void setTruststoreAlgorithm(String trustStoreAlgorithm) {
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadStore(File storeFile, String storeType, String storePass) throws IOException, GeneralSecurityException {
        KeyStore keyStore;
        InputStream fin = null;
        try {
            if (storeFile.exists()) {
                this.LOG.debug("Trying to load store from file");
                fin = new FileInputStream(storeFile);
            } else {
                this.LOG.debug("Trying to load store from classpath");
                fin = this.getClass().getClassLoader().getResourceAsStream(storeFile.getPath());
                if (fin == null) {
                    throw new FtpServerConfigurationException("Key store could not be loaded from " + storeFile.getPath());
                }
            }
            KeyStore store = KeyStore.getInstance(storeType);
            store.load(fin, storePass.toCharArray());
            keyStore = store;
        }
        catch (Throwable throwable) {
            IoUtils.close(fin);
            throw throwable;
        }
        IoUtils.close(fin);
        return keyStore;
    }

    public SslConfiguration createSslConfiguration() {
        try {
            KeyStore trustStore;
            this.LOG.debug("Loading key store from \"{}\", using the key store type \"{}\"", (Object)this.keystoreFile.getAbsolutePath(), (Object)this.keystoreType);
            KeyStore keyStore = this.loadStore(this.keystoreFile, this.keystoreType, this.keystorePass);
            if (this.trustStoreFile != null) {
                this.LOG.debug("Loading trust store from \"{}\", using the key store type \"{}\"", (Object)this.trustStoreFile.getAbsolutePath(), (Object)this.trustStoreType);
                trustStore = this.loadStore(this.trustStoreFile, this.trustStoreType, this.trustStorePass);
            } else {
                trustStore = keyStore;
            }
            String keyPassToUse = this.keyPass == null ? this.keystorePass : this.keyPass;
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.keystoreAlgorithm);
            keyManagerFactory.init(keyStore, keyPassToUse.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.trustStoreAlgorithm);
            trustManagerFactory.init(trustStore);
            return new DefaultSslConfiguration(keyManagerFactory, trustManagerFactory, this.clientAuth, this.sslProtocols, this.enabledCipherSuites, this.keyAlias);
        }
        catch (Exception ex) {
            this.LOG.error("DefaultSsl.configure()", (Throwable)ex);
            throw new FtpServerConfigurationException("DefaultSsl.configure()", ex);
        }
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public String[] getEnabledCipherSuites() {
        if (this.enabledCipherSuites != null) {
            return (String[])this.enabledCipherSuites.clone();
        }
        return null;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites != null ? (String[])enabledCipherSuites.clone() : null;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }
}

