/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration.processor;

import java.util.Enumeration;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.processor.AbstractConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

public class ResourceBundleConfigurationResourceHandler
extends AbstractConfigurationResourceHandler {
    public String getId() {
        return "resourcebundle-configuration-resource";
    }

    public PlexusConfiguration[] handleRequest(Map parameters) throws ConfigurationResourceNotFoundException, ConfigurationProcessingException {
        ResourceBundle bundle;
        String bundleName = this.getSource(parameters);
        try {
            bundle = ResourceBundle.getBundle(bundleName);
        }
        catch (MissingResourceException e) {
            throw new ConfigurationResourceNotFoundException("The specified resource " + bundleName + " cannot be found.");
        }
        PlexusConfiguration[] ret = new PlexusConfiguration[]{new XmlPlexusConfiguration(bundleName)};
        Enumeration<String> props = bundle.getKeys();
        while (props.hasMoreElements()) {
            String prop = props.nextElement();
            XmlPlexusConfiguration conf = new XmlPlexusConfiguration(prop);
            conf.setValue(bundle.getString(prop));
            ret[0].addChild(conf);
        }
        return ret;
    }
}

