/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.UnitConverter;

public abstract class LinearConverter
extends UnitConverter {
    private static final long serialVersionUID = 1L;

    public UnitConverter concatenate(UnitConverter converter) {
        if (converter == IDENTITY) {
            return this;
        }
        if (!(converter instanceof LinearConverter)) {
            return super.concatenate(converter);
        }
        return new CompoundLinear(this, (LinearConverter)converter);
    }

    public abstract LinearConverter inverse();

    private static class CompoundLinear
    extends LinearConverter {
        private final LinearConverter _first;
        private final LinearConverter _second;
        private static final long serialVersionUID = 1L;

        private CompoundLinear(LinearConverter first, LinearConverter second) {
            this._first = first;
            this._second = second;
        }

        public LinearConverter inverse() {
            return new CompoundLinear(this._second.inverse(), this._first.inverse());
        }

        public double convert(double value) {
            return this._second.convert(this._first.convert(value));
        }

        public BigDecimal convert(BigDecimal value, MathContext ctx) {
            return this._second.convert(this._first.convert(value, ctx), ctx);
        }

        public boolean equals(Object cvtr) {
            if (this == cvtr) {
                return true;
            }
            if (!(cvtr instanceof CompoundLinear)) {
                return false;
            }
            CompoundLinear that = (CompoundLinear)cvtr;
            return this._first.equals(that._first) && this._second.equals(that._second);
        }

        public int hashCode() {
            return this._first.hashCode() + this._second.hashCode();
        }
    }
}

