/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbtractMultiParameterMathFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class MinMax
extends AbtractMultiParameterMathFunction {
    MinMax() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression functionCall, HiddenTokenAwareTree token) {
        Iterator<Expression> expanded = this.expandLists(splitParameters).iterator();
        Expression next = expanded.next();
        while (expanded.hasNext() && next.getType() != ASTCssNodeType.NUMBER) {
            next = expanded.next();
        }
        if (next.getType() != ASTCssNodeType.NUMBER) {
            return new FunctionExpression(token, this.getName(), null);
        }
        NumberExpression result = (NumberExpression)next;
        while (expanded.hasNext()) {
            next = expanded.next();
            if (next.getType() != ASTCssNodeType.NUMBER) continue;
            NumberExpression nextNum = (NumberExpression)next;
            if (!result.convertibleTo(nextNum)) {
                problemsHandler.errorIncompatibleTypesCompared(functionCall, result.getSuffix(), nextNum.getSuffix());
                return new FaultyExpression(functionCall);
            }
            result = this.compareCompatible(result, nextNum);
        }
        return result;
    }

    protected abstract NumberExpression compareCompatible(NumberExpression var1, NumberExpression var2);

    private List<Expression> expandLists(List<Expression> splitParameters) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression expression : splitParameters) {
            if (expression instanceof ListExpression) {
                ListExpression list = (ListExpression)expression;
                result.addAll(this.expandLists(list.getExpressions()));
                continue;
            }
            result.add(expression);
        }
        return result;
    }

    @Override
    protected int getMaxParameters() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        return true;
    }

    @Override
    protected int getMinParameters() {
        return 1;
    }
}

