/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.result.Result;

public class StatementHandler
extends Statement {
    public static final int NONE = 0;
    public static final int SQL_EXCEPTION = 1;
    public static final int SQL_WARNING = 2;
    public static final int SQL_NOT_FOUND = 3;
    public static final int SQL_STATE = 4;
    public static final int CONTINUE = 5;
    public static final int EXIT = 6;
    public static final int UNDO = 7;
    public final int handlerType;
    OrderedIntHashSet conditionGroups = new OrderedIntHashSet();
    OrderedHashSet conditionStates = new OrderedHashSet();
    Statement statement;
    public static final StatementHandler[] emptyExceptionHandlerArray = new StatementHandler[0];

    StatementHandler(int n) {
        super(1212, 2007);
        this.handlerType = n;
    }

    public void addConditionState(String string) {
        boolean bl = this.conditionStates.add(string);
        if (!(bl &= this.conditionGroups.isEmpty())) {
            throw Error.error(5604);
        }
    }

    public void addConditionType(int n) {
        boolean bl = this.conditionGroups.add(n);
        if (!(bl &= this.conditionStates.isEmpty())) {
            throw Error.error(5604);
        }
    }

    public void addStatement(Statement statement) {
        this.statement = statement;
    }

    public boolean handlesConditionType(int n) {
        return this.conditionGroups.contains(n);
    }

    public boolean handlesCondition(String string) {
        if (this.conditionStates.contains(string)) {
            return true;
        }
        String string2 = string.substring(0, 2);
        if (this.conditionStates.contains(string2)) {
            return true;
        }
        if (string2.equals("01")) {
            return this.conditionGroups.contains(2);
        }
        if (string2.equals("02")) {
            return this.conditionGroups.contains(3);
        }
        return this.conditionGroups.contains(1);
    }

    public int[] getConditionTypes() {
        return this.conditionGroups.toArray();
    }

    public String[] getConditionStates() {
        Object[] objectArray = new String[this.conditionStates.size()];
        this.conditionStates.toArray(objectArray);
        return objectArray;
    }

    @Override
    public void resolve(Session session) {
        if (this.statement != null) {
            this.statement.resolve(session);
            this.readTableNames = this.statement.getTableNamesForRead();
            this.writeTableNames = this.statement.getTableNamesForWrite();
        }
    }

    @Override
    public Result execute(Session session) {
        if (this.statement != null) {
            return this.statement.execute(session);
        }
        return Result.updateZeroResult;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public OrderedHashSet getReferences() {
        if (this.statement == null) {
            return new OrderedHashSet();
        }
        return this.statement.getReferences();
    }

    @Override
    public String getSQL() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(64);
        String string = this.handlerType == 5 ? "CONTINUE" : (this.handlerType == 6 ? "EXIT" : "UNDO");
        stringBuffer.append("DECLARE").append(' ').append(string).append(' ');
        stringBuffer.append("HANDLER").append(' ').append("FOR");
        stringBuffer.append(' ');
        for (n = 0; n < this.conditionStates.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("SQLSTATE").append(' ');
            stringBuffer.append('\'').append(this.conditionStates.get(n)).append('\'');
        }
        block6: for (n = 0; n < this.conditionGroups.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            switch (this.conditionGroups.get(n)) {
                case 1: {
                    stringBuffer.append("SQLEXCEPTION");
                    continue block6;
                }
                case 2: {
                    stringBuffer.append("SQLWARNING");
                    continue block6;
                }
                case 3: {
                    stringBuffer.append("NOT").append(' ').append(404);
                }
            }
        }
        if (this.statement != null) {
            stringBuffer.append(' ').append(this.statement.getSQL());
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isCatalogLock() {
        return false;
    }

    @Override
    public boolean isCatalogChange() {
        return false;
    }
}

