/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public class HistogramBuilder
extends ValuesSourceAggregationBuilder<HistogramBuilder> {
    private Long interval;
    private Histogram.Order order;
    private Long minDocCount;

    public HistogramBuilder(String name) {
        super(name, InternalHistogram.TYPE.name());
    }

    public HistogramBuilder interval(long interval) {
        this.interval = interval;
        return this;
    }

    public HistogramBuilder order(Histogram.Order order) {
        this.order = order;
        return this;
    }

    public HistogramBuilder minDocCount(long minDocCount) {
        this.minDocCount = minDocCount;
        return this;
    }

    @Override
    protected XContentBuilder doInternalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.interval == null) {
            throw new SearchSourceBuilderException("[interval] must be defined for histogram aggregation [" + this.name + "]");
        }
        builder.field("interval", this.interval);
        if (this.order != null) {
            builder.field("order");
            this.order.toXContent(builder, params);
        }
        if (this.minDocCount != null) {
            builder.field("min_doc_count", this.minDocCount);
        }
        return builder;
    }
}

