/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.regex.Pattern;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PatternAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class PatternAnalyzerProvider
extends AbstractIndexAnalyzerProvider<PatternAnalyzer> {
    private final PatternAnalyzer analyzer;

    @Inject
    public PatternAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        Version esVersion = indexSettings.getAsVersion("index.version.created", Version.CURRENT);
        CharArraySet defaultStopwords = esVersion.onOrAfter(Version.V_1_0_0_RC1) ? CharArraySet.EMPTY_SET : StopAnalyzer.ENGLISH_STOP_WORDS_SET;
        boolean lowercase = settings.getAsBoolean("lowercase", (Boolean)true);
        CharArraySet stopWords = Analysis.parseStopWords(env, settings, defaultStopwords, this.version);
        String sPattern = settings.get("pattern", "\\W+");
        if (sPattern == null) {
            throw new ElasticsearchIllegalArgumentException("Analyzer [" + name + "] of type pattern must have a `pattern` set");
        }
        Pattern pattern = Regex.compile(sPattern, settings.get("flags"));
        this.analyzer = new PatternAnalyzer(this.version, pattern, lowercase, stopWords);
    }

    @Override
    public PatternAnalyzer get() {
        return this.analyzer;
    }
}

