/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.exception.InvalidShapeException;

public class ParseUtils {
    private ParseUtils() {
    }

    public static String[] parsePoint(String[] out, String externalVal, int dimension) throws InvalidShapeException {
        int i;
        int idx;
        if (out == null || out.length != dimension) {
            out = new String[dimension];
        }
        int end = idx = externalVal.indexOf(44);
        int start = 0;
        if (idx == -1 && dimension == 1 && externalVal.length() > 0) {
            out[0] = externalVal.trim();
            i = 1;
        } else if (idx > 0) {
            for (i = 0; i < dimension; ++i) {
                while (start < end && externalVal.charAt(start) == ' ') {
                    ++start;
                }
                while (end > start && externalVal.charAt(end - 1) == ' ') {
                    --end;
                }
                if (start == end) break;
                out[i] = externalVal.substring(start, end);
                start = idx + 1;
                idx = end = externalVal.indexOf(44, start);
                if (end != -1) continue;
                end = externalVal.length();
            }
        }
        if (i != dimension) {
            throw new InvalidShapeException("incompatible dimension (" + dimension + ") and values (" + externalVal + ").  Only " + i + " values specified");
        }
        return out;
    }

    public static double[] parsePointDouble(double[] out, String externalVal, int dimension) throws InvalidShapeException {
        int i;
        int idx;
        if (out == null || out.length != dimension) {
            out = new double[dimension];
        }
        int end = idx = externalVal.indexOf(44);
        int start = 0;
        if (idx == -1 && dimension == 1 && externalVal.length() > 0) {
            out[0] = Double.parseDouble(externalVal.trim());
            i = 1;
        } else if (idx > 0) {
            for (i = 0; i < dimension; ++i) {
                while (start < end && externalVal.charAt(start) == ' ') {
                    ++start;
                }
                while (end > start && externalVal.charAt(end - 1) == ' ') {
                    --end;
                }
                if (start == end) break;
                out[i] = Double.parseDouble(externalVal.substring(start, end));
                start = idx + 1;
                idx = end = externalVal.indexOf(44, start);
                if (end != -1) continue;
                end = externalVal.length();
            }
        }
        if (i != dimension) {
            throw new InvalidShapeException("incompatible dimension (" + dimension + ") and values (" + externalVal + ").  Only " + i + " values specified");
        }
        return out;
    }

    public static final double[] parseLatitudeLongitude(String latLonStr) throws InvalidShapeException {
        return ParseUtils.parseLatitudeLongitude(null, latLonStr);
    }

    public static final double[] parseLatitudeLongitude(double[] latLon, String latLonStr) throws InvalidShapeException {
        double[] toks;
        if (latLon == null) {
            latLon = new double[2];
        }
        if ((toks = ParseUtils.parsePointDouble(null, latLonStr, 2))[0] < -90.0 || toks[0] > 90.0) {
            throw new InvalidShapeException("Invalid latitude: latitudes are range -90 to 90: provided lat: [" + toks[0] + "]");
        }
        latLon[0] = toks[0];
        if (toks[1] < -180.0 || toks[1] > 180.0) {
            throw new InvalidShapeException("Invalid longitude: longitudes are range -180 to 180: provided lon: [" + toks[1] + "]");
        }
        latLon[1] = toks[1];
        return latLon;
    }
}

