/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import org.elasticsearch.ElasticsearchIllegalArgumentException;

public enum SnapshotState {
    IN_PROGRESS(0),
    SUCCESS(1),
    FAILED(2);

    private byte value;

    private SnapshotState(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public boolean completed() {
        return this == SUCCESS || this == FAILED;
    }

    public static SnapshotState fromValue(byte value) {
        switch (value) {
            case 0: {
                return IN_PROGRESS;
            }
            case 1: {
                return SUCCESS;
            }
            case 2: {
                return FAILED;
            }
        }
        throw new ElasticsearchIllegalArgumentException("No snapshot state for value [" + value + "]");
    }
}

