/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatterStreams;

public class InternalHistogram<B extends Bucket>
extends InternalAggregation
implements Histogram {
    static final InternalAggregation.Type TYPE = new InternalAggregation.Type("histogram", "histo");
    static final Factory FACTORY = new Factory();
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalHistogram readResult(StreamInput in) throws IOException {
            InternalHistogram histogram = new InternalHistogram();
            histogram.readFrom(in);
            return histogram;
        }
    };
    private List<B> buckets;
    private LongObjectOpenHashMap<B> bucketsMap;
    private InternalOrder order;
    private ValueFormatter formatter;
    private boolean keyed;
    private long minDocCount;
    private EmptyBucketInfo emptyBucketInfo;

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalHistogram() {
    }

    InternalHistogram(String name, List<B> buckets, InternalOrder order, long minDocCount, EmptyBucketInfo emptyBucketInfo, ValueFormatter formatter, boolean keyed) {
        super(name);
        this.buckets = buckets;
        this.order = order;
        assert (minDocCount == 0L == (emptyBucketInfo != null));
        this.minDocCount = minDocCount;
        this.emptyBucketInfo = emptyBucketInfo;
        this.formatter = formatter;
        this.keyed = keyed;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    public Collection<B> getBuckets() {
        return this.buckets;
    }

    @Override
    public B getBucketByKey(String key) {
        return (B)this.getBucketByKey(Long.valueOf(key));
    }

    public B getBucketByKey(Number key) {
        if (this.bucketsMap == null) {
            this.bucketsMap = new LongObjectOpenHashMap(this.buckets.size());
            for (Bucket bucket : this.buckets) {
                this.bucketsMap.put(bucket.key, bucket);
            }
        }
        return (B)((Bucket)this.bucketsMap.get(key.longValue()));
    }

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        if (aggregations.size() == 1) {
            InternalHistogram histo = (InternalHistogram)aggregations.get(0);
            if (this.minDocCount == 1L) {
                for (Bucket bucket : histo.buckets) {
                    bucket.aggregations.reduce(reduceContext.cacheRecycler());
                }
                return histo;
            }
            CollectionUtil.introSort(histo.buckets, this.order.asc ? InternalOrder.KEY_ASC.comparator() : InternalOrder.KEY_DESC.comparator());
            List<B> list = this.order.asc ? histo.buckets : Lists.reverse(histo.buckets);
            Bucket prevBucket = null;
            ListIterator<B> iter = list.listIterator();
            if (this.minDocCount == 0L) {
                while (iter.hasNext()) {
                    Bucket nextBucket = (Bucket)list.get(iter.nextIndex());
                    nextBucket.aggregations.reduce(reduceContext.cacheRecycler());
                    if (prevBucket != null) {
                        long key = this.emptyBucketInfo.rounding.nextRoundingValue(prevBucket.key);
                        while (key != nextBucket.key) {
                            iter.add(this.createBucket(key, 0L, this.emptyBucketInfo.subAggregations, this.formatter));
                            key = this.emptyBucketInfo.rounding.nextRoundingValue(key);
                        }
                    }
                    prevBucket = (Bucket)iter.next();
                }
            } else {
                while (iter.hasNext()) {
                    Bucket bucket = (Bucket)iter.next();
                    if (bucket.getDocCount() < this.minDocCount) {
                        iter.remove();
                        continue;
                    }
                    bucket.aggregations.reduce(reduceContext.cacheRecycler());
                }
            }
            if (this.order != InternalOrder.KEY_ASC && this.order != InternalOrder.KEY_DESC) {
                CollectionUtil.introSort(histo.buckets, this.order.comparator());
            }
            return histo;
        }
        InternalHistogram reduced = (InternalHistogram)aggregations.get(0);
        Recycler.V bucketsByKey = reduceContext.cacheRecycler().longObjectMap(-1);
        for (InternalAggregation aggregation : aggregations) {
            InternalHistogram histogram = (InternalHistogram)aggregation;
            for (Bucket bucket : histogram.buckets) {
                ArrayList<Bucket> bucketList = (ArrayList<Bucket>)bucketsByKey.v().get(bucket.key);
                if (bucketList == null) {
                    bucketList = new ArrayList<Bucket>(aggregations.size());
                    bucketsByKey.v().put(bucket.key, bucketList);
                }
                bucketList.add(bucket);
            }
        }
        ArrayList<B> reducedBuckets = new ArrayList<B>(bucketsByKey.v().size());
        VType[] buckets = bucketsByKey.v().values;
        boolean[] allocated = bucketsByKey.v().allocated;
        for (int i = 0; i < allocated.length; ++i) {
            Bucket bucket;
            if (!allocated[i] || (bucket = ((Bucket)((List)buckets[i]).get(0)).reduce((List)buckets[i], reduceContext.cacheRecycler())).getDocCount() < this.minDocCount) continue;
            reducedBuckets.add(bucket);
        }
        bucketsByKey.release();
        if (this.minDocCount == 0L) {
            CollectionUtil.introSort(reducedBuckets, this.order.asc ? InternalOrder.KEY_ASC.comparator() : InternalOrder.KEY_DESC.comparator());
            List<B> list = this.order.asc ? reducedBuckets : Lists.reverse(reducedBuckets);
            Bucket prevBucket = null;
            ListIterator<B> iter = list.listIterator();
            while (iter.hasNext()) {
                Bucket nextBucket = (Bucket)list.get(iter.nextIndex());
                if (prevBucket != null) {
                    long key = this.emptyBucketInfo.rounding.nextRoundingValue(prevBucket.key);
                    while (key != nextBucket.key) {
                        iter.add(this.createBucket(key, 0L, this.emptyBucketInfo.subAggregations, this.formatter));
                        key = this.emptyBucketInfo.rounding.nextRoundingValue(key);
                    }
                }
                prevBucket = (Bucket)iter.next();
            }
            if (this.order != InternalOrder.KEY_ASC && this.order != InternalOrder.KEY_DESC) {
                CollectionUtil.introSort(reducedBuckets, this.order.comparator());
            }
        } else {
            CollectionUtil.introSort(reducedBuckets, this.order.comparator());
        }
        reduced.buckets = reducedBuckets;
        return reduced;
    }

    protected B createBucket(long key, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
        return (B)new Bucket(key, docCount, aggregations);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.order = InternalOrder.Streams.readOrder(in);
        this.minDocCount = in.readVLong();
        if (this.minDocCount == 0L) {
            this.emptyBucketInfo = EmptyBucketInfo.readFrom(in);
        }
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<B> buckets = new ArrayList<B>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(this.createBucket(in.readLong(), in.readVLong(), InternalAggregations.readAggregations(in), this.formatter));
        }
        this.buckets = buckets;
        this.bucketsMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        InternalOrder.Streams.writeOrder(this.order, out);
        out.writeVLong(this.minDocCount);
        if (this.minDocCount == 0L) {
            EmptyBucketInfo.writeTo(this.emptyBucketInfo, out);
        }
        ValueFormatterStreams.writeOptional(this.formatter, out);
        out.writeBoolean(this.keyed);
        out.writeVInt(this.buckets.size());
        for (Bucket bucket : this.buckets) {
            out.writeLong(bucket.key);
            out.writeVLong(bucket.docCount);
            bucket.aggregations.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.keyed) {
            builder.startObject(InternalAggregation.CommonFields.BUCKETS);
        } else {
            builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        }
        for (Bucket bucket : this.buckets) {
            if (this.formatter != null) {
                StringText keyTxt = new StringText(this.formatter.format(bucket.key));
                if (this.keyed) {
                    builder.startObject(keyTxt.string());
                } else {
                    builder.startObject();
                }
                builder.field(InternalAggregation.CommonFields.KEY_AS_STRING, (Text)keyTxt);
            } else if (this.keyed) {
                builder.startObject(String.valueOf(bucket.getKeyAsNumber()));
            } else {
                builder.startObject();
            }
            builder.field(InternalAggregation.CommonFields.KEY, bucket.key);
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, bucket.docCount);
            bucket.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder.endObject();
    }

    static class Factory<B extends Bucket> {
        protected Factory() {
        }

        public String type() {
            return TYPE.name();
        }

        public InternalHistogram<B> create(String name, List<B> buckets, InternalOrder order, long minDocCount, EmptyBucketInfo emptyBucketInfo, ValueFormatter formatter, boolean keyed) {
            return new InternalHistogram<B>(name, buckets, order, minDocCount, emptyBucketInfo, formatter, keyed);
        }

        public B createBucket(long key, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
            return (B)new Bucket(key, docCount, aggregations);
        }
    }

    static class EmptyBucketInfo {
        final Rounding rounding;
        final InternalAggregations subAggregations;

        EmptyBucketInfo(Rounding rounding, InternalAggregations subAggregations) {
            this.rounding = rounding;
            this.subAggregations = subAggregations;
        }

        public static EmptyBucketInfo readFrom(StreamInput in) throws IOException {
            return new EmptyBucketInfo(Rounding.Streams.read(in), InternalAggregations.readAggregations(in));
        }

        public static void writeTo(EmptyBucketInfo info, StreamOutput out) throws IOException {
            Rounding.Streams.write(info.rounding, out);
            info.subAggregations.writeTo(out);
        }
    }

    public static class Bucket
    implements Histogram.Bucket {
        long key;
        long docCount;
        InternalAggregations aggregations;

        public Bucket(long key, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        @Override
        public String getKey() {
            return String.valueOf(this.key);
        }

        @Override
        public Text getKeyAsText() {
            return new StringText(this.getKey());
        }

        @Override
        public Number getKeyAsNumber() {
            return this.key;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        <B extends Bucket> B reduce(List<B> buckets, CacheRecycler cacheRecycler) {
            if (buckets.size() == 1) {
                Bucket bucket = (Bucket)buckets.get(0);
                bucket.aggregations.reduce(cacheRecycler);
                return (B)bucket;
            }
            ArrayList<InternalAggregations> aggregations = new ArrayList<InternalAggregations>(buckets.size());
            Bucket reduced = null;
            for (Bucket bucket : buckets) {
                if (reduced == null) {
                    reduced = bucket;
                } else {
                    reduced.docCount += bucket.docCount;
                }
                aggregations.add((InternalAggregations)bucket.getAggregations());
            }
            reduced.aggregations = InternalAggregations.reduce(aggregations, cacheRecycler);
            return (B)reduced;
        }
    }
}

