/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.percolate;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.percolate.MultiPercolateRequest;
import org.elasticsearch.action.percolate.MultiPercolateResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestMultiPercolateAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;

    @Inject
    public RestMultiPercolateAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/_mpercolate", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mpercolate", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mpercolate", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mpercolate", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mpercolate", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mpercolate", this);
        this.allowExplicitIndex = settings.getAsBoolean("rest.action.multi.allow_explicit_index", (Boolean)true);
    }

    @Override
    public void handleRequest(final RestRequest restRequest, final RestChannel restChannel) {
        MultiPercolateRequest multiPercolateRequest = new MultiPercolateRequest();
        multiPercolateRequest.indicesOptions(IndicesOptions.fromRequest(restRequest, multiPercolateRequest.indicesOptions()));
        multiPercolateRequest.indices(Strings.splitStringByCommaToArray(restRequest.param("index")));
        multiPercolateRequest.documentType(restRequest.param("type"));
        try {
            multiPercolateRequest.add(RestActions.getRestContent(restRequest), restRequest.contentUnsafe(), this.allowExplicitIndex);
        }
        catch (Exception e) {
            try {
                restChannel.sendResponse(new XContentThrowableRestResponse(restRequest, e));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.multiPercolate(multiPercolateRequest, new ActionListener<MultiPercolateResponse>(){

            @Override
            public void onResponse(MultiPercolateResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(restRequest);
                    response.toXContent(builder, restRequest);
                    restChannel.sendResponse(new XContentRestResponse(restRequest, RestStatus.OK, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    restChannel.sendResponse(new XContentThrowableRestResponse(restRequest, e));
                }
                catch (IOException e1) {
                    RestMultiPercolateAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

